/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.util.SoftValue;

public class SoftValueMap<K, V>
implements Map<K, V> {
    private final Map<K, SoftValue<K, V>> internalMap = new HashMap<K, SoftValue<K, V>>();
    private final ReferenceQueue<?> rq;

    public SoftValueMap() {
        this(new ReferenceQueue());
    }

    public SoftValueMap(ReferenceQueue<?> rq) {
        this.rq = rq;
    }

    public int checkReferences() {
        int i = 0;
        Reference<?> obj = null;
        while ((obj = this.rq.poll()) != null) {
            ++i;
            this.internalMap.remove(((SoftValue)obj).getKey());
        }
        return i;
    }

    @Override
    public V put(K key, V value) {
        this.checkReferences();
        SoftValue<K, V> oldValue = this.internalMap.put(key, new SoftValue<K, V>(key, value, this.rq));
        return oldValue == null ? null : (V)oldValue.get();
    }

    @Override
    public void putAll(Map map) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public V get(Object key) {
        this.checkReferences();
        SoftValue<K, V> value = this.internalMap.get(key);
        if (value == null) {
            return null;
        }
        if (value.get() == null) {
            this.internalMap.remove(key);
            return null;
        }
        return (V)value.get();
    }

    @Override
    public V remove(Object key) {
        this.checkReferences();
        SoftValue<K, V> value = this.internalMap.remove(key);
        return value == null ? null : (V)value.get();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkReferences();
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Don't support containsValue!");
    }

    @Override
    public boolean isEmpty() {
        this.checkReferences();
        return this.internalMap.isEmpty();
    }

    @Override
    public int size() {
        this.checkReferences();
        return this.internalMap.size();
    }

    @Override
    public void clear() {
        this.checkReferences();
        this.internalMap.clear();
    }

    @Override
    public Set<K> keySet() {
        this.checkReferences();
        return this.internalMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.checkReferences();
        Set<Map.Entry<K, SoftValue<K, V>>> entries = this.internalMap.entrySet();
        HashSet<Map.Entry<K, V>> real_entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, SoftValue<K, V>> entry : entries) {
            real_entries.add(entry.getValue());
        }
        return real_entries;
    }

    @Override
    public Collection<V> values() {
        this.checkReferences();
        Collection<SoftValue<K, V>> softValues = this.internalMap.values();
        ArrayList hardValues = new ArrayList();
        for (SoftValue<K, V> softValue : softValues) {
            hardValues.add(softValue.get());
        }
        return hardValues;
    }
}

