/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Threads {
    protected static final Log LOG = LogFactory.getLog(Threads.class);

    public static Thread setDaemonThreadRunning(Thread t, String name) {
        return Threads.setDaemonThreadRunning(t, name, null);
    }

    public static Thread setDaemonThreadRunning(Thread t, String name, Thread.UncaughtExceptionHandler handler) {
        t.setName(name);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static void shutdown(Thread t) {
        Threads.shutdown(t, 0L);
    }

    public static void shutdown(Thread t, long joinwait) {
        while (t.isAlive()) {
            try {
                t.join(joinwait);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)(t.getName() + "; joinwait=" + joinwait), (Throwable)e);
            }
        }
    }
}

