/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

public class HQuorumPeer
implements HConstants {
    private static final Log LOG = LogFactory.getLog(HQuorumPeer.class);
    private static final String VARIABLE_START = "${";
    private static final int VARIABLE_START_LENGTH = "${".length();
    private static final String VARIABLE_END = "}";
    private static final int VARIABLE_END_LENGTH = "}".length();
    private static final String ZK_CFG_PROPERTY = "hbase.zookeeper.property.";
    private static final int ZK_CFG_PROPERTY_SIZE = "hbase.zookeeper.property.".length();

    public static void main(String[] args) {
        HBaseConfiguration conf = new HBaseConfiguration();
        try {
            Properties zkProperties = HQuorumPeer.makeZKProps(conf);
            HQuorumPeer.writeMyID(zkProperties);
            QuorumPeerConfig zkConfig = new QuorumPeerConfig();
            zkConfig.parseProperties(zkProperties);
            HQuorumPeer.runZKServer(zkConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void runZKServer(QuorumPeerConfig zkConfig) throws UnknownHostException, IOException {
        if (zkConfig.isDistributed()) {
            QuorumPeerMain qp = new QuorumPeerMain();
            qp.runFromConfig(zkConfig);
        } else {
            ZooKeeperServerMain zk = new ZooKeeperServerMain();
            ServerConfig serverConfig = new ServerConfig();
            serverConfig.readFrom(zkConfig);
            zk.runFromConfig(serverConfig);
        }
    }

    private static boolean addressIsLocalHost(String address) {
        return address.equals("localhost") || address.equals("127.0.0.1");
    }

    private static void writeMyID(Properties properties) throws IOException {
        long myId = -1L;
        HBaseConfiguration conf = new HBaseConfiguration();
        String myAddress = DNS.getDefaultHost((String)conf.get("hbase.zookeeper.dns.interface", "default"), (String)conf.get("hbase.zookeeper.dns.nameserver", "default"));
        ArrayList<String> ips = new ArrayList<String>();
        ips.add(myAddress.contains(".") ? myAddress : StringUtils.simpleHostname((String)myAddress));
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            Enumeration<InetAddress> rawAdrs = nics.nextElement().getInetAddresses();
            while (rawAdrs.hasMoreElements()) {
                InetAddress inet = rawAdrs.nextElement();
                ips.add(StringUtils.simpleHostname((String)inet.getHostName()));
                ips.add(inet.getHostAddress());
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (!key.startsWith("server.")) continue;
            int dot = key.indexOf(46);
            long id = Long.parseLong(key.substring(dot + 1));
            String[] parts = value.split(":");
            String address = parts[0];
            if (!HQuorumPeer.addressIsLocalHost(address) && !ips.contains(address)) continue;
            myId = id;
            break;
        }
        if (myId == -1L) {
            throw new IOException("Could not find my address: " + myAddress + " in list of ZooKeeper quorum servers");
        }
        String dataDirStr = properties.get("dataDir").toString().trim();
        File dataDir = new File(dataDirStr);
        if (!dataDir.isDirectory() && !dataDir.mkdirs()) {
            throw new IOException("Unable to create data dir " + dataDir);
        }
        File myIdFile = new File(dataDir, "myid");
        PrintWriter w = new PrintWriter(myIdFile);
        w.println(myId);
        w.close();
    }

    public static Properties makeZKProps(HBaseConfiguration conf) {
        ClassLoader cl = HQuorumPeer.class.getClassLoader();
        InputStream inputStream = cl.getResourceAsStream("zoo.cfg");
        if (inputStream != null) {
            try {
                return HQuorumPeer.parseZooCfg(conf, inputStream);
            }
            catch (IOException e) {
                LOG.warn((Object)"Cannot read zoo.cfg, loading from XML files", (Throwable)e);
            }
        }
        Properties zkProperties = new Properties();
        Iterator i$ = conf.iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(ZK_CFG_PROPERTY)) continue;
            String zkKey = key.substring(ZK_CFG_PROPERTY_SIZE);
            String value = (String)entry.getValue();
            if (value.contains(VARIABLE_START)) {
                value = conf.get(key);
            }
            zkProperties.put(zkKey, value);
        }
        int peerPort = conf.getInt("hbase.zookeeper.peerport", 2888);
        int leaderPort = conf.getInt("hbase.zookeeper.leaderport", 3888);
        String[] serverHosts = conf.getStrings("hbase.zookeeper.quorum", new String[]{"localhost"});
        for (int i = 0; i < serverHosts.length; ++i) {
            String serverHost = serverHosts[i];
            String address = serverHost + ":" + peerPort + ":" + leaderPort;
            String key = "server." + i;
            zkProperties.put(key, address);
        }
        return zkProperties;
    }

    public static Properties parseZooCfg(HBaseConfiguration conf, InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            String msg = "fail to read properties from zoo.cfg";
            LOG.fatal((Object)msg);
            throw new IOException(msg, e);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String msg;
            String value = entry.getValue().toString().trim();
            String key = entry.getKey().toString().trim();
            StringBuilder newValue = new StringBuilder();
            int varStart = value.indexOf(VARIABLE_START);
            int varEnd = 0;
            while (varStart != -1) {
                varEnd = value.indexOf(VARIABLE_END, varStart);
                if (varEnd == -1) {
                    msg = "variable at " + varStart + " has no end marker";
                    LOG.fatal((Object)msg);
                    throw new IOException(msg);
                }
                String variable = value.substring(varStart + VARIABLE_START_LENGTH, varEnd);
                String substituteValue = System.getProperty(variable);
                if (substituteValue == null) {
                    substituteValue = conf.get(variable);
                }
                if (substituteValue == null) {
                    String msg2 = "variable " + variable + " not set in system property " + "or hbase configs";
                    LOG.fatal((Object)msg2);
                    throw new IOException(msg2);
                }
                newValue.append(substituteValue);
                varStart = value.indexOf(VARIABLE_START, varEnd += VARIABLE_END_LENGTH);
            }
            if (key.startsWith("server.") && conf.get("hbase.cluster.distributed").equals("true") && value.startsWith("localhost")) {
                msg = "The server in zoo.cfg cannot be set to localhost in a fully-distributed setup because it won't be reachable. See \"Getting Started\" for more information.";
                LOG.fatal((Object)msg);
                throw new IOException(msg);
            }
            newValue.append(value.substring(varEnd));
            properties.setProperty(key, newValue.toString());
        }
        return properties;
    }
}

