/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.zookeeper.HQuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class HQuorumPeerTest
extends HBaseTestCase {
    private Path dataDir;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String userName = System.getProperty("user.name");
        this.dataDir = new Path("/tmp/hbase-" + userName, "zookeeper");
        if (this.fs.exists(this.dataDir)) {
            if (!this.fs.isDirectory(this.dataDir)) {
                HQuorumPeerTest.fail();
            }
        } else if (!this.fs.mkdirs(this.dataDir)) {
            HQuorumPeerTest.fail();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.fs.exists(this.dataDir) && !this.fs.delete(this.dataDir, true)) {
            HQuorumPeerTest.fail();
        }
        super.tearDown();
    }

    public void testMakeZKProps() {
        Properties properties = HQuorumPeer.makeZKProps(this.conf);
        HQuorumPeerTest.assertEquals((int)2000, (int)Integer.parseInt(properties.getProperty("tickTime")));
        HQuorumPeerTest.assertEquals((Object)10, (Object)Integer.valueOf(properties.getProperty("initLimit")));
        HQuorumPeerTest.assertEquals((Object)5, (Object)Integer.valueOf(properties.getProperty("syncLimit")));
        HQuorumPeerTest.assertEquals((Object)this.dataDir.toString(), (Object)properties.get("dataDir"));
        HQuorumPeerTest.assertEquals((Object)21810, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        HQuorumPeerTest.assertEquals((Object)"localhost:2888:3888", (Object)properties.get("server.0"));
        HQuorumPeerTest.assertEquals(null, (Object)properties.get("server.1"));
        String oldValue = this.conf.get("hbase.zookeeper.quorum");
        this.conf.set("hbase.zookeeper.quorum", "a.foo.bar,b.foo.bar,c.foo.bar");
        properties = HQuorumPeer.makeZKProps(this.conf);
        HQuorumPeerTest.assertEquals((int)2000, (int)Integer.parseInt(properties.getProperty("tickTime")));
        HQuorumPeerTest.assertEquals((Object)10, (Object)Integer.valueOf(properties.getProperty("initLimit")));
        HQuorumPeerTest.assertEquals((Object)5, (Object)Integer.valueOf(properties.getProperty("syncLimit")));
        HQuorumPeerTest.assertEquals((Object)this.dataDir.toString(), (Object)properties.get("dataDir"));
        HQuorumPeerTest.assertEquals((Object)21810, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        HQuorumPeerTest.assertEquals((Object)"a.foo.bar:2888:3888", (Object)properties.get("server.0"));
        HQuorumPeerTest.assertEquals((Object)"b.foo.bar:2888:3888", (Object)properties.get("server.1"));
        HQuorumPeerTest.assertEquals((Object)"c.foo.bar:2888:3888", (Object)properties.get("server.2"));
        HQuorumPeerTest.assertEquals(null, (Object)properties.get("server.3"));
        this.conf.set("hbase.zookeeper.quorum", oldValue);
    }

    public void testConfigInjection() throws Exception {
        String s = "tickTime=2000\ninitLimit=10\nsyncLimit=5\ndataDir=${hbase.tmp.dir}/zookeeper\nclientPort=2181\nserver.0=${hbase.master.hostname}:2888:3888\n";
        System.setProperty("hbase.master.hostname", "localhost");
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
        Properties properties = HQuorumPeer.parseZooCfg(this.conf, is);
        HQuorumPeerTest.assertEquals((Object)2000, (Object)Integer.valueOf(properties.getProperty("tickTime")));
        HQuorumPeerTest.assertEquals((Object)10, (Object)Integer.valueOf(properties.getProperty("initLimit")));
        HQuorumPeerTest.assertEquals((Object)5, (Object)Integer.valueOf(properties.getProperty("syncLimit")));
        HQuorumPeerTest.assertEquals((Object)this.dataDir.toString(), (Object)properties.get("dataDir"));
        HQuorumPeerTest.assertEquals((Object)2181, (Object)Integer.valueOf(properties.getProperty("clientPort")));
        HQuorumPeerTest.assertEquals((Object)"localhost:2888:3888", (Object)properties.get("server.0"));
        QuorumPeerConfig config = new QuorumPeerConfig();
        config.parseProperties(properties);
        int tickTime = config.getTickTime();
        HQuorumPeerTest.assertEquals((int)2000, (int)tickTime);
        int initLimit = config.getInitLimit();
        HQuorumPeerTest.assertEquals((int)10, (int)initLimit);
        int syncLimit = config.getSyncLimit();
        HQuorumPeerTest.assertEquals((int)5, (int)syncLimit);
        HQuorumPeerTest.assertEquals((String)this.dataDir.toString(), (String)config.getDataDir());
        HQuorumPeerTest.assertEquals((int)2181, (int)config.getClientPort());
        Map servers = config.getServers();
        HQuorumPeerTest.assertEquals((int)1, (int)servers.size());
        HQuorumPeerTest.assertTrue((boolean)servers.containsKey(0L));
        QuorumPeer.QuorumServer server = (QuorumPeer.QuorumServer)servers.get(0L);
        HQuorumPeerTest.assertEquals((String)"localhost", (String)server.addr.getHostName());
        System.setProperty("hbase.master.hostname", "foo.bar");
        is = new ByteArrayInputStream(s.getBytes());
        properties = HQuorumPeer.parseZooCfg(this.conf, is);
        HQuorumPeerTest.assertEquals((Object)"foo.bar:2888:3888", (Object)properties.get("server.0"));
        config.parseProperties(properties);
        servers = config.getServers();
        server = (QuorumPeer.QuorumServer)servers.get(0L);
        HQuorumPeerTest.assertEquals((String)"foo.bar", (String)server.addr.getHostName());
    }
}

