/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.io.VersionedWritable;

public class ClusterStatus
extends VersionedWritable {
    private static final byte VERSION = 0;
    private String hbaseVersion;
    private Collection<HServerInfo> liveServerInfo;
    private Collection<String> deadServers;
    private NavigableMap<String, String> intransition;

    public Collection<String> getServerNames() {
        ArrayList<String> names = new ArrayList<String>(this.liveServerInfo.size());
        for (HServerInfo server : this.liveServerInfo) {
            names.add(server.getName());
        }
        return names;
    }

    public Collection<String> getDeadServerNames() {
        return Collections.unmodifiableCollection(this.deadServers);
    }

    public int getServers() {
        return this.liveServerInfo.size();
    }

    public int getDeadServers() {
        return this.deadServers.size();
    }

    public double getAverageLoad() {
        int load = 0;
        for (HServerInfo server : this.liveServerInfo) {
            load += server.getLoad().getLoad();
        }
        return (double)load / (double)this.liveServerInfo.size();
    }

    public int getRegionsCount() {
        int count = 0;
        for (HServerInfo server : this.liveServerInfo) {
            count += server.getLoad().getNumberOfRegions();
        }
        return count;
    }

    public int getRequestsCount() {
        int count = 0;
        for (HServerInfo server : this.liveServerInfo) {
            count += server.getLoad().getNumberOfRequests();
        }
        return count;
    }

    public String getHBaseVersion() {
        return this.hbaseVersion;
    }

    public void setHBaseVersion(String version) {
        this.hbaseVersion = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClusterStatus)) {
            return false;
        }
        return this.getVersion() == ((ClusterStatus)((Object)o)).getVersion() && this.getHBaseVersion().equals(((ClusterStatus)((Object)o)).getHBaseVersion()) && ((Object)this.liveServerInfo).equals(((ClusterStatus)((Object)o)).liveServerInfo) && ((Object)this.deadServers).equals(((ClusterStatus)((Object)o)).deadServers);
    }

    public int hashCode() {
        return 0 + this.hbaseVersion.hashCode() + ((Object)this.liveServerInfo).hashCode() + ((Object)this.deadServers).hashCode();
    }

    public byte getVersion() {
        return 0;
    }

    public Collection<HServerInfo> getServerInfo() {
        return Collections.unmodifiableCollection(this.liveServerInfo);
    }

    public void setServerInfo(Collection<HServerInfo> serverInfo) {
        this.liveServerInfo = serverInfo;
    }

    public void setDeadServers(Collection<String> deadServers) {
        this.deadServers = deadServers;
    }

    public Map<String, String> getRegionsInTransition() {
        return this.intransition;
    }

    public void setRegionsInTransition(NavigableMap<String, String> m) {
        this.intransition = m;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeUTF(this.hbaseVersion);
        out.writeInt(this.liveServerInfo.size());
        for (HServerInfo hServerInfo : this.liveServerInfo) {
            hServerInfo.write(out);
        }
        out.writeInt(this.deadServers.size());
        for (String string : this.deadServers) {
            out.writeUTF(string);
        }
        out.writeInt(this.intransition.size());
        for (Map.Entry entry : this.intransition.entrySet()) {
            out.writeUTF((String)entry.getKey());
            out.writeUTF((String)entry.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        super.readFields(in);
        this.hbaseVersion = in.readUTF();
        int count = in.readInt();
        this.liveServerInfo = new ArrayList<HServerInfo>(count);
        for (i = 0; i < count; ++i) {
            HServerInfo info = new HServerInfo();
            info.readFields(in);
            this.liveServerInfo.add(info);
        }
        count = in.readInt();
        this.deadServers = new ArrayList<String>(count);
        for (i = 0; i < count; ++i) {
            this.deadServers.add(in.readUTF());
        }
        count = in.readInt();
        this.intransition = new TreeMap<String, String>();
        for (i = 0; i < count; ++i) {
            String key = in.readUTF();
            String value = in.readUTF();
            this.intransition.put(key, value);
        }
    }
}

