/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.ServerConnection;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HMasterInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MetaUtils;
import org.apache.hadoop.hbase.util.SoftValueSortedMap;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWrapper;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class HConnectionManager
implements HConstants {
    private static final Delete[] DELETE_ARRAY_TYPE = new Delete[0];
    private static final Put[] PUT_ARRAY_TYPE = new Put[0];
    private static final int MAX_CACHED_HBASE_INSTANCES = 31;
    private static final Map<HBaseConfiguration, TableServers> HBASE_INSTANCES;
    private static final Map<String, ClientZKWatcher> ZK_WRAPPERS;

    protected HConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HConnection getConnection(HBaseConfiguration conf) {
        TableServers connection;
        Map<HBaseConfiguration, TableServers> map = HBASE_INSTANCES;
        synchronized (map) {
            connection = HBASE_INSTANCES.get((Object)conf);
            if (connection == null) {
                connection = new TableServers(conf);
                HBASE_INSTANCES.put(conf, connection);
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConnectionInfo(HBaseConfiguration conf, boolean stopProxy) {
        Map<HBaseConfiguration, TableServers> map = HBASE_INSTANCES;
        synchronized (map) {
            TableServers t = HBASE_INSTANCES.remove((Object)conf);
            if (t != null) {
                t.close(stopProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConnections(boolean stopProxy) {
        Map<Object, Object> map = HBASE_INSTANCES;
        synchronized (map) {
            for (TableServers t : HBASE_INSTANCES.values()) {
                if (t == null) continue;
                t.close(stopProxy);
            }
        }
        map = ZK_WRAPPERS;
        synchronized (map) {
            for (ClientZKWatcher watch : ZK_WRAPPERS.values()) {
                watch.resetZooKeeper();
            }
        }
    }

    public static synchronized ClientZKWatcher getClientZooKeeperWatcher(HBaseConfiguration conf) throws IOException {
        if (!ZK_WRAPPERS.containsKey(conf.get("hbase.zookeeper.quorum"))) {
            ZK_WRAPPERS.put(conf.get("hbase.zookeeper.quorum"), new ClientZKWatcher(conf));
        }
        return ZK_WRAPPERS.get(conf.get("hbase.zookeeper.quorum"));
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("HCM.shutdownHook"){

            @Override
            public void run() {
                HConnectionManager.deleteAllConnections(true);
            }
        });
        HBASE_INSTANCES = new LinkedHashMap<HBaseConfiguration, TableServers>(42, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HBaseConfiguration, TableServers> eldest) {
                return this.size() > 31;
            }
        };
        ZK_WRAPPERS = new HashMap<String, ClientZKWatcher>();
    }

    private static class TableServers
    implements ServerConnection,
    HConstants {
        static final Log LOG = LogFactory.getLog(TableServers.class);
        private final Class<? extends HRegionInterface> serverInterfaceClass;
        private final long pause;
        private final int numRetries;
        private final int maxRPCAttempts;
        private final long rpcTimeout;
        private final Object masterLock = new Object();
        private volatile boolean closed;
        private volatile HMasterInterface master;
        private volatile boolean masterChecked;
        private final Object rootRegionLock = new Object();
        private final Object metaRegionLock = new Object();
        private final Object userRegionLock = new Object();
        private volatile HBaseConfiguration conf;
        private final Map<String, HRegionInterface> servers = new ConcurrentHashMap<String, HRegionInterface>();
        private volatile HRegionLocation rootRegionLocation;
        private final Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> cachedRegionLocations = new HashMap<Integer, SoftValueSortedMap<byte[], HRegionLocation>>();

        public TableServers(HBaseConfiguration conf) {
            this.conf = conf;
            String serverClassName = conf.get("hbase.regionserver.class", DEFAULT_REGION_SERVER_CLASS);
            this.closed = false;
            try {
                this.serverInterfaceClass = Class.forName(serverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException("Unable to find region server interface " + serverClassName, e);
            }
            this.pause = conf.getLong("hbase.client.pause", 1000L);
            this.numRetries = conf.getInt("hbase.client.retries.number", 10);
            this.maxRPCAttempts = conf.getInt("hbase.client.rpc.maxattempts", 1);
            this.rpcTimeout = conf.getLong("hbase.regionserver.lease.period", 60000L);
            this.master = null;
            this.masterChecked = false;
        }

        private long getPauseTime(int tries) {
            int ntries = tries;
            if (ntries >= HConstants.RETRY_BACKOFF.length) {
                ntries = HConstants.RETRY_BACKOFF.length - 1;
            }
            return this.pause * (long)HConstants.RETRY_BACKOFF[ntries];
        }

        @Override
        public void unsetRootRegionLocation() {
            this.rootRegionLocation = null;
        }

        @Override
        public void setRootRegionLocation(HRegionLocation rootRegion) {
            if (rootRegion == null) {
                throw new IllegalArgumentException("Cannot set root region location to null.");
            }
            this.rootRegionLocation = rootRegion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HMasterInterface getMaster() throws MasterNotRunningException {
            ZooKeeperWrapper zk = null;
            try {
                zk = this.getZooKeeperWrapper();
            }
            catch (IOException e) {
                throw new MasterNotRunningException(e);
            }
            HServerAddress masterLocation = null;
            Object object = this.masterLock;
            synchronized (object) {
                for (int tries = 0; !this.closed && !this.masterChecked && this.master == null && tries < this.numRetries; ++tries) {
                    try {
                        masterLocation = zk.readMasterAddressOrThrow();
                        HMasterInterface tryMaster = (HMasterInterface)HBaseRPC.getProxy(HMasterInterface.class, 21L, masterLocation.getInetSocketAddress(), this.conf);
                        if (tryMaster.isMasterRunning()) {
                            this.master = tryMaster;
                            this.masterLock.notifyAll();
                            break;
                        }
                    }
                    catch (IOException e) {
                        if (tries == this.numRetries - 1) {
                            LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; no more retrying."), (Throwable)e);
                            break;
                        }
                        LOG.info((Object)("getMaster attempt " + tries + " of " + this.numRetries + " failed; retrying after sleep of " + this.getPauseTime(tries)), (Throwable)e);
                    }
                    try {
                        this.masterLock.wait(this.getPauseTime(tries));
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                this.masterChecked = true;
            }
            if (this.master == null) {
                if (masterLocation == null) {
                    throw new MasterNotRunningException();
                }
                throw new MasterNotRunningException(masterLocation.toString());
            }
            return this.master;
        }

        @Override
        public boolean isMasterRunning() {
            if (this.master == null) {
                try {
                    this.getMaster();
                }
                catch (MasterNotRunningException e) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean tableExists(byte[] tableName) throws MasterNotRunningException {
            this.getMaster();
            if (tableName == null) {
                throw new IllegalArgumentException("Table name cannot be null");
            }
            if (TableServers.isMetaTableName(tableName)) {
                return true;
            }
            boolean exists = false;
            try {
                HTableDescriptor[] tables = this.listTables();
                for (int i = 0; i < tables.length; ++i) {
                    if (!Bytes.equals(tables[i].getName(), tableName)) continue;
                    exists = true;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Testing for table existence threw exception", (Throwable)e);
            }
            return exists;
        }

        private static boolean isMetaTableName(byte[] n) {
            return MetaUtils.isMetaTableName(n);
        }

        @Override
        public HRegionLocation getRegionLocation(byte[] name, byte[] row, boolean reload) throws IOException {
            return reload ? this.relocateRegion(name, row) : this.locateRegion(name, row);
        }

        @Override
        public HTableDescriptor[] listTables() throws IOException {
            this.getMaster();
            final TreeSet uniqueTables = new TreeSet();
            MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

                @Override
                public boolean processRow(Result result) throws IOException {
                    try {
                        byte[] value = result.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        HRegionInfo info = null;
                        if (value != null) {
                            info = Writables.getHRegionInfo(value);
                        }
                        if (info != null && info.getStartKey().length == 0) {
                            uniqueTables.add(info.getTableDesc());
                        }
                        return true;
                    }
                    catch (RuntimeException e) {
                        LOG.error((Object)("Result=" + result));
                        throw e;
                    }
                }
            };
            MetaScanner.metaScan(this.conf, visitor);
            return uniqueTables.toArray(new HTableDescriptor[uniqueTables.size()]);
        }

        @Override
        public boolean isTableEnabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, true);
        }

        @Override
        public boolean isTableDisabled(byte[] tableName) throws IOException {
            return this.testTableOnlineState(tableName, false);
        }

        @Override
        public boolean isTableAvailable(final byte[] tableName) throws IOException {
            final AtomicBoolean available = new AtomicBoolean(true);
            MetaScanner.MetaScannerVisitor visitor = new MetaScanner.MetaScannerVisitor(){

                @Override
                public boolean processRow(Result row) throws IOException {
                    byte[] value = row.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                    HRegionInfo info = Writables.getHRegionInfoOrNull(value);
                    if (info != null && Bytes.equals(tableName, info.getTableDesc().getName()) && (value = row.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER)) == null) {
                        available.set(false);
                        return false;
                    }
                    return true;
                }
            };
            MetaScanner.metaScan(this.conf, visitor);
            return available.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean testTableOnlineState(byte[] tableName, boolean online) throws IOException {
            if (!this.tableExists(tableName)) {
                throw new TableNotFoundException(Bytes.toString(tableName));
            }
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                return true;
            }
            int rowsScanned = 0;
            int rowsOffline = 0;
            byte[] startKey = HRegionInfo.createRegionName(tableName, null, "00000000000000");
            byte[] endKey = null;
            HRegionInfo currentRegion = null;
            Scan scan = new Scan(startKey);
            scan.addColumn(CATALOG_FAMILY, REGIONINFO_QUALIFIER);
            int rows = this.conf.getInt("hbase.meta.scanner.caching", 100);
            scan.setCaching(rows);
            ScannerCallable s = new ScannerCallable((HConnection)this, Bytes.equals(tableName, HConstants.META_TABLE_NAME) ? HConstants.ROOT_TABLE_NAME : HConstants.META_TABLE_NAME, scan);
            try {
                this.getRegionServerWithRetries(s);
                do {
                    HRegionInfo oldRegion;
                    if ((oldRegion = currentRegion) != null) {
                        startKey = oldRegion.getEndKey();
                    }
                    currentRegion = s.getHRegionInfo();
                    Result r = null;
                    Result[] rrs = null;
                    while ((rrs = this.getRegionServerWithRetries(s)) != null && rrs.length > 0) {
                        HRegionInfo info;
                        r = rrs[0];
                        byte[] value = r.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                        if (value == null || (info = Writables.getHRegionInfoOrNull(value)) == null || !Bytes.equals(info.getTableDesc().getName(), tableName)) continue;
                        ++rowsScanned;
                        rowsOffline += info.isOffline() ? 1 : 0;
                    }
                } while ((endKey = currentRegion.getEndKey()) != null && !Bytes.equals(endKey, HConstants.EMPTY_BYTE_ARRAY));
            }
            finally {
                s.setClose();
                this.getRegionServerWithRetries(s);
            }
            LOG.debug((Object)("Rowscanned=" + rowsScanned + ", rowsOffline=" + rowsOffline));
            boolean onOffLine = online ? rowsOffline == 0 : rowsOffline == rowsScanned;
            return rowsScanned > 0 && onOffLine;
        }

        @Override
        public HTableDescriptor getHTableDescriptor(byte[] tableName) throws IOException {
            if (Bytes.equals(tableName, HConstants.ROOT_TABLE_NAME)) {
                return new UnmodifyableHTableDescriptor(HTableDescriptor.ROOT_TABLEDESC);
            }
            if (Bytes.equals(tableName, HConstants.META_TABLE_NAME)) {
                return HTableDescriptor.META_TABLEDESC;
            }
            HTableDescriptorFinder finder = new HTableDescriptorFinder(tableName);
            MetaScanner.metaScan(this.conf, finder);
            HTableDescriptor result = finder.getResult();
            if (result == null) {
                throw new TableNotFoundException(Bytes.toString(tableName));
            }
            return result;
        }

        @Override
        public HRegionLocation locateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, true);
        }

        @Override
        public HRegionLocation relocateRegion(byte[] tableName, byte[] row) throws IOException {
            return this.locateRegion(tableName, row, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private HRegionLocation locateRegion(byte[] tableName, byte[] row, boolean useCache) throws IOException {
            if (tableName == null || tableName.length == 0) {
                throw new IllegalArgumentException("table name cannot be null or zero length");
            }
            if (Bytes.equals(tableName, ROOT_TABLE_NAME)) {
                Object object = this.rootRegionLock;
                synchronized (object) {
                    if (!useCache || this.rootRegionLocation == null) {
                        this.rootRegionLocation = this.locateRootRegion();
                    }
                    return this.rootRegionLocation;
                }
            }
            if (Bytes.equals(tableName, META_TABLE_NAME)) {
                Object object = this.metaRegionLock;
                synchronized (object) {
                    return this.locateRegionInMeta(ROOT_TABLE_NAME, tableName, row, useCache);
                }
            }
            Object object = this.userRegionLock;
            synchronized (object) {
                return this.locateRegionInMeta(META_TABLE_NAME, tableName, row, useCache);
            }
        }

        private HRegionLocation locateRegionInMeta(byte[] parentTable, byte[] tableName, byte[] row, boolean useCache) throws IOException {
            HRegionLocation location = null;
            if (useCache) {
                location = this.getCachedLocation(tableName, row);
                if (location != null) {
                    return location;
                }
            } else {
                this.deleteCachedLocation(tableName, row);
            }
            byte[] metaKey = HRegionInfo.createRegionName(tableName, row, "99999999999999");
            int tries = 0;
            while (true) {
                if (tries >= this.numRetries) {
                    throw new NoServerForRegionException("Unable to find region for " + Bytes.toStringBinary(row) + " after " + this.numRetries + " tries.");
                }
                try {
                    HRegionLocation metaLocation = this.locateRegion(parentTable, metaKey);
                    HRegionInterface server = this.getHRegionConnection(metaLocation.getServerAddress());
                    Result regionInfoRow = server.getClosestRowBefore(metaLocation.getRegionInfo().getRegionName(), metaKey, HConstants.CATALOG_FAMILY);
                    if (regionInfoRow == null) {
                        throw new TableNotFoundException(Bytes.toString(tableName));
                    }
                    byte[] value = regionInfoRow.getValue(CATALOG_FAMILY, REGIONINFO_QUALIFIER);
                    if (value == null || value.length == 0) {
                        throw new IOException("HRegionInfo was null or empty in " + Bytes.toString(parentTable));
                    }
                    HRegionInfo regionInfo = (HRegionInfo)Writables.getWritable(value, (Writable)new HRegionInfo());
                    if (!Bytes.equals(regionInfo.getTableDesc().getName(), tableName)) {
                        throw new TableNotFoundException("Table '" + Bytes.toString(tableName) + "' was not found.");
                    }
                    if (regionInfo.isOffline()) {
                        throw new RegionOfflineException("region offline: " + regionInfo.getRegionNameAsString());
                    }
                    value = regionInfoRow.getValue(CATALOG_FAMILY, SERVER_QUALIFIER);
                    String serverAddress = "";
                    if (value != null) {
                        serverAddress = Bytes.toString(value);
                    }
                    if (serverAddress.equals("")) {
                        throw new NoServerForRegionException("No server address listed in " + Bytes.toString(parentTable) + " for region " + regionInfo.getRegionNameAsString());
                    }
                    location = new HRegionLocation(regionInfo, new HServerAddress(serverAddress));
                    this.cacheLocation(tableName, location);
                    return location;
                }
                catch (TableNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (e instanceof RemoteException) {
                        e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                    }
                    if (tries < this.numRetries - 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("locateRegionInMeta attempt " + tries + " of " + this.numRetries + " failed; retrying after sleep of " + this.getPauseTime(tries) + " because: " + e.getMessage()));
                        }
                    } else {
                        throw e;
                    }
                    this.relocateRegion(parentTable, metaKey);
                    try {
                        Thread.sleep(this.getPauseTime(tries));
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    ++tries;
                    continue;
                }
                break;
            }
        }

        private HRegionLocation getCachedLocation(byte[] tableName, byte[] row) {
            byte[] endKey;
            HRegionLocation possibleRegion;
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (tableLocations.isEmpty()) {
                return null;
            }
            HRegionLocation rl = tableLocations.get(row);
            if (rl != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Cache hit for row <" + Bytes.toString(row) + "> in tableName " + Bytes.toString(tableName) + ": location server " + rl.getServerAddress() + ", location region name " + rl.getRegionInfo().getRegionNameAsString()));
                }
                return rl;
            }
            SortedMap matchingRegions = tableLocations.headMap((Object)row);
            if (!((SoftValueSortedMap)matchingRegions).isEmpty() && (possibleRegion = (HRegionLocation)((SoftValueSortedMap)matchingRegions).get(((SoftValueSortedMap)matchingRegions).lastKey())) != null && (Bytes.equals(endKey = possibleRegion.getRegionInfo().getEndKey(), HConstants.EMPTY_END_ROW) || KeyValue.getRowComparator(tableName).compareRows(endKey, 0, endKey.length, row, 0, row.length) > 0)) {
                return possibleRegion;
            }
            return null;
        }

        private void deleteCachedLocation(byte[] tableName, byte[] row) {
            SortedMap matchingRegions;
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (!tableLocations.isEmpty() && !((SoftValueSortedMap)(matchingRegions = tableLocations.headMap((Object)row))).isEmpty()) {
                HRegionLocation rl;
                HRegionLocation possibleRegion = (HRegionLocation)((SoftValueSortedMap)matchingRegions).get(((SoftValueSortedMap)matchingRegions).lastKey());
                byte[] endKey = possibleRegion.getRegionInfo().getEndKey();
                if (KeyValue.getRowComparator(tableName).compareRows(endKey, 0, endKey.length, row, 0, row.length) <= 0 && (rl = tableLocations.remove(((SoftValueSortedMap)matchingRegions).lastKey())) != null && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removed " + rl.getRegionInfo().getRegionNameAsString() + " for tableName=" + Bytes.toString(tableName) + " from cache " + "because of " + Bytes.toStringBinary(row)));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SoftValueSortedMap<byte[], HRegionLocation> getTableLocations(byte[] tableName) {
            Integer key = Bytes.mapKey(tableName);
            SoftValueSortedMap<byte[], HRegionLocation> result = null;
            Map<Integer, SoftValueSortedMap<byte[], HRegionLocation>> map = this.cachedRegionLocations;
            synchronized (map) {
                result = this.cachedRegionLocations.get(key);
                if (result == null) {
                    result = new SoftValueSortedMap(Bytes.BYTES_COMPARATOR);
                    this.cachedRegionLocations.put(key, result);
                }
            }
            return result;
        }

        private void cacheLocation(byte[] tableName, HRegionLocation location) {
            byte[] startKey = location.getRegionInfo().getStartKey();
            SoftValueSortedMap<byte[], HRegionLocation> tableLocations = this.getTableLocations(tableName);
            if (tableLocations.put(startKey, location) == null) {
                LOG.debug((Object)("Cached location for " + location.getRegionInfo().getRegionNameAsString() + " is " + location.getServerAddress()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public HRegionInterface getHRegionConnection(HServerAddress regionServer, boolean getMaster) throws IOException {
            HRegionInterface server;
            if (getMaster) {
                this.getMaster();
            }
            Map<String, HRegionInterface> map = this.servers;
            synchronized (map) {
                server = this.servers.get(regionServer.toString());
                if (server == null) {
                    try {
                        server = (HRegionInterface)HBaseRPC.waitForProxy(this.serverInterfaceClass, 21L, regionServer.getInetSocketAddress(), this.conf, this.maxRPCAttempts, this.rpcTimeout);
                    }
                    catch (RemoteException e) {
                        throw RemoteExceptionHandler.decodeRemoteException(e);
                    }
                    this.servers.put(regionServer.toString(), server);
                }
            }
            return server;
        }

        @Override
        public HRegionInterface getHRegionConnection(HServerAddress regionServer) throws IOException {
            return this.getHRegionConnection(regionServer, false);
        }

        @Override
        public synchronized ZooKeeperWrapper getZooKeeperWrapper() throws IOException {
            return HConnectionManager.getClientZooKeeperWatcher(this.conf).getZooKeeperWrapper();
        }

        private HRegionLocation locateRootRegion() throws IOException {
            ZooKeeperWrapper zk = this.getZooKeeperWrapper();
            HServerAddress rootRegionAddress = null;
            for (int tries = 0; tries < this.numRetries; ++tries) {
                int localTimeouts = 0;
                while (rootRegionAddress == null && localTimeouts < this.numRetries) {
                    boolean outOfSafeMode = zk.checkOutOfSafeMode();
                    if (outOfSafeMode) {
                        rootRegionAddress = zk.readRootRegionLocation();
                    }
                    if (rootRegionAddress != null) continue;
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Sleeping " + this.getPauseTime(tries) + "ms, waiting for root region."));
                        }
                        Thread.sleep(this.getPauseTime(tries));
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    ++localTimeouts;
                }
                if (rootRegionAddress == null) {
                    throw new NoServerForRegionException("Timed out trying to locate root region");
                }
                try {
                    HRegionInterface server = this.getHRegionConnection(rootRegionAddress);
                    server.getRegionInfo(HRegionInfo.ROOT_REGIONINFO.getRegionName());
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)("Found ROOT at " + rootRegionAddress));
                    break;
                }
                catch (IOException e) {
                    if (tries == this.numRetries - 1) {
                        if (e instanceof RemoteException) {
                            e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                        }
                        throw e;
                    }
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Root region location changed. Sleeping.");
                        }
                        Thread.sleep(this.getPauseTime(tries));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Wake. Retry finding root region.");
                        }
                    }
                    catch (InterruptedException iex) {
                        // empty catch block
                    }
                    rootRegionAddress = null;
                    continue;
                }
            }
            if (rootRegionAddress == null) {
                throw new NoServerForRegionException("unable to locate root region server");
            }
            return new HRegionLocation(HRegionInfo.ROOT_REGIONINFO, rootRegionAddress);
        }

        @Override
        public <T> T getRegionServerWithRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (int tries = 0; tries < this.numRetries; ++tries) {
                try {
                    callable.instantiateServer(tries != 0);
                    return (T)callable.call();
                }
                catch (Throwable t) {
                    if (t instanceof UndeclaredThrowableException) {
                        t = t.getCause();
                    }
                    if (t instanceof RemoteException) {
                        t = RemoteExceptionHandler.decodeRemoteException((RemoteException)t);
                    }
                    if (t instanceof DoNotRetryIOException) {
                        throw (DoNotRetryIOException)t;
                    }
                    exceptions.add(t);
                    if (tries == this.numRetries - 1) {
                        throw new RetriesExhaustedException(callable.getServerName(), callable.getRegionName(), callable.getRow(), tries, exceptions);
                    }
                    try {
                        Thread.sleep(this.getPauseTime(tries));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            return null;
        }

        @Override
        public <T> T getRegionServerForWithoutRetries(ServerCallable<T> callable) throws IOException, RuntimeException {
            try {
                callable.instantiateServer(false);
                return (T)callable.call();
            }
            catch (Throwable t) {
                if (t instanceof UndeclaredThrowableException) {
                    t = t.getCause();
                }
                if (t instanceof RemoteException) {
                    t = RemoteExceptionHandler.decodeRemoteException((RemoteException)t);
                }
                if (t instanceof DoNotRetryIOException) {
                    throw (DoNotRetryIOException)t;
                }
                return null;
            }
        }

        private HRegionLocation getRegionLocationForRowWithRetries(byte[] tableName, byte[] rowKey, boolean reload) throws IOException {
            boolean reloadFlag = reload;
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            HRegionLocation location = null;
            int tries = 0;
            while (tries < this.numRetries) {
                try {
                    location = this.getRegionLocation(tableName, rowKey, reloadFlag);
                }
                catch (Throwable t) {
                    exceptions.add(t);
                }
                if (location != null) break;
                reloadFlag = true;
                ++tries;
                try {
                    Thread.sleep(this.getPauseTime(tries));
                }
                catch (InterruptedException e) {}
            }
            if (location == null) {
                throw new RetriesExhaustedException("Some server", HConstants.EMPTY_BYTE_ARRAY, rowKey, tries, exceptions);
            }
            return location;
        }

        @Override
        public int processBatchOfRows(ArrayList<Put> list, byte[] tableName) throws IOException {
            if (list.isEmpty()) {
                return 0;
            }
            if (list.size() > 1) {
                Collections.sort(list);
            }
            Batch b = new Batch(this){

                @Override
                int doCall(List<Row> currentList, byte[] row, byte[] tableName) throws IOException, RuntimeException {
                    final Put[] puts = currentList.toArray(PUT_ARRAY_TYPE);
                    return TableServers.this.getRegionServerWithRetries(new ServerCallable<Integer>(this.c, tableName, row){

                        @Override
                        public Integer call() throws IOException {
                            return this.server.put(this.location.getRegionInfo().getRegionName(), puts);
                        }
                    });
                }
            };
            return b.process(list, tableName);
        }

        @Override
        public int processBatchOfDeletes(ArrayList<Delete> list, byte[] tableName) throws IOException {
            if (list.isEmpty()) {
                return 0;
            }
            if (list.size() > 1) {
                Collections.sort(list);
            }
            Batch b = new Batch(this){

                @Override
                int doCall(List<Row> currentList, byte[] row, byte[] tableName) throws IOException, RuntimeException {
                    final Delete[] deletes = currentList.toArray(DELETE_ARRAY_TYPE);
                    return TableServers.this.getRegionServerWithRetries(new ServerCallable<Integer>(this.c, tableName, row){

                        @Override
                        public Integer call() throws IOException {
                            return this.server.delete(this.location.getRegionInfo().getRegionName(), deletes);
                        }
                    });
                }
            };
            return b.process(list, tableName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(boolean stopProxy) {
            if (this.master != null) {
                if (stopProxy) {
                    HBaseRPC.stopProxy(this.master);
                }
                this.master = null;
                this.masterChecked = false;
            }
            if (stopProxy) {
                Map<String, HRegionInterface> map = this.servers;
                synchronized (map) {
                    for (HRegionInterface i : this.servers.values()) {
                        HBaseRPC.stopProxy(i);
                    }
                }
            }
        }

        private abstract class Batch {
            final HConnection c;

            private Batch(HConnection c) {
                this.c = c;
            }

            abstract int doCall(List<Row> var1, byte[] var2, byte[] var3) throws IOException, RuntimeException;

            int process(ArrayList<? extends Row> list, byte[] tableName) throws IOException {
                int i;
                byte[] region;
                byte[] currentRegion = region = this.getRegionName(tableName, list.get(0).getRow(), false);
                boolean isLastRow = false;
                boolean retryOnlyOne = false;
                ArrayList<Row> currentList = new ArrayList<Row>();
                int tries = 0;
                for (i = 0; i < list.size() && tries < TableServers.this.numRetries; ++i) {
                    Row row = list.get(i);
                    currentList.add(row);
                    boolean bl = isLastRow = i + 1 == list.size();
                    if (!isLastRow) {
                        region = this.getRegionName(tableName, list.get(i + 1).getRow(), false);
                    }
                    if (Bytes.equals(currentRegion, region) && !isLastRow && !retryOnlyOne) continue;
                    int index = this.doCall(currentList, row.getRow(), tableName);
                    if (index != -1) {
                        if (tries == TableServers.this.numRetries - 1) {
                            throw new RetriesExhaustedException("Some server, retryOnlyOne=" + retryOnlyOne + ", index=" + index + ", islastrow=" + isLastRow + ", tries=" + tries + ", numtries=" + TableServers.this.numRetries + ", i=" + i + ", listsize=" + list.size() + ", region=" + Bytes.toStringBinary(region), currentRegion, row.getRow(), tries, new ArrayList<Throwable>());
                        }
                        tries = this.doBatchPause(currentRegion, tries);
                        i = i - currentList.size() + index;
                        retryOnlyOne = true;
                        region = this.getRegionName(tableName, list.get(i + 1).getRow(), true);
                    } else {
                        retryOnlyOne = false;
                        tries = 0;
                    }
                    currentRegion = region;
                    currentList.clear();
                }
                return i;
            }

            private byte[] getRegionName(byte[] t, byte[] r, boolean re) throws IOException {
                HRegionLocation location = TableServers.this.getRegionLocationForRowWithRetries(t, r, re);
                return location.getRegionInfo().getRegionName();
            }

            private int doBatchPause(byte[] currentRegion, int tries) {
                int localTries = tries;
                long sleepTime = TableServers.this.getPauseTime(tries);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Reloading region " + Bytes.toStringBinary(currentRegion) + " location because regionserver didn't accept updates; tries=" + tries + " of max=" + TableServers.this.numRetries + ", waiting=" + sleepTime + "ms"));
                }
                try {
                    Thread.sleep(sleepTime);
                    ++localTries;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return localTries;
            }
        }

        private static class HTableDescriptorFinder
        implements MetaScanner.MetaScannerVisitor {
            byte[] tableName;
            HTableDescriptor result;

            protected HTableDescriptorFinder(byte[] tableName) {
                this.tableName = tableName;
            }

            @Override
            public boolean processRow(Result rowResult) throws IOException {
                HRegionInfo info = Writables.getHRegionInfo(rowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER));
                HTableDescriptor desc = info.getTableDesc();
                if (Bytes.compareTo(desc.getName(), this.tableName) == 0) {
                    this.result = desc;
                    return false;
                }
                return true;
            }

            HTableDescriptor getResult() {
                return this.result;
            }
        }
    }

    public static class ClientZKWatcher
    implements Watcher {
        static final Log LOG = LogFactory.getLog(ClientZKWatcher.class);
        private ZooKeeperWrapper zooKeeperWrapper;
        private HBaseConfiguration conf;

        public ClientZKWatcher(HBaseConfiguration conf) {
            this.conf = conf;
        }

        public void process(WatchedEvent event) {
            Watcher.Event.KeeperState state = event.getState();
            if (!state.equals((Object)Watcher.Event.KeeperState.SyncConnected)) {
                LOG.debug((Object)("Got ZooKeeper event, state: " + state + ", type: " + event.getType() + ", path: " + event.getPath()));
            }
            if (state == Watcher.Event.KeeperState.Expired) {
                this.resetZooKeeper();
            }
        }

        public synchronized ZooKeeperWrapper getZooKeeperWrapper() throws IOException {
            if (this.zooKeeperWrapper == null) {
                this.zooKeeperWrapper = new ZooKeeperWrapper(this.conf, this);
            }
            return this.zooKeeperWrapper;
        }

        private synchronized void resetZooKeeper() {
            if (this.zooKeeperWrapper != null) {
                this.zooKeeperWrapper.close();
                this.zooKeeperWrapper = null;
            }
        }
    }
}

