/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.io.hfile.BlockCache;

public class SimpleBlockCache
implements BlockCache {
    private Map<String, Ref> cache = new HashMap<String, Ref>();
    private ReferenceQueue q = new ReferenceQueue();
    public int dumps = 0;

    void processQueue() {
        Ref r;
        while ((r = (Ref)this.q.poll()) != null) {
            this.cache.remove(r.blockId);
            ++this.dumps;
        }
    }

    public synchronized int size() {
        this.processQueue();
        return this.cache.size();
    }

    @Override
    public synchronized ByteBuffer getBlock(String blockName) {
        this.processQueue();
        Ref ref = this.cache.get(blockName);
        if (ref == null) {
            return null;
        }
        return (ByteBuffer)ref.get();
    }

    @Override
    public synchronized void cacheBlock(String blockName, ByteBuffer buf) {
        this.cache.put(blockName, new Ref(blockName, buf, this.q));
    }

    @Override
    public synchronized void cacheBlock(String blockName, ByteBuffer buf, boolean inMemory) {
        this.cache.put(blockName, new Ref(blockName, buf, this.q));
    }

    @Override
    public void shutdown() {
    }

    private static class Ref
    extends SoftReference<ByteBuffer> {
        public String blockId;

        public Ref(String blockId, ByteBuffer buf, ReferenceQueue q) {
            super(buf, q);
            this.blockId = blockId;
        }
    }
}

