/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseRpcMetrics;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public abstract class HBaseServer {
    public static final ByteBuffer HEADER = ByteBuffer.wrap("hrpc".getBytes());
    public static final byte CURRENT_VERSION = 3;
    private static final int MAX_QUEUE_SIZE_PER_HANDLER = 100;
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseServer");
    protected static final ThreadLocal<HBaseServer> SERVER = new ThreadLocal();
    protected static final ThreadLocal<Call> CurCall = new ThreadLocal();
    protected String bindAddress;
    protected int port;
    private int handlerCount;
    protected Class<? extends Writable> paramClass;
    protected int maxIdleTime;
    protected int thresholdIdleConnections;
    int maxConnectionsToNuke;
    protected HBaseRpcMetrics rpcMetrics;
    protected Configuration conf;
    private int maxQueueSize;
    protected int socketSendBufferSize;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected volatile boolean running = true;
    protected BlockingQueue<Call> callQueue;
    protected List<Connection> connectionList = Collections.synchronizedList(new LinkedList());
    private Listener listener = null;
    protected Responder responder = null;
    protected int numConnections = 0;
    private Handler[] handlers = null;
    protected HBaseRPCErrorHandler errorHandler = null;
    private static int NIO_BUFFER_LIMIT = 8192;

    public static HBaseServer get() {
        return SERVER.get();
    }

    public static InetAddress getRemoteIp() {
        Call call = CurCall.get();
        if (call != null) {
            return call.connection.socket.getInetAddress();
        }
        return null;
    }

    public static String getRemoteAddress() {
        InetAddress addr = HBaseServer.getRemoteIp();
        return addr == null ? null : addr.getHostAddress();
    }

    public static void bind(ServerSocket socket, InetSocketAddress address, int backlog) throws IOException {
        try {
            socket.bind(address, backlog);
        }
        catch (BindException e) {
            BindException bindException = new BindException("Problem binding to " + address + " : " + e.getMessage());
            bindException.initCause(e);
            throw bindException;
        }
        catch (SocketException e) {
            if ("Unresolved address".equals(e.getMessage())) {
                throw new UnknownHostException("Invalid hostname for server: " + address.getHostName());
            }
            throw e;
        }
    }

    protected HBaseServer(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, Configuration conf) throws IOException {
        this(bindAddress, port, paramClass, handlerCount, conf, Integer.toString(port));
    }

    protected HBaseServer(String bindAddress, int port, Class<? extends Writable> paramClass, int handlerCount, Configuration conf, String serverName) throws IOException {
        this.bindAddress = bindAddress;
        this.conf = conf;
        this.port = port;
        this.paramClass = paramClass;
        this.handlerCount = handlerCount;
        this.socketSendBufferSize = 0;
        this.maxQueueSize = handlerCount * 100;
        this.callQueue = new LinkedBlockingQueue<Call>(this.maxQueueSize);
        this.maxIdleTime = 2 * conf.getInt("ipc.client.connection.maxidletime", 1000);
        this.maxConnectionsToNuke = conf.getInt("ipc.client.kill.max", 10);
        this.thresholdIdleConnections = conf.getInt("ipc.client.idlethreshold", 4000);
        this.listener = new Listener();
        this.port = this.listener.getAddress().getPort();
        this.rpcMetrics = new HBaseRpcMetrics(serverName, Integer.toString(this.port));
        this.tcpNoDelay = conf.getBoolean("ipc.server.tcpnodelay", false);
        this.tcpKeepAlive = conf.getBoolean("ipc.server.tcpkeepalive", true);
        this.responder = new Responder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeConnection(Connection connection) {
        List<Connection> list = this.connectionList;
        synchronized (list) {
            if (this.connectionList.remove(connection)) {
                --this.numConnections;
            }
        }
        connection.close();
    }

    public void setSocketSendBufSize(int size) {
        this.socketSendBufferSize = size;
    }

    public synchronized void start() {
        this.responder.start();
        this.listener.start();
        this.handlers = new Handler[this.handlerCount];
        for (int i = 0; i < this.handlerCount; ++i) {
            this.handlers[i] = new Handler(i);
            this.handlers[i].start();
        }
    }

    public synchronized void stop() {
        LOG.info((Object)("Stopping server on " + this.port));
        this.running = false;
        if (this.handlers != null) {
            for (int i = 0; i < this.handlerCount; ++i) {
                if (this.handlers[i] == null) continue;
                this.handlers[i].interrupt();
            }
        }
        this.listener.interrupt();
        this.listener.doStop();
        this.responder.interrupt();
        this.notifyAll();
        if (this.rpcMetrics != null) {
            this.rpcMetrics.shutdown();
        }
    }

    public synchronized void join() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    public synchronized InetSocketAddress getListenerAddress() {
        return this.listener.getAddress();
    }

    public abstract Writable call(Writable var1, long var2) throws IOException;

    public int getNumOpenConnections() {
        return this.numConnections;
    }

    public int getCallQueueLen() {
        return this.callQueue.size();
    }

    public void setErrorHandler(HBaseRPCErrorHandler handler) {
        this.errorHandler = handler;
    }

    protected static int channelWrite(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        return buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.write(buffer) : HBaseServer.channelIO(null, channel, buffer);
    }

    protected static int channelRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        return buffer.remaining() <= NIO_BUFFER_LIMIT ? channel.read(buffer) : HBaseServer.channelIO(channel, null, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int channelIO(ReadableByteChannel readCh, WritableByteChannel writeCh, ByteBuffer buf) throws IOException {
        int nBytes;
        int originalLimit = buf.limit();
        int initialRemaining = buf.remaining();
        int ret = 0;
        while (buf.remaining() > 0) {
            try {
                int ioSize = Math.min(buf.remaining(), NIO_BUFFER_LIMIT);
                buf.limit(buf.position() + ioSize);
                ret = readCh == null ? writeCh.write(buf) : readCh.read(buf);
                if (ret >= ioSize) continue;
                break;
            }
            finally {
                buf.limit(originalLimit);
            }
        }
        return (nBytes = initialRemaining - buf.remaining()) > 0 ? nBytes : ret;
    }

    private class Handler
    extends Thread {
        public Handler(int instanceNumber) {
            this.setDaemon(true);
            this.setName("IPC Server handler " + instanceNumber + " on " + HBaseServer.this.port);
        }

        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(HBaseServer.this);
            int buffersize = 16384;
            ByteArrayOutputStream buf = new ByteArrayOutputStream(16384);
            while (HBaseServer.this.running) {
                try {
                    Call call = HBaseServer.this.callQueue.take();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": has #" + call.id + " from " + call.connection));
                    }
                    String errorClass = null;
                    String error = null;
                    Writable value = null;
                    CurCall.set(call);
                    UserGroupInformation previous = UserGroupInformation.getCurrentUGI();
                    UserGroupInformation.setCurrentUGI((UserGroupInformation)call.connection.ticket);
                    try {
                        value = HBaseServer.this.call(call.param, call.timestamp);
                    }
                    catch (Throwable e) {
                        LOG.info((Object)(this.getName() + ", call " + call + ": error: " + e), e);
                        errorClass = e.getClass().getName();
                        error = StringUtils.stringifyException((Throwable)e);
                    }
                    UserGroupInformation.setCurrentUGI((UserGroupInformation)previous);
                    CurCall.set(null);
                    if (buf.size() > 16384) {
                        buf = new ByteArrayOutputStream(16384);
                    } else {
                        buf.reset();
                    }
                    DataOutputStream out = new DataOutputStream(buf);
                    out.writeInt(call.id);
                    out.writeBoolean(error != null);
                    if (error == null) {
                        value.write((DataOutput)out);
                    } else {
                        WritableUtils.writeString((DataOutput)out, (String)errorClass);
                        WritableUtils.writeString((DataOutput)out, (String)error);
                    }
                    call.setResponse(ByteBuffer.wrap(buf.toByteArray()));
                    HBaseServer.this.responder.doRespond(call);
                }
                catch (InterruptedException e) {
                    if (!HBaseServer.this.running) continue;
                    LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException((Throwable)e)));
                }
                catch (OutOfMemoryError e) {
                    if (HBaseServer.this.errorHandler != null) {
                        if (!HBaseServer.this.errorHandler.checkOOME(e)) continue;
                        LOG.info((Object)(this.getName() + ": exiting on OOME"));
                        return;
                    }
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            LOG.info((Object)(this.getName() + ": exiting"));
        }
    }

    private class Connection {
        private boolean versionRead = false;
        private boolean headerRead = false;
        protected SocketChannel channel;
        private ByteBuffer data;
        private ByteBuffer dataLengthBuffer;
        protected LinkedList<Call> responseQueue;
        private volatile int rpcCount = 0;
        private long lastContact;
        private int dataLength;
        protected Socket socket;
        private String hostAddress;
        private int remotePort;
        protected UserGroupInformation ticket = null;

        public Connection(SocketChannel channel, long lastContact) {
            this.channel = channel;
            this.lastContact = lastContact;
            this.data = null;
            this.dataLengthBuffer = ByteBuffer.allocate(4);
            this.socket = channel.socket();
            InetAddress addr = this.socket.getInetAddress();
            this.hostAddress = addr == null ? "*Unknown*" : addr.getHostAddress();
            this.remotePort = this.socket.getPort();
            this.responseQueue = new LinkedList();
            if (HBaseServer.this.socketSendBufferSize != 0) {
                try {
                    this.socket.setSendBufferSize(HBaseServer.this.socketSendBufferSize);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Connection: unable to set socket send buffer size to " + HBaseServer.this.socketSendBufferSize));
                }
            }
        }

        public String toString() {
            return this.getHostAddress() + ":" + this.remotePort;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public void setLastContact(long lastContact) {
            this.lastContact = lastContact;
        }

        public long getLastContact() {
            return this.lastContact;
        }

        private boolean isIdle() {
            return this.rpcCount == 0;
        }

        protected void decRpcCount() {
            --this.rpcCount;
        }

        private void incRpcCount() {
            ++this.rpcCount;
        }

        protected boolean timedOut(long currentTime) {
            return this.isIdle() && currentTime - this.lastContact > (long)HBaseServer.this.maxIdleTime;
        }

        public int readAndProcess() throws IOException, InterruptedException {
            int count;
            while (true) {
                count = -1;
                if (this.dataLengthBuffer.remaining() > 0 && ((count = HBaseServer.channelRead(this.channel, this.dataLengthBuffer)) < 0 || this.dataLengthBuffer.remaining() > 0)) {
                    return count;
                }
                if (!this.versionRead) {
                    ByteBuffer versionBuffer = ByteBuffer.allocate(1);
                    count = HBaseServer.channelRead(this.channel, versionBuffer);
                    if (count <= 0) {
                        return count;
                    }
                    byte version = versionBuffer.get(0);
                    this.dataLengthBuffer.flip();
                    if (!HEADER.equals(this.dataLengthBuffer) || version != 3) {
                        LOG.warn((Object)("Incorrect header or version mismatch from " + this.hostAddress + ":" + this.remotePort + " got version " + version + " expected version " + 3));
                        return -1;
                    }
                    this.dataLengthBuffer.clear();
                    this.versionRead = true;
                    continue;
                }
                if (this.data == null) {
                    this.dataLengthBuffer.flip();
                    this.dataLength = this.dataLengthBuffer.getInt();
                    if (this.dataLength == -1) {
                        this.dataLengthBuffer.clear();
                        return 0;
                    }
                    this.data = ByteBuffer.allocate(this.dataLength);
                    this.incRpcCount();
                }
                count = HBaseServer.channelRead(this.channel, this.data);
                if (this.data.remaining() != 0) break;
                this.dataLengthBuffer.clear();
                this.data.flip();
                if (this.headerRead) {
                    this.processData();
                    this.data = null;
                    return count;
                }
                this.processHeader();
                this.headerRead = true;
                this.data = null;
            }
            return count;
        }

        private void processHeader() throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            this.ticket = (UserGroupInformation)ObjectWritable.readObject((DataInput)in, (Configuration)HBaseServer.this.conf);
        }

        private void processData() throws IOException, InterruptedException {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.data.array()));
            int id = dis.readInt();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(" got #" + id));
            }
            Writable param = (Writable)ReflectionUtils.newInstance(HBaseServer.this.paramClass, (Configuration)HBaseServer.this.conf);
            param.readFields((DataInput)dis);
            Call call = new Call(id, param, this);
            HBaseServer.this.callQueue.put(call);
        }

        protected synchronized void close() {
            this.data = null;
            this.dataLengthBuffer = null;
            if (!this.channel.isOpen()) {
                return;
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class Responder
    extends Thread {
        private Selector writeSelector;
        private int pending;
        static final int PURGE_INTERVAL = 900000;

        Responder() throws IOException {
            this.setName("IPC Server Responder");
            this.setDaemon(true);
            this.writeSelector = Selector.open();
            this.pending = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(HBaseServer.this);
            long lastPurgeTime = 0L;
            while (HBaseServer.this.running) {
                try {
                    ArrayList<Call> calls;
                    this.waitPending();
                    this.writeSelector.select(900000L);
                    Iterator<SelectionKey> iter = this.writeSelector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = iter.next();
                        iter.remove();
                        try {
                            if (!key.isValid() || !key.isWritable()) continue;
                            this.doAsyncWrite(key);
                        }
                        catch (IOException e) {
                            LOG.info((Object)(this.getName() + ": doAsyncWrite threw exception " + e));
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now < lastPurgeTime + 900000L) continue;
                    lastPurgeTime = now;
                    LOG.debug((Object)"Checking for old call responses.");
                    Set<SelectionKey> set = this.writeSelector.keys();
                    synchronized (set) {
                        calls = new ArrayList<Call>(this.writeSelector.keys().size());
                        for (SelectionKey key : this.writeSelector.keys()) {
                            Call call = (Call)key.attachment();
                            if (call == null || key.channel() != call.connection.channel) continue;
                            calls.add(call);
                        }
                    }
                    for (Call call : calls) {
                        this.doPurge(call, now);
                    }
                }
                catch (OutOfMemoryError e) {
                    if (HBaseServer.this.errorHandler != null) {
                        if (!HBaseServer.this.errorHandler.checkOOME(e)) continue;
                        LOG.info((Object)(this.getName() + ": exiting on OOME"));
                        return;
                    }
                    LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (Exception ie) {}
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception in Responder " + StringUtils.stringifyException((Throwable)e)));
                }
            }
            LOG.info((Object)("Stopping " + this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAsyncWrite(SelectionKey key) throws IOException {
            Call call = (Call)key.attachment();
            if (call == null) {
                return;
            }
            if (key.channel() != call.connection.channel) {
                throw new IOException("doAsyncWrite: bad channel");
            }
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                if (this.processResponse(call.connection.responseQueue, false)) {
                    try {
                        key.interestOps(0);
                    }
                    catch (CancelledKeyException e) {
                        LOG.warn((Object)("Exception while changing ops : " + e));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPurge(Call call, long now) {
            LinkedList<Call> responseQueue;
            LinkedList<Call> linkedList = responseQueue = call.connection.responseQueue;
            synchronized (linkedList) {
                ListIterator<Call> iter = responseQueue.listIterator(0);
                while (iter.hasNext()) {
                    Call nextCall = (Call)iter.next();
                    if (now <= nextCall.timestamp + 900000L) continue;
                    HBaseServer.this.closeConnection(nextCall.connection);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private boolean processResponse(LinkedList<Call> responseQueue, boolean inHandler) throws IOException {
            int numBytes;
            Call call;
            int numElements;
            boolean done;
            boolean error;
            block21: {
                error = true;
                done = false;
                numElements = 0;
                call = null;
                LinkedList<Call> linkedList = responseQueue;
                // MONITORENTER : linkedList
                numElements = responseQueue.size();
                if (numElements != 0) break block21;
                error = false;
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                HBaseServer.this.closeConnection(call.connection);
                return bl;
            }
            call = responseQueue.removeFirst();
            SocketChannel channel = call.connection.channel;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection));
            }
            if ((numBytes = HBaseServer.channelWrite(channel, call.response)) < 0) {
                boolean bl = true;
                // MONITOREXIT : linkedList
                if (!error) return bl;
                if (call == null) return bl;
                LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                done = true;
                HBaseServer.this.closeConnection(call.connection);
                return bl;
            }
            try {
                if (!call.response.hasRemaining()) {
                    call.connection.decRpcCount();
                    done = numElements == 1;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote " + numBytes + " bytes."));
                    }
                } else {
                    call.connection.responseQueue.addFirst(call);
                    if (inHandler) {
                        call.timestamp = System.currentTimeMillis();
                        this.incPending();
                        try {
                            this.writeSelector.wakeup();
                            channel.register(this.writeSelector, 4, call);
                        }
                        catch (ClosedChannelException e) {
                            done = true;
                        }
                        finally {
                            this.decPending();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(this.getName() + ": responding to #" + call.id + " from " + call.connection + " Wrote partial " + numBytes + " bytes."));
                    }
                }
                error = false;
                // MONITOREXIT : linkedList
                return done;
            }
            finally {
                if (error && call != null) {
                    LOG.warn((Object)(this.getName() + ", call " + call + ": output error"));
                    done = true;
                    HBaseServer.this.closeConnection(call.connection);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doRespond(Call call) throws IOException {
            LinkedList<Call> linkedList = call.connection.responseQueue;
            synchronized (linkedList) {
                call.connection.responseQueue.addLast(call);
                if (call.connection.responseQueue.size() == 1) {
                    this.processResponse(call.connection.responseQueue, true);
                }
            }
        }

        private synchronized void incPending() {
            ++this.pending;
        }

        private synchronized void decPending() {
            --this.pending;
            this.notify();
        }

        private synchronized void waitPending() throws InterruptedException {
            while (this.pending > 0) {
                this.wait();
            }
        }
    }

    private class Listener
    extends Thread {
        private ServerSocketChannel acceptChannel = null;
        private Selector selector = null;
        private InetSocketAddress address;
        private Random rand = new Random();
        private long lastCleanupRunTime = 0L;
        private long cleanupInterval = 10000L;
        private int backlogLength;

        public Listener() throws IOException {
            this.backlogLength = HBaseServer.this.conf.getInt("ipc.server.listen.queue.size", 128);
            this.address = new InetSocketAddress(HBaseServer.this.bindAddress, HBaseServer.this.port);
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            HBaseServer.bind(this.acceptChannel.socket(), this.address, this.backlogLength);
            HBaseServer.this.port = this.acceptChannel.socket().getLocalPort();
            this.selector = Selector.open();
            this.acceptChannel.register(this.selector, 16);
            this.setName("IPC Server listener on " + HBaseServer.this.port);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanupConnections(boolean force) {
            if (force || HBaseServer.this.numConnections > HBaseServer.this.thresholdIdleConnections) {
                long currentTime = System.currentTimeMillis();
                if (!force && currentTime - this.lastCleanupRunTime < this.cleanupInterval) {
                    return;
                }
                int start = 0;
                int end = HBaseServer.this.numConnections - 1;
                if (!force) {
                    start = this.rand.nextInt() % HBaseServer.this.numConnections;
                    end = this.rand.nextInt() % HBaseServer.this.numConnections;
                    if (end < start) {
                        int temp = start;
                        start = end;
                        end = temp;
                    }
                }
                int i = start;
                int numNuked = 0;
                while (i <= end) {
                    Connection c;
                    List<Connection> list = HBaseServer.this.connectionList;
                    synchronized (list) {
                        try {
                            c = HBaseServer.this.connectionList.get(i);
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    if (c.timedOut(currentTime)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                        }
                        HBaseServer.this.closeConnection(c);
                        --end;
                        c = null;
                        if (force || ++numNuked != HBaseServer.this.maxConnectionsToNuke) continue;
                        break;
                    }
                    ++i;
                }
                this.lastCleanupRunTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)(this.getName() + ": starting"));
            SERVER.set(HBaseServer.this);
            while (HBaseServer.this.running) {
                SelectionKey key = null;
                try {
                    this.selector.select();
                    Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        key = iter.next();
                        iter.remove();
                        try {
                            if (key.isValid()) {
                                if (key.isAcceptable()) {
                                    this.doAccept(key);
                                } else if (key.isReadable()) {
                                    this.doRead(key);
                                }
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        key = null;
                    }
                }
                catch (OutOfMemoryError e) {
                    if (HBaseServer.this.errorHandler != null) {
                        if (HBaseServer.this.errorHandler.checkOOME(e)) {
                            LOG.info((Object)(this.getName() + ": exiting on OOME"));
                            this.closeCurrentConnection(key);
                            this.cleanupConnections(true);
                            return;
                        }
                    } else {
                        LOG.warn((Object)"Out of Memory in server select", (Throwable)e);
                        this.closeCurrentConnection(key);
                        this.cleanupConnections(true);
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (InterruptedException e) {
                    if (HBaseServer.this.running) {
                        LOG.info((Object)(this.getName() + " caught: " + StringUtils.stringifyException((Throwable)e)));
                    }
                }
                catch (Exception e) {
                    this.closeCurrentConnection(key);
                }
                this.cleanupConnections(false);
            }
            LOG.info((Object)("Stopping " + this.getName()));
            Listener listener = this;
            synchronized (listener) {
                try {
                    this.acceptChannel.close();
                    this.selector.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.selector = null;
                this.acceptChannel = null;
                while (!HBaseServer.this.connectionList.isEmpty()) {
                    HBaseServer.this.closeConnection(HBaseServer.this.connectionList.remove(0));
                }
            }
        }

        private void closeCurrentConnection(SelectionKey key) {
            Connection c;
            if (key != null && (c = (Connection)key.attachment()) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress()));
                }
                HBaseServer.this.closeConnection(c);
                Object var2_2 = null;
            }
        }

        InetSocketAddress getAddress() {
            return (InetSocketAddress)this.acceptChannel.socket().getLocalSocketAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doAccept(SelectionKey key) throws IOException, OutOfMemoryError {
            Connection c = null;
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            for (int i = 0; i < 10; ++i) {
                SocketChannel channel = server.accept();
                if (channel == null) {
                    return;
                }
                channel.configureBlocking(false);
                channel.socket().setTcpNoDelay(HBaseServer.this.tcpNoDelay);
                channel.socket().setKeepAlive(HBaseServer.this.tcpKeepAlive);
                SelectionKey readKey = channel.register(this.selector, 1);
                c = new Connection(channel, System.currentTimeMillis());
                readKey.attach(c);
                List<Connection> list = HBaseServer.this.connectionList;
                synchronized (list) {
                    HBaseServer.this.connectionList.add(HBaseServer.this.numConnections, c);
                    ++HBaseServer.this.numConnections;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Server connection from " + c.toString() + "; # active connections: " + HBaseServer.this.numConnections + "; # queued calls: " + HBaseServer.this.callQueue.size()));
            }
        }

        void doRead(SelectionKey key) throws InterruptedException {
            int count = 0;
            Connection c = (Connection)key.attachment();
            if (c == null) {
                return;
            }
            c.setLastContact(System.currentTimeMillis());
            try {
                count = c.readAndProcess();
            }
            catch (InterruptedException ieo) {
                throw ieo;
            }
            catch (Exception e) {
                LOG.debug((Object)(this.getName() + ": readAndProcess threw exception " + e + ". Count of bytes read: " + count), (Throwable)e);
                count = -1;
            }
            if (count < 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": disconnecting client " + c.getHostAddress() + ". Number of active connections: " + HBaseServer.this.numConnections));
                }
                HBaseServer.this.closeConnection(c);
                c = null;
            } else {
                c.setLastContact(System.currentTimeMillis());
            }
        }

        synchronized void doStop() {
            if (this.selector != null) {
                this.selector.wakeup();
                Thread.yield();
            }
            if (this.acceptChannel != null) {
                try {
                    this.acceptChannel.socket().close();
                }
                catch (IOException e) {
                    LOG.info((Object)(this.getName() + ":Exception in closing listener socket. " + e));
                }
            }
        }
    }

    private static class Call {
        protected int id;
        protected Writable param;
        protected Connection connection;
        protected long timestamp;
        protected ByteBuffer response;

        public Call(int id, Writable param, Connection connection) {
            this.id = id;
            this.param = param;
            this.connection = connection;
            this.timestamp = System.currentTimeMillis();
            this.response = null;
        }

        public String toString() {
            return this.param.toString() + " from " + this.connection.toString();
        }

        public void setResponse(ByteBuffer response) {
            this.response = response;
        }
    }
}

