/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.IndexConfiguration;
import org.apache.hadoop.hbase.mapred.LuceneDocumentWrapper;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Similarity;

@Deprecated
public class IndexOutputFormat
extends FileOutputFormat<ImmutableBytesWritable, LuceneDocumentWrapper> {
    static final Log LOG = LogFactory.getLog(IndexOutputFormat.class);
    private Random random = new Random();

    public RecordWriter<ImmutableBytesWritable, LuceneDocumentWrapper> getRecordWriter(final FileSystem fs, JobConf job, String name, final Progressable progress) throws IOException {
        Analyzer analyzer;
        final Path perm = new Path(FileOutputFormat.getOutputPath((JobConf)job), name);
        final Path temp = job.getLocalPath("index/_" + Integer.toString(this.random.nextInt()));
        LOG.info((Object)("To index into " + perm));
        fs.delete(perm, true);
        final IndexConfiguration indexConf = new IndexConfiguration();
        String content = job.get("hbase.index.conf");
        if (content != null) {
            indexConf.addFromXML(content);
        }
        String analyzerName = indexConf.getAnalyzerName();
        try {
            Class<?> analyzerClass = Class.forName(analyzerName);
            analyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new IOException("Error in creating an analyzer object " + analyzerName);
        }
        final IndexWriter writer = new IndexWriter(fs.startLocalOutput(perm, temp).toString(), analyzer, true);
        writer.setMaxBufferedDocs(indexConf.getMaxBufferedDocs());
        writer.setMaxFieldLength(indexConf.getMaxFieldLength());
        writer.setMaxMergeDocs(indexConf.getMaxMergeDocs());
        writer.setMergeFactor(indexConf.getMergeFactor());
        String similarityName = indexConf.getSimilarityName();
        if (similarityName != null) {
            try {
                Class<?> similarityClass = Class.forName(similarityName);
                Similarity similarity = (Similarity)similarityClass.newInstance();
                writer.setSimilarity(similarity);
            }
            catch (Exception e) {
                throw new IOException("Error in creating a similarty object " + similarityName);
            }
        }
        writer.setUseCompoundFile(indexConf.isUseCompoundFile());
        return new RecordWriter<ImmutableBytesWritable, LuceneDocumentWrapper>(){
            boolean closed;
            private long docCount = 0L;

            public void write(ImmutableBytesWritable key, LuceneDocumentWrapper value) throws IOException {
                Document doc = value.get();
                writer.addDocument(doc);
                ++this.docCount;
                progress.progress();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close(final Reporter reporter) throws IOException {
                Thread prog = new Thread(){

                    @Override
                    public void run() {
                        while (!closed) {
                            try {
                                reporter.setStatus("closing");
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                            }
                            catch (Throwable e) {
                                return;
                            }
                        }
                    }
                };
                try {
                    prog.start();
                    if (indexConf.doOptimize()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"Optimizing index.");
                        }
                        writer.optimize();
                    }
                    writer.close();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Done indexing " + this.docCount + " docs."));
                    }
                    fs.completeLocalOutput(perm, temp);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"Copy done.");
                    }
                }
                finally {
                    this.closed = true;
                }
            }
        };
    }
}

