/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.mapred.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;

@Deprecated
public abstract class TableInputFormatBase
implements InputFormat<ImmutableBytesWritable, RowResult> {
    final Log LOG = LogFactory.getLog(TableInputFormatBase.class);
    private byte[][] inputColumns;
    private HTable table;
    private TableRecordReader tableRecordReader;
    private RowFilterInterface rowFilter;

    public RecordReader<ImmutableBytesWritable, RowResult> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        TableSplit tSplit = (TableSplit)split;
        TableRecordReader trr = this.tableRecordReader;
        if (trr == null) {
            trr = new TableRecordReader();
        }
        trr.setStartRow(tSplit.getStartRow());
        trr.setEndRow(tSplit.getEndRow());
        trr.setHTable(this.table);
        trr.setInputColumns(this.inputColumns);
        trr.setRowFilter(this.rowFilter);
        trr.init();
        return trr;
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (this.table == null) {
            throw new IOException("No table was provided");
        }
        byte[][] startKeys = this.table.getStartKeys();
        if (startKeys == null || startKeys.length == 0) {
            throw new IOException("Expecting at least one region");
        }
        if (this.inputColumns == null || this.inputColumns.length == 0) {
            throw new IOException("Expecting at least one column");
        }
        int realNumSplits = numSplits > startKeys.length ? startKeys.length : numSplits;
        InputSplit[] splits = new InputSplit[realNumSplits];
        int middle = startKeys.length / realNumSplits;
        int startPos = 0;
        for (int i = 0; i < realNumSplits; ++i) {
            int lastPos = startPos + middle;
            lastPos = startKeys.length % realNumSplits > i ? lastPos + 1 : lastPos;
            String regionLocation = this.table.getRegionLocation(startKeys[startPos]).getServerAddress().getHostname();
            splits[i] = new TableSplit(this.table.getTableName(), startKeys[startPos], i + 1 < realNumSplits ? startKeys[lastPos] : HConstants.EMPTY_START_ROW, regionLocation);
            this.LOG.info((Object)("split: " + i + "->" + splits[i]));
            startPos = lastPos;
        }
        return splits;
    }

    protected void setInputColumns(byte[][] inputColumns) {
        this.inputColumns = inputColumns;
    }

    protected HTable getHTable() {
        return this.table;
    }

    protected void setHTable(HTable table) {
        this.table = table;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }

    protected void setRowFilter(RowFilterInterface rowFilter) {
        this.rowFilter = rowFilter;
    }

    protected class TableRecordReader
    implements RecordReader<ImmutableBytesWritable, RowResult> {
        private byte[] startRow;
        private byte[] endRow;
        private byte[] lastRow;
        private RowFilterInterface trrRowFilter;
        private ResultScanner scanner;
        private HTable htable;
        private byte[][] trrInputColumns;

        protected TableRecordReader() {
        }

        public void restart(byte[] firstRow) throws IOException {
            if (this.endRow != null && this.endRow.length > 0) {
                if (this.trrRowFilter != null) {
                    Scan scan = new Scan(firstRow, this.endRow);
                    scan.addColumns(this.trrInputColumns);
                    scan.setOldFilter(this.trrRowFilter);
                    this.scanner = this.htable.getScanner(scan);
                } else {
                    TableInputFormatBase.this.LOG.debug((Object)("TIFB.restart, firstRow: " + Bytes.toStringBinary(firstRow) + ", endRow: " + Bytes.toStringBinary(this.endRow)));
                    Scan scan = new Scan(firstRow, this.endRow);
                    scan.addColumns(this.trrInputColumns);
                    this.scanner = this.htable.getScanner(scan);
                }
            } else {
                TableInputFormatBase.this.LOG.debug((Object)("TIFB.restart, firstRow: " + Bytes.toStringBinary(firstRow) + ", no endRow"));
                Scan scan = new Scan(firstRow);
                scan.addColumns(this.trrInputColumns);
                this.scanner = this.htable.getScanner(scan);
            }
        }

        public void init() throws IOException {
            this.restart(this.startRow);
        }

        public void setHTable(HTable htable) {
            this.htable = htable;
        }

        public void setInputColumns(byte[][] inputColumns) {
            this.trrInputColumns = inputColumns;
        }

        public void setStartRow(byte[] startRow) {
            this.startRow = startRow;
        }

        public void setEndRow(byte[] endRow) {
            this.endRow = endRow;
        }

        public void setRowFilter(RowFilterInterface rowFilter) {
            this.trrRowFilter = rowFilter;
        }

        public void close() {
            this.scanner.close();
        }

        public ImmutableBytesWritable createKey() {
            return new ImmutableBytesWritable();
        }

        public RowResult createValue() {
            return new RowResult();
        }

        public long getPos() {
            return 0L;
        }

        public float getProgress() {
            return 0.0f;
        }

        public boolean next(ImmutableBytesWritable key, RowResult value) throws IOException {
            Result result;
            try {
                result = this.scanner.next();
            }
            catch (UnknownScannerException e) {
                TableInputFormatBase.this.LOG.debug((Object)("recovered from " + StringUtils.stringifyException((Throwable)e)));
                this.restart(this.lastRow);
                this.scanner.next();
                result = this.scanner.next();
            }
            if (result != null && result.size() > 0) {
                key.set(result.getRow());
                this.lastRow = key.get();
                Writables.copyWritable(result.getRowResult(), (Writable)value);
                return true;
            }
            return false;
        }
    }
}

