/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.IdentityTableMapper;
import org.apache.hadoop.hbase.mapreduce.IndexConfiguration;
import org.apache.hadoop.hbase.mapreduce.IndexOutputFormat;
import org.apache.hadoop.hbase.mapreduce.IndexTableReducer;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class BuildTableIndex {
    private static final String USAGE = "Usage: BuildTableIndex -r <numReduceTasks> -indexConf <iconfFile>\n-indexDir <indexDir> -table <tableName>\n -columns <columnName1> [<columnName2> ...]";

    private static void printUsage(String message) {
        System.err.println(message);
        System.err.println(USAGE);
        System.exit(-1);
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        if (args.length < 6) {
            BuildTableIndex.printUsage("Too few arguments");
        }
        int numReduceTasks = 1;
        String iconfFile = null;
        String indexDir = null;
        String tableName = null;
        StringBuffer columnNames = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if ("-r".equals(args[i])) {
                numReduceTasks = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-indexConf".equals(args[i])) {
                iconfFile = args[++i];
                continue;
            }
            if ("-indexDir".equals(args[i])) {
                indexDir = args[++i];
                continue;
            }
            if ("-table".equals(args[i])) {
                tableName = args[++i];
                continue;
            }
            if ("-columns".equals(args[i])) {
                columnNames = new StringBuffer(args[++i]);
                while (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    columnNames.append(" ");
                    columnNames.append(args[++i]);
                }
                continue;
            }
            BuildTableIndex.printUsage("Unsupported option " + args[i]);
        }
        if (indexDir == null || tableName == null || columnNames == null) {
            BuildTableIndex.printUsage("Index directory, table name and at least one column must be specified");
        }
        if (iconfFile != null) {
            String content = BuildTableIndex.readContent(iconfFile);
            IndexConfiguration iconf = new IndexConfiguration();
            iconf.addFromXML(content);
            conf.set("hbase.index.conf", content);
        }
        Job job = new Job(conf, "build index for table " + tableName);
        job.setNumReduceTasks(numReduceTasks);
        Scan scan = new Scan();
        scan.addColumns(columnNames.toString());
        IdentityTableMapper.initJob(tableName, scan, IdentityTableMapper.class, job);
        job.setReducerClass(IndexTableReducer.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(indexDir));
        job.setOutputFormatClass(IndexOutputFormat.class);
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContent(String fileName) throws IOException {
        int bytesRead;
        File file = new File(fileName);
        int length = (int)file.length();
        if (length == 0) {
            BuildTableIndex.printUsage("Index configuration file " + fileName + " does not exist");
        }
        byte[] bytes = new byte[length];
        FileInputStream fis = new FileInputStream(file);
        try {
            int read;
            for (bytesRead = 0; bytesRead < length && (read = fis.read(bytes, bytesRead, length - bytesRead)) > 0; bytesRead += read) {
            }
        }
        finally {
            fis.close();
        }
        return new String(bytes, 0, bytesRead, "UTF-8");
    }

    public static void main(String[] args) throws Exception {
        HBaseConfiguration conf = new HBaseConfiguration();
        String[] otherArgs = new GenericOptionsParser((Configuration)conf, args).getRemainingArgs();
        Job job = BuildTableIndex.createSubmittableJob(conf, otherArgs);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }
}

