/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.mapreduce.TableOutputCommitter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TableOutputFormat<KEY>
extends OutputFormat<KEY, Writable> {
    private final Log LOG = LogFactory.getLog(TableOutputFormat.class);
    public static final String OUTPUT_TABLE = "hbase.mapred.outputtable";

    public RecordWriter<KEY, Writable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        String tableName = context.getConfiguration().get(OUTPUT_TABLE);
        HTable table = null;
        try {
            table = new HTable(new HBaseConfiguration(context.getConfiguration()), tableName);
        }
        catch (IOException e) {
            this.LOG.error((Object)e);
            throw e;
        }
        table.setAutoFlush(false);
        return new TableRecordWriter(table);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableOutputCommitter();
    }

    protected static class TableRecordWriter<KEY>
    extends RecordWriter<KEY, Writable> {
        private HTable table;

        public TableRecordWriter(HTable table) {
            this.table = table;
        }

        public void close(TaskAttemptContext context) throws IOException {
            this.table.flushCommits();
        }

        public void write(KEY key, Writable value) throws IOException {
            if (value instanceof Put) {
                this.table.put(new Put((Put)value));
            } else if (value instanceof Delete) {
                this.table.delete(new Delete((Delete)value));
            } else {
                throw new IOException("Pass a Delete or a Put");
            }
        }
    }
}

