/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.TableOperation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;

class ModifyTableMeta
extends TableOperation {
    private static Log LOG = LogFactory.getLog(ModifyTableMeta.class);
    private HTableDescriptor desc;

    ModifyTableMeta(HMaster master, byte[] tableName, HTableDescriptor desc) throws IOException {
        super(master, tableName);
        this.desc = desc;
        LOG.debug((Object)("modifying " + Bytes.toString(tableName) + ": " + desc.toString()));
    }

    protected void updateRegionInfo(HRegionInterface server, byte[] regionName, HRegionInfo i) throws IOException {
        Put put = new Put(i.getRegionName());
        put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)i));
        server.put(regionName, put);
        LOG.debug((Object)("updated HTableDescriptor for region " + i.getRegionNameAsString()));
    }

    @Override
    protected void processScanItem(String serverName, HRegionInfo info) throws IOException {
        if (this.isEnabled(info)) {
            throw new TableNotDisabledException(Bytes.toString(this.tableName));
        }
    }

    @Override
    protected void postProcessMeta(MetaRegion m, HRegionInterface server) throws IOException {
        for (HRegionInfo i : this.unservedRegions) {
            i.setTableDesc(this.desc);
            this.updateRegionInfo(server, m.getRegionName(), i);
        }
        this.master.regionManager.metaScannerThread.interrupt();
    }
}

