/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.master.BaseScanner;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;

class RootScanner
extends BaseScanner {
    public RootScanner(HMaster master) {
        super(master, true, master.metaRescanInterval, master.shutdownRequested);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scanRoot() {
        this.master.waitForRootRegionLocation();
        if (this.master.closed.get()) {
            return false;
        }
        try {
            Object object = this.scannerLock;
            synchronized (object) {
                if (this.master.getRootRegionLocation() != null) {
                    this.scanRegion(new MetaRegion(this.master.getRootRegionLocation(), HRegionInfo.ROOT_REGIONINFO));
                }
            }
        }
        catch (IOException e) {
            e = RemoteExceptionHandler.checkIOException(e);
            LOG.warn((Object)"Scan ROOT region", (Throwable)e);
            this.master.checkFileSystem();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected exception", (Throwable)e);
        }
        return true;
    }

    @Override
    protected boolean initialScan() {
        this.initialScanComplete = this.scanRoot();
        return this.initialScanComplete;
    }

    @Override
    protected void maintenanceScan() {
        this.scanRoot();
    }
}

