/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HMsg;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.Leases;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.ProcessRegionClose;
import org.apache.hadoop.hbase.master.ProcessRegionOpen;
import org.apache.hadoop.hbase.master.ProcessServerShutdown;
import org.apache.hadoop.hbase.master.RegionManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

class ServerManager
implements HConstants {
    static final Log LOG = LogFactory.getLog((String)ServerManager.class.getName());
    private static final HMsg REGIONSERVER_QUIESCE = new HMsg(HMsg.Type.MSG_REGIONSERVER_QUIESCE);
    private static final HMsg REGIONSERVER_STOP = new HMsg(HMsg.Type.MSG_REGIONSERVER_STOP);
    private static final HMsg CALL_SERVER_STARTUP = new HMsg(HMsg.Type.MSG_CALL_SERVER_STARTUP);
    private static final HMsg[] EMPTY_HMSG_ARRAY = new HMsg[0];
    private final AtomicInteger quiescedServers = new AtomicInteger(0);
    final Map<String, HServerInfo> serversToServerInfo = new ConcurrentHashMap<String, HServerInfo>();
    final Map<HServerAddress, HServerInfo> serverAddressToServerInfo = new ConcurrentHashMap<HServerAddress, HServerInfo>();
    protected final Set<String> deadServers = Collections.synchronizedSet(new HashSet());
    final SortedMap<HServerLoad, Set<String>> loadToServers = Collections.synchronizedSortedMap(new TreeMap());
    final Map<String, HServerLoad> serversToLoad = new ConcurrentHashMap<String, HServerLoad>();
    protected HMaster master;
    private final int nobalancingCount;
    ServerMonitor serverMonitorThread;
    private int minimumServerCount;

    public ServerManager(HMaster master) {
        this.master = master;
        HBaseConfiguration c = master.getConfiguration();
        this.nobalancingCount = c.getInt("hbase.regions.nobalancing.count", 4);
        this.minimumServerCount = c.getInt("hbase.regions.server.count.min", 0);
        this.serverMonitorThread = new ServerMonitor(master.metaRescanInterval, master.shutdownRequested);
        this.serverMonitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regionServerStartup(HServerInfo serverInfo) throws Leases.LeaseStillHeldException {
        HServerInfo storedInfo;
        HServerInfo info = new HServerInfo(serverInfo);
        String serverName = HServerInfo.getServerName(info);
        if (this.serversToServerInfo.containsKey(serverName) || this.deadServers.contains(serverName)) {
            LOG.debug((Object)("Server start was rejected: " + serverInfo));
            LOG.debug((Object)("serversToServerInfo.containsKey: " + this.serversToServerInfo.containsKey(serverName)));
            LOG.debug((Object)("deadServers.contains: " + this.deadServers.contains(serverName)));
            throw new Leases.LeaseStillHeldException(serverName);
        }
        LOG.info((Object)("Received start message from: " + serverName));
        HServerLoad load = this.serversToLoad.remove(serverName);
        if (load != null) {
            SortedMap<HServerLoad, Set<String>> sortedMap = this.loadToServers;
            synchronized (sortedMap) {
                Set servers = (Set)this.loadToServers.get(load);
                if (servers != null) {
                    servers.remove(serverName);
                    if (servers.size() > 0) {
                        this.loadToServers.put(load, servers);
                    } else {
                        this.loadToServers.remove(load);
                    }
                }
            }
        }
        if ((storedInfo = this.serversToServerInfo.remove(serverName)) != null && !this.master.closed.get()) {
            this.master.getRootRegionLocation();
            try {
                this.master.toDoQueue.put(new ProcessServerShutdown(this.master, storedInfo));
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Insertion into toDoQueue was interrupted", (Throwable)e);
            }
        }
        this.recordNewServer(info);
    }

    public void recordNewServer(HServerInfo info) {
        this.recordNewServer(info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordNewServer(HServerInfo info, boolean useInfoLoad) {
        HServerLoad load = useInfoLoad ? info.getLoad() : new HServerLoad();
        String serverName = HServerInfo.getServerName(info);
        info.setLoad(load);
        ServerExpirer watcher = new ServerExpirer(serverName, info.getServerAddress());
        this.master.getZooKeeperWrapper().updateRSLocationGetWatch(info, watcher);
        this.serversToServerInfo.put(serverName, info);
        this.serverAddressToServerInfo.put(info.getServerAddress(), info);
        this.serversToLoad.put(serverName, load);
        SortedMap<HServerLoad, Set<String>> sortedMap = this.loadToServers;
        synchronized (sortedMap) {
            HashSet<String> servers = (HashSet<String>)this.loadToServers.get(load);
            if (servers == null) {
                servers = new HashSet<String>();
            }
            servers.add(serverName);
            this.loadToServers.put(load, servers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HMsg[] regionServerReport(HServerInfo serverInfo, HMsg[] msgs, HRegionInfo[] mostLoadedRegions) throws IOException {
        HServerInfo info = new HServerInfo(serverInfo);
        if (this.isDead(info.getServerName())) {
            throw new Leases.LeaseStillHeldException(info.getServerName());
        }
        if (msgs.length > 0) {
            if (msgs[0].isType(HMsg.Type.MSG_REPORT_EXITING)) {
                this.processRegionServerExit(info, msgs);
                return EMPTY_HMSG_ARRAY;
            }
            if (msgs[0].isType(HMsg.Type.MSG_REPORT_QUIESCED)) {
                LOG.info((Object)("Region server " + info.getServerName() + " quiesced"));
                this.quiescedServers.incrementAndGet();
            }
        }
        if (this.master.shutdownRequested.get()) {
            if (this.quiescedServers.get() >= this.serversToServerInfo.size()) {
                LOG.info((Object)"All user tables quiesced. Proceeding with shutdown");
                this.master.startShutdown();
            }
            if (!this.master.closed.get()) {
                if (msgs.length > 0 && msgs[0].isType(HMsg.Type.MSG_REPORT_QUIESCED)) {
                    return EMPTY_HMSG_ARRAY;
                }
                return new HMsg[]{REGIONSERVER_QUIESCE};
            }
        }
        if (this.master.closed.get()) {
            return new HMsg[]{REGIONSERVER_STOP};
        }
        HServerInfo storedInfo = this.serversToServerInfo.get(info.getServerName());
        if (storedInfo == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received report from unknown server -- telling it to " + CALL_SERVER_STARTUP + ": " + info.getServerName()));
            }
            return new HMsg[]{CALL_SERVER_STARTUP};
        }
        if (storedInfo.getStartCode() != info.getStartCode()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("region server race condition detected: " + info.getServerName()));
            }
            Map<String, HServerInfo> map = this.serversToServerInfo;
            synchronized (map) {
                this.removeServerInfo(info.getServerName(), info.getServerAddress());
                this.serversToServerInfo.notifyAll();
            }
            return new HMsg[]{REGIONSERVER_STOP};
        }
        return this.processRegionServerAllsWell(info, mostLoadedRegions, msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRegionServerExit(HServerInfo serverInfo, HMsg[] msgs) {
        Map<String, HServerInfo> map = this.serversToServerInfo;
        synchronized (map) {
            try {
                if (this.removeServerInfo(serverInfo.getServerName(), serverInfo.getServerAddress())) {
                    LOG.info((Object)("Region server " + serverInfo.getServerName() + ": MSG_REPORT_EXITING"));
                    if (!this.master.closed.get()) {
                        for (int i = 1; i < msgs.length; ++i) {
                            LOG.info((Object)("Processing " + msgs[i] + " from " + serverInfo.getServerName()));
                            HRegionInfo info = msgs[i].getRegionInfo();
                            if (info.isMetaRegion()) continue;
                            RegionManager regionManager = this.master.regionManager;
                            synchronized (regionManager) {
                                if (!this.master.regionManager.isOfflined(info.getRegionNameAsString())) {
                                    this.master.regionManager.setUnassigned(info, true);
                                } else {
                                    this.master.regionManager.removeRegion(info);
                                }
                                continue;
                            }
                        }
                    }
                }
            }
            finally {
                this.serversToServerInfo.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HMsg[] processRegionServerAllsWell(HServerInfo serverInfo, HRegionInfo[] mostLoadedRegions, HMsg[] msgs) throws IOException {
        HashSet<String> servers;
        SortedMap<HServerLoad, Set<String>> sortedMap;
        this.serverAddressToServerInfo.put(serverInfo.getServerAddress(), serverInfo);
        this.serversToServerInfo.put(serverInfo.getServerName(), serverInfo);
        HServerLoad load = this.serversToLoad.get(serverInfo.getServerName());
        if (load != null) {
            this.master.getMetrics().incrementRequests(load.getNumberOfRequests());
            if (!load.equals(serverInfo.getLoad())) {
                sortedMap = this.loadToServers;
                synchronized (sortedMap) {
                    servers = (Set)this.loadToServers.get(load);
                    servers.remove(serverInfo.getServerName());
                    if (servers.size() > 0) {
                        this.loadToServers.put(load, servers);
                    } else {
                        this.loadToServers.remove(load);
                    }
                }
            }
        }
        load = serverInfo.getLoad();
        this.serversToLoad.put(serverInfo.getServerName(), load);
        sortedMap = this.loadToServers;
        synchronized (sortedMap) {
            servers = (HashSet<String>)this.loadToServers.get(load);
            if (servers == null) {
                servers = new HashSet<String>();
            }
            servers.add(serverInfo.getServerName());
            this.loadToServers.put(load, servers);
        }
        return this.processMsgs(serverInfo, mostLoadedRegions, msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HMsg[] processMsgs(HServerInfo serverInfo, HRegionInfo[] mostLoadedRegions, HMsg[] incomingMsgs) {
        ArrayList<HMsg> returnMsgs = new ArrayList<HMsg>();
        if (serverInfo.getServerAddress() == null) {
            throw new NullPointerException("Server address cannot be null; hbase-958 debugging");
        }
        int openingCount = 0;
        block9: for (int i = 0; i < incomingMsgs.length; ++i) {
            HRegionInfo region = incomingMsgs[i].getRegionInfo();
            LOG.info((Object)("Processing " + incomingMsgs[i] + " from " + serverInfo.getServerName() + "; " + (i + 1) + " of " + incomingMsgs.length));
            switch (incomingMsgs[i].getType()) {
                case MSG_REPORT_PROCESS_OPEN: {
                    ++openingCount;
                    continue block9;
                }
                case MSG_REPORT_OPEN: {
                    this.processRegionOpen(serverInfo, region, returnMsgs);
                    continue block9;
                }
                case MSG_REPORT_CLOSE: {
                    this.processRegionClose(region);
                    continue block9;
                }
                case MSG_REPORT_SPLIT: {
                    this.processSplitRegion(region, incomingMsgs[++i], incomingMsgs[++i]);
                    continue block9;
                }
                default: {
                    LOG.warn((Object)("Impossible state during message processing. Instruction: " + (Object)((Object)incomingMsgs[i].getType())));
                }
            }
        }
        RegionManager regionManager = this.master.regionManager;
        synchronized (regionManager) {
            for (HRegionInfo i : this.master.regionManager.getMarkedToClose(serverInfo.getServerName())) {
                returnMsgs.add(new HMsg(HMsg.Type.MSG_REGION_CLOSE, i));
                this.master.regionManager.setPendingClose(i.getRegionNameAsString());
            }
            if (openingCount < this.nobalancingCount) {
                this.master.regionManager.assignRegions(serverInfo, mostLoadedRegions, returnMsgs);
            }
            this.master.regionManager.applyActions(serverInfo, returnMsgs);
        }
        return returnMsgs.toArray(new HMsg[returnMsgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSplitRegion(HRegionInfo region, HMsg splitA, HMsg splitB) {
        RegionManager regionManager = this.master.regionManager;
        synchronized (regionManager) {
            this.master.regionManager.endActions(region.getRegionName());
            this.assignSplitDaughter(splitA.getRegionInfo());
            this.assignSplitDaughter(splitB.getRegionInfo());
            if (region.isMetaTable()) {
                this.master.regionManager.offlineMetaRegion(region.getStartKey());
                this.master.regionManager.incrementNumMetaRegions();
            }
        }
    }

    private void assignSplitDaughter(HRegionInfo hri) {
        MetaRegion mr = this.master.regionManager.getFirstMetaRegionForRegion(hri);
        Get g = new Get(hri.getRegionName());
        g.addFamily(HConstants.CATALOG_FAMILY);
        try {
            HRegionInterface server = this.master.connection.getHRegionConnection(mr.getServer());
            Result r = server.get(mr.getRegionName(), g);
            if (r.size() >= 3) {
                return;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed get on info; possible double-assignment?", (Throwable)e);
        }
        this.master.regionManager.setUnassigned(hri, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRegionOpen(HServerInfo serverInfo, HRegionInfo region, ArrayList<HMsg> returnMsgs) {
        boolean duplicateAssignment = false;
        RegionManager regionManager = this.master.regionManager;
        synchronized (regionManager) {
            HServerAddress rootServer;
            if (!this.master.regionManager.isUnassigned(region) && !this.master.regionManager.isPendingOpen(region.getRegionNameAsString())) {
                if (region.isRootRegion()) {
                    rootServer = this.master.getRootRegionLocation();
                    if (rootServer != null) {
                        if (rootServer.compareTo(serverInfo.getServerAddress()) == 0) {
                            return;
                        }
                        duplicateAssignment = true;
                    }
                } else {
                    if (this.master.regionManager.isPendingOpen(region.getRegionNameAsString())) {
                        return;
                    }
                    duplicateAssignment = true;
                }
            }
            if (duplicateAssignment) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("region server " + serverInfo.getServerAddress().toString() + " should not have opened region " + Bytes.toString(region.getRegionName())));
                }
                returnMsgs.add(new HMsg(HMsg.Type.MSG_REGION_CLOSE_WITHOUT_REPORT, region, "Duplicate assignment".getBytes()));
            } else if (region.isRootRegion()) {
                this.master.regionManager.removeRegion(region);
                rootServer = serverInfo.getServerAddress();
                if (this.master.regionManager.inSafeMode()) {
                    this.master.connection.setRootRegionLocation(new HRegionLocation(region, rootServer));
                }
                this.master.regionManager.setRootRegionLocation(rootServer);
            } else {
                this.master.regionManager.setOpen(region.getRegionNameAsString());
                boolean succeeded = false;
                for (int i = 0; i < 10; ++i) {
                    try {
                        this.master.toDoQueue.put(new ProcessRegionOpen(this.master, serverInfo, region));
                        succeeded = true;
                        break;
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)"Putting into toDoQueue was interrupted.", (Throwable)e);
                        continue;
                    }
                }
                if (!succeeded) {
                    LOG.warn((Object)("FAILED ADDING OPEN TO TODO QUEUE: " + serverInfo));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRegionClose(HRegionInfo region) {
        RegionManager regionManager = this.master.regionManager;
        synchronized (regionManager) {
            if (region.isRootRegion()) {
                this.master.regionManager.unsetRootRegion();
                if (region.isOffline()) {
                    LOG.fatal((Object)"root region is marked offline");
                    this.master.shutdown();
                    return;
                }
            } else if (region.isMetaTable()) {
                this.master.regionManager.offlineMetaRegion(region.getStartKey());
            }
            boolean offlineRegion = this.master.regionManager.isOfflined(region.getRegionNameAsString());
            boolean reassignRegion = !region.isOffline() && !offlineRegion;
            this.master.regionManager.setClosed(region.getRegionNameAsString());
            try {
                this.master.toDoQueue.put(new ProcessRegionClose(this.master, region, offlineRegion, reassignRegion));
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Putting into toDoQueue was interrupted.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeServerInfo(String serverName, HServerAddress serverAddress) {
        boolean infoUpdated = false;
        this.serverAddressToServerInfo.remove(serverAddress);
        HServerInfo info = this.serversToServerInfo.remove(serverName);
        if (info != null) {
            HRegionInfo metaServerRegionInfo;
            LOG.info((Object)("Removing server's info " + serverName));
            this.master.regionManager.offlineMetaServer(info.getServerAddress());
            if (this.master.regionManager.isRootServerCandidate(serverName)) {
                this.master.regionManager.unsetRootRegion();
                this.master.regionManager.reassignRootRegion();
            }
            if ((metaServerRegionInfo = this.master.regionManager.getMetaServerRegionInfo(serverName)) != null) {
                this.master.regionManager.setUnassigned(metaServerRegionInfo, true);
            }
            infoUpdated = true;
            HServerLoad load = this.serversToLoad.remove(serverName);
            if (load != null) {
                SortedMap<HServerLoad, Set<String>> sortedMap = this.loadToServers;
                synchronized (sortedMap) {
                    Set servers = (Set)this.loadToServers.get(load);
                    if (servers != null) {
                        servers.remove(serverName);
                        if (servers.size() > 0) {
                            this.loadToServers.put(load, servers);
                        } else {
                            this.loadToServers.remove(load);
                        }
                    }
                }
            }
        }
        return infoUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAverageLoad() {
        int totalLoad = 0;
        int numServers = 0;
        double averageLoad = 0.0;
        Map<String, HServerLoad> map = this.serversToLoad;
        synchronized (map) {
            numServers = this.serversToLoad.size();
            for (HServerLoad load : this.serversToLoad.values()) {
                totalLoad += load.getNumberOfRegions();
            }
            averageLoad = (double)totalLoad / (double)numServers;
        }
        return averageLoad;
    }

    public int numServers() {
        return this.serversToServerInfo.size();
    }

    public HServerInfo getServerInfo(String name) {
        return this.serversToServerInfo.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HServerInfo> getServersToServerInfo() {
        Map<String, HServerInfo> map = this.serversToServerInfo;
        synchronized (map) {
            return Collections.unmodifiableMap(this.serversToServerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<HServerAddress, HServerInfo> getServerAddressToServerInfo() {
        Map<String, HServerInfo> map = this.serversToServerInfo;
        synchronized (map) {
            return Collections.unmodifiableMap(this.serverAddressToServerInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HServerLoad> getServersToLoad() {
        Map<String, HServerLoad> map = this.serversToLoad;
        synchronized (map) {
            return Collections.unmodifiableMap(this.serversToLoad);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedMap<HServerLoad, Set<String>> getLoadToServers() {
        SortedMap<HServerLoad, Set<String>> sortedMap = this.loadToServers;
        synchronized (sortedMap) {
            return Collections.unmodifiableSortedMap(this.loadToServers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyServers() {
        Map<String, HServerInfo> map = this.serversToServerInfo;
        synchronized (map) {
            this.serversToServerInfo.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void letRegionServersShutdown() {
        if (!this.master.fsOk) {
            return;
        }
        Map<String, HServerInfo> map = this.serversToServerInfo;
        synchronized (map) {
            while (this.serversToServerInfo.size() > 0) {
                LOG.info((Object)("Waiting on following regionserver(s) to go down " + this.serversToServerInfo.values()));
                try {
                    this.serversToServerInfo.wait(this.master.threadWakeFrequency);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void removeDeadServer(String serverName) {
        this.deadServers.remove(serverName);
    }

    public boolean isDead(String serverName) {
        return this.deadServers.contains(serverName);
    }

    public boolean canAssignUserRegions() {
        if (this.minimumServerCount == 0) {
            return true;
        }
        return this.numServers() >= this.minimumServerCount;
    }

    public void setMinimumServerCount(int minimumServerCount) {
        this.minimumServerCount = minimumServerCount;
    }

    private class ServerExpirer
    implements Watcher {
        private String server;
        private HServerAddress serverAddress;

        ServerExpirer(String server, HServerAddress serverAddress) {
            this.server = server;
            this.serverAddress = serverAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted)) {
                LOG.info((Object)(this.server + " znode expired"));
                ServerManager.this.serverAddressToServerInfo.remove(this.serverAddress);
                HServerInfo info = ServerManager.this.serversToServerInfo.remove(this.server);
                if (info != null) {
                    String serverName = HServerInfo.getServerName(info);
                    HServerLoad load = ServerManager.this.serversToLoad.remove(serverName);
                    if (load != null) {
                        SortedMap<HServerLoad, Set<String>> sortedMap = ServerManager.this.loadToServers;
                        synchronized (sortedMap) {
                            Set servers = (Set)ServerManager.this.loadToServers.get(load);
                            if (servers != null) {
                                servers.remove(serverName);
                                if (servers.size() > 0) {
                                    ServerManager.this.loadToServers.put(load, servers);
                                } else {
                                    ServerManager.this.loadToServers.remove(load);
                                }
                            }
                        }
                    }
                    ServerManager.this.deadServers.add(this.server);
                    try {
                        ServerManager.this.master.toDoQueue.put(new ProcessServerShutdown(ServerManager.this.master, info));
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)"insert into toDoQueue was interrupted", (Throwable)e);
                    }
                }
                Map<String, HServerInfo> map = ServerManager.this.serversToServerInfo;
                synchronized (map) {
                    ServerManager.this.serversToServerInfo.notifyAll();
                }
            }
        }
    }

    class ServerMonitor
    extends Chore {
        ServerMonitor(int period, AtomicBoolean stop) {
            super(period, stop);
        }

        @Override
        protected void chore() {
            int numServers = ServerManager.this.serverAddressToServerInfo.size();
            int numDeadServers = ServerManager.this.deadServers.size();
            double averageLoad = ServerManager.this.getAverageLoad();
            String deadServersList = null;
            if (numDeadServers > 0) {
                StringBuilder sb = new StringBuilder("Dead Server [");
                boolean first = true;
                for (String server : ServerManager.this.deadServers) {
                    if (!first) {
                        sb.append(",  ");
                        first = false;
                    }
                    sb.append(server);
                }
                sb.append("]");
                deadServersList = sb.toString();
            }
            LOG.info((Object)(numServers + " region servers, " + numDeadServers + " dead, average load " + averageLoad + (deadServersList != null ? ServerManager.this.deadServers : "")));
        }
    }
}

