/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration.nineteen;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.ColumnNameParseException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class HStoreKey
implements WritableComparable<HStoreKey>,
HeapSize {
    public static final char COLUMN_FAMILY_DELIMITER = ':';
    private byte[] row = HConstants.EMPTY_BYTE_ARRAY;
    private byte[] column = HConstants.EMPTY_BYTE_ARRAY;
    private long timestamp = Long.MAX_VALUE;
    private HRegionInfo regionInfo = null;
    public static final int ESTIMATED_HEAP_TAX = 48;

    public HStoreKey() {
    }

    public HStoreKey(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public HStoreKey(String row) {
        this(row, Long.MAX_VALUE);
    }

    public HStoreKey(byte[] row, HRegionInfo hri) {
        this(row, HConstants.EMPTY_BYTE_ARRAY, hri);
    }

    public HStoreKey(byte[] row, long timestamp, HRegionInfo hri) {
        this(row, HConstants.EMPTY_BYTE_ARRAY, timestamp, hri);
    }

    public HStoreKey(byte[] row, long timestamp) {
        this(row, HConstants.EMPTY_BYTE_ARRAY, timestamp);
    }

    public HStoreKey(String row, long timestamp) {
        this(row, "", timestamp, new HRegionInfo());
    }

    public HStoreKey(String row, String column) {
        this(row, column, Long.MAX_VALUE, new HRegionInfo());
    }

    public HStoreKey(byte[] row, byte[] column) {
        this(row, column, Long.MAX_VALUE);
    }

    public HStoreKey(byte[] row, byte[] column, HRegionInfo regionInfo) {
        this(row, column, Long.MAX_VALUE, regionInfo);
    }

    public HStoreKey(String row, String column, long timestamp, HRegionInfo regionInfo) {
        this(Bytes.toBytes(row), Bytes.toBytes(column), timestamp, regionInfo);
    }

    public HStoreKey(byte[] row, byte[] column, long timestamp) {
        this(row, column, timestamp, null);
    }

    public HStoreKey(byte[] row, byte[] column, long timestamp, HRegionInfo regionInfo) {
        this.row = row;
        this.column = column;
        this.timestamp = timestamp;
        this.regionInfo = regionInfo;
    }

    public HStoreKey(HStoreKey other) {
        this(other.getRow(), other.getColumn(), other.getTimestamp(), other.getHRegionInfo());
    }

    public void setRow(byte[] newrow) {
        this.row = newrow;
    }

    public void setColumn(byte[] c) {
        this.column = c;
    }

    public void setVersion(long timestamp) {
        this.timestamp = timestamp;
    }

    public void set(HStoreKey k) {
        this.row = k.getRow();
        this.column = k.getColumn();
        this.timestamp = k.getTimestamp();
    }

    public byte[] getRow() {
        return this.row;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public HRegionInfo getHRegionInfo() {
        return this.regionInfo;
    }

    public void setHRegionInfo(HRegionInfo hri) {
        this.regionInfo = hri;
    }

    public boolean matchesRowCol(HStoreKey other) {
        return HStoreKey.equalsTwoRowKeys(this.getHRegionInfo(), this.getRow(), other.getRow()) && Bytes.equals(this.getColumn(), other.getColumn());
    }

    public boolean matchesWithoutColumn(HStoreKey other) {
        return HStoreKey.equalsTwoRowKeys(this.getHRegionInfo(), this.getRow(), other.getRow()) && this.getTimestamp() >= other.getTimestamp();
    }

    public boolean matchesRowFamily(HStoreKey that) {
        int delimiterIndex = HStoreKey.getFamilyDelimiterIndex(this.getColumn());
        return HStoreKey.equalsTwoRowKeys(this.getHRegionInfo(), this.getRow(), that.getRow()) && Bytes.compareTo(this.getColumn(), 0, delimiterIndex, that.getColumn(), 0, delimiterIndex) == 0;
    }

    public String toString() {
        return Bytes.toString(this.row) + "/" + Bytes.toString(this.column) + "/" + this.timestamp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HStoreKey)) {
            return false;
        }
        HStoreKey other = (HStoreKey)obj;
        if (this.row.length != other.row.length || this.column.length != other.column.length || this.timestamp != other.timestamp) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.getRow());
        result ^= Bytes.hashCode(this.getColumn());
        result = (int)((long)result ^ this.getTimestamp());
        return result;
    }

    public int compareTo(HStoreKey o) {
        return HStoreKey.compareTo(this.regionInfo, this, o);
    }

    static int compareTo(HRegionInfo hri, HStoreKey left, HStoreKey right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        int result = HStoreKey.compareTwoRowKeys(hri, left.getRow(), right.getRow());
        if (result != 0) {
            return result;
        }
        int n = left.getColumn() == null && right.getColumn() == null ? 0 : (left.getColumn() == null && right.getColumn() != null ? -1 : (result = left.getColumn() != null && right.getColumn() == null ? 1 : Bytes.compareTo(left.getColumn(), right.getColumn())));
        if (result != 0) {
            return result;
        }
        if (left.getTimestamp() < right.getTimestamp()) {
            result = 1;
        } else if (left.getTimestamp() > right.getTimestamp()) {
            result = -1;
        }
        return result == 0 && left instanceof BeforeThisStoreKey ? -1 : (result == 0 && right instanceof BeforeThisStoreKey ? 1 : result);
    }

    public static byte[] getFamily(byte[] column) throws ColumnNameParseException {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        if (index <= 0) {
            throw new ColumnNameParseException("Missing ':' delimiter between column family and qualifier in the passed column name <" + Bytes.toString(column) + ">");
        }
        byte[] result = new byte[index];
        System.arraycopy(column, 0, result, 0, index);
        return result;
    }

    public static Integer getFamilyMapKey(byte[] column) {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        return Bytes.mapKey(column, index > 0 ? index : column.length);
    }

    public static boolean matchingFamily(byte[] family, byte[] column) {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        if (index != family.length) {
            return false;
        }
        return Bytes.compareTo(family, 0, index, column, 0, index) == 0;
    }

    public static byte[] addDelimiter(byte[] family) {
        byte[] familyPlusDelimiter = new byte[family.length + 1];
        System.arraycopy(family, 0, familyPlusDelimiter, 0, family.length);
        familyPlusDelimiter[family.length] = 58;
        return familyPlusDelimiter;
    }

    public static byte[] getQualifier(byte[] column) {
        int index = HStoreKey.getFamilyDelimiterIndex(column);
        int len = column.length - (index + 1);
        byte[] result = new byte[len];
        System.arraycopy(column, index + 1, result, 0, len);
        return result;
    }

    public static byte[][] parseColumn(byte[] c) throws ColumnNameParseException {
        byte[][] result = new byte[2][];
        int index = HStoreKey.getFamilyDelimiterIndex(c);
        if (index == -1) {
            throw new ColumnNameParseException("Impossible column name: " + Bytes.toStringBinary(c));
        }
        result[0] = new byte[index];
        System.arraycopy(c, 0, result[0], 0, index);
        int len = c.length - (index + 1);
        result[1] = new byte[len];
        System.arraycopy(c, index + 1, result[1], 0, len);
        return result;
    }

    public static int getFamilyDelimiterIndex(byte[] b) {
        if (b == null) {
            throw new NullPointerException();
        }
        int result = -1;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 58) continue;
            result = i;
            break;
        }
        return result;
    }

    public static byte[] getBytes(HStoreKey hsk) {
        return Bytes.add(hsk.getRow(), hsk.getColumn());
    }

    public static int compareTwoRowKeys(HRegionInfo regionInfo, byte[] rowA, byte[] rowB) {
        if (regionInfo != null && regionInfo.isMetaRegion()) {
            byte[][] KeysB;
            byte[][] keysA = HStoreKey.stripStartKeyMeta(rowA);
            int rowCompare = Bytes.compareTo(keysA[0], (KeysB = HStoreKey.stripStartKeyMeta(rowB))[0]);
            if (rowCompare == 0) {
                rowCompare = Bytes.compareTo(keysA[1], KeysB[1]);
            }
            return rowCompare;
        }
        return Bytes.compareTo(rowA, rowB);
    }

    public static boolean equalsTwoRowKeys(HRegionInfo regionInfo, byte[] rowA, byte[] rowB) {
        return rowA == null && rowB == null ? true : (rowA == null || rowB == null || rowA.length != rowB.length ? false : HStoreKey.compareTwoRowKeys(regionInfo, rowA, rowB) == 0);
    }

    private static byte[][] stripStartKeyMeta(byte[] rowKey) {
        int offset = -1;
        for (int i = rowKey.length - 1; i > 0; --i) {
            if (rowKey[i] != 44) continue;
            offset = i;
            break;
        }
        byte[] row = rowKey;
        byte[] timestamp = HConstants.EMPTY_BYTE_ARRAY;
        if (offset != -1) {
            row = new byte[offset];
            System.arraycopy(rowKey, 0, row, 0, offset);
            timestamp = new byte[rowKey.length - offset - 1];
            System.arraycopy(rowKey, offset + 1, timestamp, 0, rowKey.length - offset - 1);
        }
        byte[][] elements = new byte[][]{row, timestamp};
        return elements;
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.row);
        Bytes.writeByteArray(out, this.column);
        out.writeLong(this.timestamp);
    }

    public void readFields(DataInput in) throws IOException {
        this.row = Bytes.readByteArray(in);
        this.column = Bytes.readByteArray(in);
        this.timestamp = in.readLong();
    }

    @Override
    public long heapSize() {
        return this.getRow().length + 16 + this.getColumn().length + 16 + 48;
    }

    public static class BeforeThisStoreKey
    extends HStoreKey {
        private final HStoreKey beforeThisKey;

        public BeforeThisStoreKey(HStoreKey beforeThisKey) {
            this.beforeThisKey = beforeThisKey;
        }

        @Override
        public int compareTo(HStoreKey o) {
            int result = this.beforeThisKey.compareTo(o);
            return result == 0 ? -1 : result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HStoreKey)) {
                return false;
            }
            return this.compareTo((HStoreKey)obj) == 0;
        }

        @Override
        public byte[] getColumn() {
            return this.beforeThisKey.getColumn();
        }

        @Override
        public byte[] getRow() {
            return this.beforeThisKey.getRow();
        }

        @Override
        public long heapSize() {
            return this.beforeThisKey.heapSize();
        }

        @Override
        public long getTimestamp() {
            return this.beforeThisKey.getTimestamp();
        }

        @Override
        public int hashCode() {
            return this.beforeThisKey.hashCode();
        }

        @Override
        public boolean matchesRowCol(HStoreKey other) {
            return this.beforeThisKey.matchesRowCol(other);
        }

        @Override
        public boolean matchesRowFamily(HStoreKey that) {
            return this.beforeThisKey.matchesRowFamily(that);
        }

        @Override
        public boolean matchesWithoutColumn(HStoreKey other) {
            return this.beforeThisKey.matchesWithoutColumn(other);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.beforeThisKey.readFields(in);
        }

        @Override
        public void set(HStoreKey k) {
            this.beforeThisKey.set(k);
        }

        @Override
        public void setColumn(byte[] c) {
            this.beforeThisKey.setColumn(c);
        }

        @Override
        public void setRow(byte[] newrow) {
            this.beforeThisKey.setRow(newrow);
        }

        @Override
        public void setVersion(long timestamp) {
            this.beforeThisKey.setVersion(timestamp);
        }

        @Override
        public String toString() {
            return this.beforeThisKey.toString();
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.beforeThisKey.write(out);
        }

        @Override
        public HRegionInfo getHRegionInfo() {
            return this.beforeThisKey.getHRegionInfo();
        }

        @Override
        public void setHRegionInfo(HRegionInfo hri) {
            this.beforeThisKey.setHRegionInfo(hri);
        }
    }

    public static class HStoreKeyWritableComparator
    extends WritableComparator {
        private final HRegionInfo hri;

        public HStoreKeyWritableComparator(HRegionInfo hri) {
            super(HStoreKey.class);
            this.hri = hri;
        }

        public int compare(WritableComparable left, WritableComparable right) {
            return HStoreKey.compareTo(this.hri, (HStoreKey)left, (HStoreKey)right);
        }
    }
}

