/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.migration.nineteen.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.migration.nineteen.HStoreKey;
import org.apache.hadoop.io.Writable;

public class Reference
implements Writable {
    private int encodedRegionName;
    private long fileid;
    private Range region;
    private HStoreKey midkey;

    public Reference(int ern, long fid, HStoreKey m, Range fr) {
        this.encodedRegionName = ern;
        this.fileid = fid;
        this.region = fr;
        this.midkey = m;
    }

    public Reference() {
        this(-1, -1L, null, Range.bottom);
    }

    public long getFileId() {
        return this.fileid;
    }

    public Range getFileRegion() {
        return this.region;
    }

    public HStoreKey getMidkey() {
        return this.midkey;
    }

    public int getEncodedRegionName() {
        return this.encodedRegionName;
    }

    public String toString() {
        return this.encodedRegionName + "/" + this.fileid + "/" + (Object)((Object)this.region);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(Integer.toString(this.encodedRegionName));
        out.writeLong(this.fileid);
        out.writeBoolean(Reference.isTopFileRegion(this.region));
        this.midkey.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.encodedRegionName = Integer.parseInt(in.readUTF());
        this.fileid = in.readLong();
        boolean tmp = in.readBoolean();
        this.region = tmp ? Range.top : Range.bottom;
        this.midkey = new HStoreKey();
        this.midkey.readFields(in);
    }

    public static boolean isTopFileRegion(Range r) {
        return r.equals((Object)Range.top);
    }

    public static enum Range {
        top,
        bottom;

    }
}

