/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.regionserver.ColumnCount;
import org.apache.hadoop.hbase.regionserver.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.QueryMatcher;
import org.apache.hadoop.hbase.util.Bytes;

public class ExplicitColumnTracker
implements ColumnTracker {
    private int maxVersions;
    private List<ColumnCount> columns;
    private int index;
    private ColumnCount column;
    private NavigableSet<byte[]> origColumns;

    public ExplicitColumnTracker(NavigableSet<byte[]> columns, int maxVersions) {
        this.maxVersions = maxVersions;
        this.origColumns = columns;
        this.reset();
    }

    @Override
    public boolean done() {
        return this.columns.size() == 0;
    }

    @Override
    public ColumnCount getColumnHint() {
        return this.column;
    }

    @Override
    public QueryMatcher.MatchCode checkColumn(byte[] bytes, int offset, int length) {
        if (this.columns.size() == 0) {
            return QueryMatcher.MatchCode.DONE;
        }
        if (this.column == null) {
            return QueryMatcher.MatchCode.NEXT;
        }
        int ret = Bytes.compareTo(this.column.getBuffer(), this.column.getOffset(), this.column.getLength(), bytes, offset, length);
        if (ret == 0) {
            if (this.column.decrement() == 0) {
                this.columns.remove(this.index);
                this.column = this.columns.size() == this.index ? null : this.columns.get(this.index);
            }
            return QueryMatcher.MatchCode.INCLUDE;
        }
        if (ret <= -1) {
            if (++this.index == this.columns.size()) {
                return QueryMatcher.MatchCode.NEXT;
            }
            this.column = this.columns.get(this.index);
            return this.checkColumn(bytes, offset, length);
        }
        return QueryMatcher.MatchCode.SKIP;
    }

    @Override
    public void update() {
        if (this.columns.size() != 0) {
            this.index = 0;
            this.column = this.columns.get(this.index);
        } else {
            this.index = -1;
            this.column = null;
        }
    }

    @Override
    public void reset() {
        this.buildColumnList(this.origColumns);
        this.index = 0;
        this.column = this.columns.get(this.index);
    }

    private void buildColumnList(NavigableSet<byte[]> columns) {
        this.columns = new ArrayList<ColumnCount>(columns.size());
        for (byte[] column : columns) {
            this.columns.add(new ColumnCount(column, this.maxVersions));
        }
    }
}

