/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanDeleteTracker;
import org.apache.hadoop.hbase.regionserver.Store;

public class MinorCompactingStoreScanner
implements KeyValueScanner,
InternalScanner {
    private KeyValueHeap heap;
    private ScanDeleteTracker deleteTracker;
    private KeyValue.KVComparator comparator;

    MinorCompactingStoreScanner(Store store, KeyValueScanner[] scanners) {
        this.comparator = store.comparator;
        this.deleteTracker = new ScanDeleteTracker();
        KeyValue firstKv = KeyValue.createFirstOnRow(HConstants.EMPTY_START_ROW);
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(firstKv);
        }
        this.heap = new KeyValueHeap(scanners, store.comparator);
    }

    MinorCompactingStoreScanner(String cfName, KeyValue.KVComparator comparator, KeyValueScanner[] scanners) {
        this.comparator = comparator;
        this.deleteTracker = new ScanDeleteTracker();
        KeyValue firstKv = KeyValue.createFirstOnRow(HConstants.EMPTY_START_ROW);
        for (KeyValueScanner scanner : scanners) {
            scanner.seek(firstKv);
        }
        this.heap = new KeyValueHeap(scanners, comparator);
    }

    @Override
    public KeyValue peek() {
        return this.heap.peek();
    }

    @Override
    public KeyValue next() {
        return this.heap.next();
    }

    @Override
    public boolean seek(KeyValue key) {
        throw new UnsupportedOperationException("Can't seek a MinorCompactingStoreScanner");
    }

    public boolean next(HFile.Writer writer) throws IOException {
        KeyValue kv;
        KeyValue row = this.heap.peek();
        if (row == null) {
            this.close();
            return false;
        }
        this.deleteTracker.reset();
        while ((kv = this.heap.peek()) != null) {
            if (this.comparator.compareRows(row, kv) != 0) {
                return true;
            }
            if (kv.getType() != KeyValue.Type.Put.getCode()) {
                this.deleteTracker.add(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), kv.getType());
                writer.append(this.heap.next());
                continue;
            }
            if (this.deleteTracker.isDeleted(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp())) {
                this.heap.next();
                continue;
            }
            writer.append(this.heap.next());
        }
        this.close();
        return false;
    }

    @Override
    public boolean next(List<KeyValue> results) throws IOException {
        KeyValue kv;
        KeyValue row = this.heap.peek();
        if (row == null) {
            this.close();
            return false;
        }
        this.deleteTracker.reset();
        while ((kv = this.heap.peek()) != null) {
            if (this.comparator.compareRows(row, kv) != 0) {
                return true;
            }
            if (kv.getType() != KeyValue.Type.Put.getCode()) {
                this.deleteTracker.add(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp(), kv.getType());
                results.add(this.heap.next());
                continue;
            }
            if (this.deleteTracker.isDeleted(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getTimestamp())) {
                this.heap.next();
                continue;
            }
            results.add(this.heap.next());
        }
        this.close();
        return false;
    }

    @Override
    public void close() {
        this.heap.close();
    }
}

