/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.util.HashMap;
import org.apache.hadoop.hbase.rest.filter.ColumnValueFilterFactory;
import org.apache.hadoop.hbase.rest.filter.FilterFactory;
import org.apache.hadoop.hbase.rest.filter.InclusiveStopRowFilterFactory;
import org.apache.hadoop.hbase.rest.filter.PageRowFilterFactory;
import org.apache.hadoop.hbase.rest.filter.RegExpRowFilterFactory;
import org.apache.hadoop.hbase.rest.filter.RowFilterSetFactory;
import org.apache.hadoop.hbase.rest.filter.StopRowFilterFactory;
import org.apache.hadoop.hbase.rest.filter.WhileMatchRowFilterFactory;

public interface RESTConstants {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String EXISTS = "exists";
    public static final String TRANSACTION = "transaction";
    public static final String TRANSACTION_OPERATION = "transaction_op";
    public static final String TRANSACTION_OPERATION_COMMIT = "commit";
    public static final String TRANSACTION_OPERATION_CREATE = "create";
    public static final String TRANSACTION_OPERATION_ABORT = "abort";
    public static final String FILTER = "filter";
    public static final String FILTER_TYPE = "type";
    public static final String FILTER_VALUE = "value";
    public static final String FILTER_RANK = "rank";
    public static final String SCANNER = "scanner";
    public static final String SCANNER_RESULT_SIZE = "result_size";
    public static final String SCANNER_START_ROW = "start_row";
    public static final String SCANNER_STOP_ROW = "stop_row";
    public static final String SCANNER_FILTER = "filter";
    public static final String SCANNER_TIMESTAMP = "timestamp";
    public static final String NUM_VERSIONS = "num_versions";
    public static final String SCANNER_COLUMN = "column";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String REGIONS = "regions";
    public static final String ROW = "row";
    public static final String TIME_STAMPS = "timestamps";
    public static final String METADATA = "metadata";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String ROWS = "rows";
    public static final FactoryMap filterFactories = FactoryMap.getFactoryMap();
    public static final String LIMIT = "limit";

    public static class FactoryMap {
        static boolean created = false;
        protected HashMap<String, FilterFactory> map = new HashMap();

        protected FactoryMap() {
        }

        public static FactoryMap getFactoryMap() {
            if (!created) {
                created = true;
                FactoryMap f = new FactoryMap();
                f.initialize();
                return f;
            }
            return null;
        }

        public FilterFactory get(String c) {
            return this.map.get(c);
        }

        protected void initialize() {
            this.map.put("ColumnValueFilter", new ColumnValueFilterFactory());
            this.map.put("InclusiveStopRowFilter", new InclusiveStopRowFilterFactory());
            this.map.put("PageRowFilter", new PageRowFilterFactory());
            this.map.put("RegExpRowFilter", new RegExpRowFilterFactory());
            this.map.put("RowFilterSet", new RowFilterSetFactory());
            this.map.put("StopRowFilter", new StopRowFilterFactory());
            this.map.put("WhileMatchRowFilter", new WhileMatchRowFilterFactory());
        }
    }
}

