/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.filter.RowFilterSet;
import org.apache.hadoop.hbase.filter.StopRowFilter;
import org.apache.hadoop.hbase.filter.WhileMatchRowFilter;
import org.apache.hadoop.hbase.rest.AbstractController;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.RESTConstants;
import org.apache.hadoop.hbase.rest.ScannerModel;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.descriptors.ScannerDescriptor;
import org.apache.hadoop.hbase.rest.descriptors.ScannerIdentifier;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.filter.FilterFactory;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.util.Bytes;

public class ScannerController
extends AbstractController {
    @Override
    public void delete(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        ScannerModel innerModel = this.getModel();
        if (pathSegments.length == 3 && Bytes.toString(pathSegments[1]).toLowerCase().equals("scanner")) {
            Integer scannerId = null;
            String scannerIdString = new String(pathSegments[2]);
            if (!Pattern.matches("^\\d+$", scannerIdString)) {
                throw new HBaseRestException("the scannerid in the path and must be an integer");
            }
            scannerId = Integer.parseInt(scannerIdString);
            try {
                innerModel.scannerClose(scannerId);
                s.setOK();
            }
            catch (HBaseRestException e) {
                s.setNotFound();
            }
        } else {
            s.setBadRequest("invalid query");
        }
        s.respond();
    }

    @Override
    protected AbstractModel generateModel(HBaseConfiguration conf, HBaseAdmin a) {
        return new ScannerModel(conf, a);
    }

    protected ScannerModel getModel() {
        return (ScannerModel)this.model;
    }

    @Override
    public void get(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        s.setBadRequest("invalid query");
        s.respond();
    }

    @Override
    public void post(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        ScannerModel innerModel = this.getModel();
        byte[] tableName = pathSegments[0];
        if (pathSegments.length == 2 && Bytes.toString(pathSegments[1]).toLowerCase().equals("scanner")) {
            ScannerDescriptor sd = this.getScannerDescriptor(queryMap);
            s.setScannerCreated(this.createScanner(innerModel, tableName, sd));
        } else if (pathSegments.length == 3 && Bytes.toString(pathSegments[1]).toLowerCase().equals("scanner")) {
            Long numRows = 1L;
            String[] numRowsString = queryMap.get("limit");
            if (numRowsString != null && Pattern.matches("^\\d+$", numRowsString[0])) {
                numRows = Long.parseLong(numRowsString[0]);
            }
            Integer scannerId = null;
            String scannerIdString = new String(pathSegments[2]);
            if (!Pattern.matches("^\\d+$", scannerIdString)) {
                throw new HBaseRestException("the scannerid in the path and must be an integer");
            }
            scannerId = Integer.parseInt(scannerIdString);
            try {
                s.setOK(innerModel.scannerGet(scannerId, numRows));
            }
            catch (HBaseRestException e) {
                s.setNotFound();
            }
        } else {
            s.setBadRequest("Unknown Query.");
        }
        s.respond();
    }

    @Override
    public void put(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        s.setBadRequest("invalid query");
        s.respond();
    }

    private ScannerDescriptor getScannerDescriptor(Map<String, String[]> queryMap) {
        String[] filtersStrings;
        String[] stopRowString;
        String[] startRowString;
        long timestamp = 0L;
        byte[] startRow = null;
        byte[] stopRow = null;
        String filters = null;
        String[] timeStampString = queryMap.get("timestamp");
        if (timeStampString != null && timeStampString.length == 1) {
            timestamp = Long.parseLong(timeStampString[0]);
        }
        if ((startRowString = queryMap.get("start_row")) != null && startRowString.length == 1) {
            startRow = Bytes.toBytes(startRowString[0]);
        }
        if ((stopRowString = queryMap.get("stop_row")) != null && stopRowString.length == 1) {
            stopRow = Bytes.toBytes(stopRowString[0]);
        }
        if ((filtersStrings = queryMap.get("filter")) != null && filtersStrings.length > 0) {
            filters = "";
            for (String filter : filtersStrings) {
            }
        }
        return new ScannerDescriptor(this.getColumnsFromQueryMap(queryMap), timestamp, startRow, stopRow, filters);
    }

    protected ScannerIdentifier createScanner(ScannerModel innerModel, byte[] tableName, ScannerDescriptor scannerDescriptor) throws HBaseRestException {
        RowFilterInterface filterSet = null;
        int switchInt = 0;
        if (scannerDescriptor.getColumns() != null && scannerDescriptor.getColumns().length > 0) {
            ++switchInt;
        }
        switchInt += scannerDescriptor.getTimestamp() != 0L ? 2 : 0;
        switchInt += scannerDescriptor.getStartRow().length > 0 ? 4 : 0;
        switchInt += scannerDescriptor.getStopRow().length > 0 ? 8 : 0;
        if (scannerDescriptor.getFilters() != null && !scannerDescriptor.getFilters().equals("")) {
            switchInt += scannerDescriptor.getFilters() != null ? 16 : 0;
            filterSet = this.unionFilters(scannerDescriptor.getFilters());
        }
        return this.scannerSwitch(switchInt, innerModel, tableName, scannerDescriptor.getColumns(), scannerDescriptor.getTimestamp(), scannerDescriptor.getStartRow(), scannerDescriptor.getStopRow(), filterSet);
    }

    public ScannerIdentifier scannerSwitch(int switchInt, ScannerModel innerModel, byte[] tableName, byte[][] columns, long timestamp, byte[] startRow, byte[] stopRow, RowFilterInterface filterSet) throws HBaseRestException {
        switch (switchInt) {
            case 0: {
                return innerModel.scannerOpen(tableName);
            }
            case 1: {
                return innerModel.scannerOpen(tableName, columns);
            }
            case 2: {
                return innerModel.scannerOpen(tableName, timestamp);
            }
            case 3: {
                return innerModel.scannerOpen(tableName, columns, timestamp);
            }
            case 4: {
                return innerModel.scannerOpen(tableName, startRow);
            }
            case 5: {
                return innerModel.scannerOpen(tableName, columns, startRow);
            }
            case 6: {
                return innerModel.scannerOpen(tableName, startRow, timestamp);
            }
            case 7: {
                return innerModel.scannerOpen(tableName, columns, startRow, timestamp);
            }
            case 8: {
                return innerModel.scannerOpen(tableName, this.getStopRow(stopRow));
            }
            case 9: {
                return innerModel.scannerOpen(tableName, columns, this.getStopRow(stopRow));
            }
            case 10: {
                return innerModel.scannerOpen(tableName, timestamp, this.getStopRow(stopRow));
            }
            case 11: {
                return innerModel.scannerOpen(tableName, columns, timestamp, this.getStopRow(stopRow));
            }
            case 12: {
                return innerModel.scannerOpen(tableName, startRow, this.getStopRow(stopRow));
            }
            case 13: {
                return innerModel.scannerOpen(tableName, columns, startRow, this.getStopRow(stopRow));
            }
            case 14: {
                return innerModel.scannerOpen(tableName, startRow, timestamp, this.getStopRow(stopRow));
            }
            case 15: {
                return innerModel.scannerOpen(tableName, columns, startRow, timestamp, this.getStopRow(stopRow));
            }
            case 16: {
                return innerModel.scannerOpen(tableName, filterSet);
            }
            case 17: {
                return innerModel.scannerOpen(tableName, columns, filterSet);
            }
            case 18: {
                return innerModel.scannerOpen(tableName, timestamp, filterSet);
            }
            case 19: {
                return innerModel.scannerOpen(tableName, columns, timestamp, filterSet);
            }
            case 20: {
                return innerModel.scannerOpen(tableName, startRow, filterSet);
            }
            case 21: {
                return innerModel.scannerOpen(tableName, columns, startRow, filterSet);
            }
            case 22: {
                return innerModel.scannerOpen(tableName, startRow, timestamp, filterSet);
            }
            case 23: {
                return innerModel.scannerOpen(tableName, columns, startRow, timestamp, filterSet);
            }
            case 24: {
                return innerModel.scannerOpen(tableName, this.getStopRowUnionFilter(stopRow, filterSet));
            }
            case 25: {
                return innerModel.scannerOpen(tableName, columns, this.getStopRowUnionFilter(stopRow, filterSet));
            }
            case 26: {
                return innerModel.scannerOpen(tableName, timestamp, this.getStopRowUnionFilter(stopRow, filterSet));
            }
            case 27: {
                return innerModel.scannerOpen(tableName, columns, timestamp, this.getStopRowUnionFilter(stopRow, filterSet));
            }
            case 28: {
                return innerModel.scannerOpen(tableName, startRow, this.getStopRowUnionFilter(stopRow, filterSet));
            }
            case 29: {
                return innerModel.scannerOpen(tableName, columns, startRow, this.getStopRowUnionFilter(stopRow, filterSet));
            }
            case 30: {
                return innerModel.scannerOpen(tableName, startRow, timestamp, this.getStopRowUnionFilter(stopRow, filterSet));
            }
            case 31: {
                return innerModel.scannerOpen(tableName, columns, startRow, timestamp, this.getStopRowUnionFilter(stopRow, filterSet));
            }
        }
        return null;
    }

    protected RowFilterInterface getStopRow(byte[] stopRow) {
        return new WhileMatchRowFilter(new StopRowFilter(stopRow));
    }

    protected RowFilterInterface getStopRowUnionFilter(byte[] stopRow, RowFilterInterface filter) {
        HashSet<RowFilterInterface> filterSet = new HashSet<RowFilterInterface>();
        filterSet.add(this.getStopRow(stopRow));
        filterSet.add(filter);
        return new RowFilterSet(filterSet);
    }

    protected RowFilterInterface unionFilters(String filters) throws HBaseRestException {
        FilterFactory f = RESTConstants.filterFactories.get("RowFilterSet");
        return f.getFilterFromJSON(filters);
    }
}

