/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.rest.AbstractController;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.TimestampModel;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.util.Bytes;

public class TimestampController
extends AbstractController {
    private Log LOG = LogFactory.getLog(TimestampController.class);

    protected TimestampModel getModel() {
        return (TimestampModel)this.model;
    }

    @Override
    protected AbstractModel generateModel(HBaseConfiguration conf, HBaseAdmin admin) {
        return new TimestampModel(conf, admin);
    }

    @Override
    public void get(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        TimestampModel innerModel = this.getModel();
        byte[] tableName = pathSegments[0];
        byte[] rowName = pathSegments[2];
        long timestamp = Bytes.toLong(pathSegments[3]);
        if (queryMap.size() == 0) {
            s.setOK(innerModel.get(tableName, rowName, timestamp));
        } else {
            String[] column_params = queryMap.get("column");
            byte[][] columns = null;
            if (column_params != null && column_params.length > 0) {
                ArrayList<String> available_columns = new ArrayList<String>();
                for (String column_param : column_params) {
                    available_columns.add(column_param);
                }
                columns = Bytes.toByteArrays(available_columns.toArray(new String[0]));
            }
            s.setOK(innerModel.get(tableName, rowName, columns, timestamp));
        }
        s.respond();
    }

    @Override
    public void post(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        TimestampModel innerModel = this.getModel();
        byte[] tableName = pathSegments[0];
        byte[] rowName = pathSegments[1];
        byte[] columnName = pathSegments[2];
        long timestamp = Bytes.toLong(pathSegments[3]);
        try {
            if (queryMap.size() == 0) {
                innerModel.post(tableName, rowName, columnName, timestamp, input);
                s.setOK();
            } else {
                s.setUnsupportedMediaType("Unknown Query.");
            }
        }
        catch (HBaseRestException e) {
            s.setUnsupportedMediaType(e.getMessage());
        }
        s.respond();
    }

    @Override
    public void put(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void delete(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        TimestampModel innerModel = this.getModel();
        byte[] tableName = pathSegments[0];
        byte[] rowName = pathSegments[2];
        long timestamp = Bytes.toLong(pathSegments[3]);
        if (queryMap.size() == 0) {
            innerModel.delete(tableName, rowName, timestamp);
        } else {
            innerModel.delete(tableName, rowName, this.getColumnsFromQueryMap(queryMap), timestamp);
        }
        s.setAccepted();
        s.respond();
    }
}

