/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.filter;

import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.filter.WhileMatchRowFilter;
import org.apache.hadoop.hbase.rest.RESTConstants;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.filter.FilterFactory;
import org.apache.hadoop.hbase.rest.filter.FilterFactoryConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class WhileMatchRowFilterFactory
implements FilterFactory {
    @Override
    public RowFilterInterface getFilterFromJSON(String args) throws HBaseRestException {
        JSONObject innerFilterJSON;
        try {
            innerFilterJSON = new JSONObject(args);
        }
        catch (JSONException e) {
            throw new HBaseRestException((Exception)((Object)e));
        }
        String innerFilterType = innerFilterJSON.optString("type");
        if (innerFilterType == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        String innerFilterArgs = innerFilterJSON.optString("args");
        if (innerFilterArgs == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        FilterFactory f = RESTConstants.filterFactories.get(innerFilterType);
        if (f == null) {
            throw new FilterFactoryConstants.MalformedFilterException();
        }
        RowFilterInterface innerFilter = f.getFilterFromJSON(innerFilterArgs);
        return new WhileMatchRowFilter(innerFilter);
    }
}

