/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.parser;

import java.util.ArrayList;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.rest.descriptors.RowUpdateDescriptor;
import org.apache.hadoop.hbase.rest.descriptors.ScannerDescriptor;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonRestParser
implements IHBaseRestParser {
    @Override
    public HTableDescriptor getTableDescriptor(byte[] input) throws HBaseRestException {
        try {
            JSONObject o = new JSONObject(new String(input));
            JSONArray columnDescriptorArray = o.getJSONArray("column_families");
            HTableDescriptor h = new HTableDescriptor(o.getString("name"));
            for (int i = 0; i < columnDescriptorArray.length(); ++i) {
                JSONObject json_columnDescriptor = columnDescriptorArray.getJSONObject(i);
                h.addFamily(this.getColumnDescriptor(json_columnDescriptor));
            }
            return h;
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
    }

    private HColumnDescriptor getColumnDescriptor(JSONObject jsonObject) throws JSONException {
        int timeToLive;
        int maxValueLength;
        boolean blockCacheEnabled;
        boolean inMemory;
        String cType;
        int maxVersions;
        boolean bloomfilter;
        String strTemp = jsonObject.getString("name");
        if (strTemp.charAt(strTemp.length() - 1) != ':') {
            strTemp = strTemp + ":";
        }
        byte[] name = Bytes.toBytes(strTemp);
        try {
            bloomfilter = jsonObject.getBoolean("bloomfilter");
        }
        catch (JSONException e) {
            bloomfilter = false;
        }
        try {
            maxVersions = jsonObject.getInt("max_versions");
        }
        catch (JSONException e) {
            maxVersions = 3;
        }
        try {
            cType = jsonObject.getString("compression_type").toUpperCase();
        }
        catch (JSONException e) {
            cType = HColumnDescriptor.DEFAULT_COMPRESSION;
        }
        try {
            inMemory = jsonObject.getBoolean("in_memory");
        }
        catch (JSONException e) {
            inMemory = false;
        }
        try {
            blockCacheEnabled = jsonObject.getBoolean("block_cache_enabled");
        }
        catch (JSONException e) {
            blockCacheEnabled = false;
        }
        try {
            maxValueLength = jsonObject.getInt("max_value_length");
        }
        catch (JSONException e) {
            maxValueLength = Integer.MAX_VALUE;
        }
        try {
            timeToLive = jsonObject.getInt("time_to_live");
        }
        catch (JSONException e) {
            timeToLive = Integer.MAX_VALUE;
        }
        return new HColumnDescriptor(name, maxVersions, cType, inMemory, blockCacheEnabled, maxValueLength, timeToLive, bloomfilter);
    }

    @Override
    public ArrayList<HColumnDescriptor> getColumnDescriptors(byte[] input) throws HBaseRestException {
        ArrayList<HColumnDescriptor> columns = new ArrayList<HColumnDescriptor>();
        try {
            JSONObject o = new JSONObject(new String(input));
            JSONArray columnDescriptorArray = o.getJSONArray("column_families");
            for (int i = 0; i < columnDescriptorArray.length(); ++i) {
                JSONObject json_columnDescriptor = columnDescriptorArray.getJSONObject(i);
                columns.add(this.getColumnDescriptor(json_columnDescriptor));
            }
        }
        catch (JSONException e) {
            throw new HBaseRestException("Error Parsing json input", (Exception)((Object)e));
        }
        return columns;
    }

    @Override
    public ScannerDescriptor getScannerDescriptor(byte[] input) throws HBaseRestException {
        Object columns = null;
        try {
            JSONObject scannerDescriptor = new JSONObject(new String(input));
            JSONArray columnArray = scannerDescriptor.optJSONArray("columns");
            long timestamp = scannerDescriptor.optLong("timestamp");
            byte[] startRow = Bytes.toBytes(scannerDescriptor.optString("start_row", ""));
            byte[] stopRow = Bytes.toBytes(scannerDescriptor.optString("stop_row", ""));
            String filters = scannerDescriptor.optString("filter");
            if (columnArray != null) {
                columns = new byte[columnArray.length()][];
                for (int i = 0; i < columnArray.length(); ++i) {
                    columns[i] = Bytes.toBytes(columnArray.optString(i));
                }
            }
            return new ScannerDescriptor((byte[][])columns, timestamp, startRow, stopRow, filters);
        }
        catch (JSONException e) {
            throw new HBaseRestException("error parsing json string", (Exception)((Object)e));
        }
    }

    @Override
    public RowUpdateDescriptor getRowUpdateDescriptor(byte[] input, byte[][] pathSegments) throws HBaseRestException {
        RowUpdateDescriptor rud = new RowUpdateDescriptor();
        rud.setTableName(Bytes.toString(pathSegments[0]));
        rud.setRowName(Bytes.toString(pathSegments[2]));
        try {
            JSONObject updateObject = new JSONObject(new String(input));
            JSONArray a = updateObject.getJSONArray("columns");
            for (int i = 0; i < a.length(); ++i) {
                rud.getColVals().put(Bytes.toBytes(a.getJSONObject(i).getString("name")), Base64.decode(a.getJSONObject(i).getString("value")));
            }
        }
        catch (JSONException e) {
            throw new HBaseRestException("Error parsing row update json", (Exception)((Object)e));
        }
        return rud;
    }
}

