/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.serializer;

import agilejson.JSON;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.rest.DatabaseModel;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.TableModel;
import org.apache.hadoop.hbase.rest.descriptors.ScannerIdentifier;
import org.apache.hadoop.hbase.rest.descriptors.TimestampsDescriptor;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.serializer.AbstractRestSerializer;

public class JSONSerializer
extends AbstractRestSerializer {
    public JSONSerializer(HttpServletResponse response) {
        super(response, false);
    }

    @Override
    public void writeOutput(Object o) throws HBaseRestException {
        this.response.setContentType("application/json");
        try {
            String data = JSON.toJSON((Object)o);
            this.response.setContentLength(data.length());
            this.response.getWriter().println(data);
        }
        catch (Exception e) {
            throw new HBaseRestException(e);
        }
    }

    @Override
    public void serializeColumnDescriptor(HColumnDescriptor column) throws HBaseRestException {
    }

    @Override
    public void serializeDatabaseMetadata(DatabaseModel.DatabaseMetadata databaseMetadata) throws HBaseRestException {
    }

    @Override
    public void serializeRegionData(TableModel.Regions regions) throws HBaseRestException {
    }

    @Override
    public void serializeTableDescriptor(HTableDescriptor tableDescriptor) throws HBaseRestException {
    }

    @Override
    public void serializeStatusMessage(Status.StatusMessage message) throws HBaseRestException {
    }

    @Override
    public void serializeScannerIdentifier(ScannerIdentifier scannerIdentifier) throws HBaseRestException {
    }

    @Override
    public void serializeRowResult(RowResult rowResult) throws HBaseRestException {
    }

    @Override
    public void serializeRowResultArray(RowResult[] rows) throws HBaseRestException {
    }

    @Override
    public void serializeCell(Cell cell) throws HBaseRestException {
    }

    @Override
    public void serializeCellArray(Cell[] cells) throws HBaseRestException {
    }

    @Override
    public void serializeTimestamps(TimestampsDescriptor timestampsDescriptor) throws HBaseRestException {
    }
}

