/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift.generated;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class TCell
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("TCell");
    private static final TField VALUE_FIELD_DESC = new TField("value", 11, 1);
    private static final TField TIMESTAMP_FIELD_DESC = new TField("timestamp", 10, 2);
    public byte[] value;
    public static final int VALUE = 1;
    public long timestamp;
    public static final int TIMESTAMP = 2;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("value", 3, new FieldValueMetaData(11)));
            this.put(2, new FieldMetaData("timestamp", 3, new FieldValueMetaData(10)));
        }
    });

    public TCell() {
    }

    public TCell(byte[] value, long timestamp) {
        this();
        this.value = value;
        this.timestamp = timestamp;
        this.__isset.timestamp = true;
    }

    public TCell(TCell other) {
        if (other.isSetValue()) {
            this.value = other.value;
        }
        this.__isset.timestamp = other.__isset.timestamp;
        this.timestamp = other.timestamp;
    }

    public TCell clone() {
        return new TCell(this);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void unsetValue() {
        this.value = null;
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValueIsSet(boolean value) {
        if (!value) {
            this.value = null;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.__isset.timestamp = true;
    }

    public void unsetTimestamp() {
        this.__isset.timestamp = false;
    }

    public boolean isSetTimestamp() {
        return this.__isset.timestamp;
    }

    public void setTimestampIsSet(boolean value) {
        this.__isset.timestamp = value;
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetValue();
                    break;
                }
                this.setValue((byte[])value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetTimestamp();
                    break;
                }
                this.setTimestamp((Long)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getValue();
            }
            case 2: {
                return new Long(this.getTimestamp());
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetValue();
            }
            case 2: {
                return this.isSetTimestamp();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TCell) {
            return this.equals((TCell)that);
        }
        return false;
    }

    public boolean equals(TCell that) {
        if (that == null) {
            return false;
        }
        boolean this_present_value = this.isSetValue();
        boolean that_present_value = that.isSetValue();
        if (this_present_value || that_present_value) {
            if (!this_present_value || !that_present_value) {
                return false;
            }
            if (!Arrays.equals(this.value, that.value)) {
                return false;
            }
        }
        boolean this_present_timestamp = true;
        boolean that_present_timestamp = true;
        if (this_present_timestamp || that_present_timestamp) {
            if (!this_present_timestamp || !that_present_timestamp) {
                return false;
            }
            if (this.timestamp != that.timestamp) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.value = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 10) {
                        this.timestamp = iprot.readI64();
                        this.__isset.timestamp = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.value != null) {
            oprot.writeFieldBegin(VALUE_FIELD_DESC);
            oprot.writeBinary(this.value);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(TIMESTAMP_FIELD_DESC);
        oprot.writeI64(this.timestamp);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TCell(");
        boolean first = true;
        sb.append("value:");
        if (this.value == null) {
            sb.append("null");
        } else {
            sb.append(this.value);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("timestamp:");
        sb.append(this.timestamp);
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(TCell.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean timestamp = false;

        private Isset() {
        }
    }
}

