/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class CompressionTest {
    protected static Path path = new Path(".hfile-comp-test");

    public static void usage() {
        System.err.println("Usage: CompressionTest HDFS_PATH none|gz|lzo");
        System.exit(1);
    }

    protected static DistributedFileSystem openConnection(String urlString) throws URISyntaxException, IOException {
        URI dfsUri = new URI(urlString);
        Configuration dfsConf = new Configuration();
        DistributedFileSystem dfs = new DistributedFileSystem();
        dfs.initialize(dfsUri, dfsConf);
        return dfs;
    }

    protected static boolean closeConnection(DistributedFileSystem dfs) {
        if (dfs != null) {
            try {
                dfs.close();
                dfs = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dfs == null;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            CompressionTest.usage();
        }
        try {
            DistributedFileSystem dfs = CompressionTest.openConnection(args[0]);
            dfs.delete(path, false);
            HFile.Writer writer = new HFile.Writer((FileSystem)dfs, path, 65536, args[1], null);
            writer.append(Bytes.toBytes("testkey"), Bytes.toBytes("testval"));
            writer.appendFileInfo(Bytes.toBytes("infokey"), Bytes.toBytes("infoval"));
            writer.close();
            HFile.Reader reader = new HFile.Reader((FileSystem)dfs, path, null, false);
            reader.loadFileInfo();
            byte[] key = reader.getFirstKey();
            boolean rc = Bytes.toString(key).equals("testkey");
            reader.close();
            dfs.delete(path, false);
            CompressionTest.closeConnection(dfs);
            if (rc) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("FAILED");
        System.exit(1);
    }
}

