/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HStoreKey;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.migration.nineteen.io.BloomFilterMapFile;
import org.apache.hadoop.hbase.migration.nineteen.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.MetaUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class Migrate
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(Migrate.class);
    private FileSystem fs;
    boolean migrationNeeded = false;
    boolean check = false;
    private static final float HBASE_0_1_VERSION = 0.1f;
    private static final int PREVIOUS_VERSION = 6;
    private static final String MIGRATION_LINK = " See http://wiki.apache.org/hadoop/Hbase/HowToMigrate for more information.";

    public Migrate() {
    }

    public Migrate(HBaseConfiguration c) {
        super((Configuration)c);
    }

    private boolean setFsDefaultName() {
        Path rd = new Path(this.getConf().get("hbase.rootdir"));
        try {
            FSUtils.validateRootPath(rd);
        }
        catch (IOException e) {
            LOG.fatal((Object)("Not starting migration because the root directory path '" + rd.toString() + "' is not valid. Check the setting of the" + " configuration parameter '" + "hbase.rootdir" + "'"), (Throwable)e);
            return false;
        }
        this.getConf().set("fs.default.name", rd.toString());
        return true;
    }

    private boolean verifyFilesystem() {
        try {
            this.fs = FileSystem.get((Configuration)this.getConf());
            LOG.info((Object)"Verifying that file system is available..");
            FSUtils.checkFileSystemAvailable(this.fs);
            return true;
        }
        catch (IOException e) {
            LOG.fatal((Object)"File system is not available", (Throwable)e);
            return false;
        }
    }

    private boolean notRunning() {
        LOG.info((Object)"Verifying that HBase is not running....Trys ten times  to connect to running master");
        try {
            HBaseAdmin.checkHBaseAvailable((HBaseConfiguration)this.getConf());
            LOG.fatal((Object)"HBase cluster must be off-line.");
            return false;
        }
        catch (MasterNotRunningException e) {
            return true;
        }
    }

    public int run(String[] args) {
        if (this.parseArgs(args) != 0) {
            return -1;
        }
        if (!this.setFsDefaultName()) {
            return -2;
        }
        if (!this.verifyFilesystem()) {
            return -3;
        }
        try {
            LOG.info((Object)("Starting upgrade" + (this.check ? " check" : "")));
            String versionStr = FSUtils.getVersion(this.fs, FSUtils.getRootDir((HBaseConfiguration)this.getConf()));
            if (versionStr == null) {
                throw new IOException("File system version file hbase.version does not exist. No upgrade possible. See http://wiki.apache.org/hadoop/Hbase/HowToMigrate for more information.");
            }
            if (versionStr.compareTo("7") == 0) {
                LOG.info((Object)"No upgrade necessary.");
                return 0;
            }
            float version = Float.parseFloat(versionStr);
            if (version == 0.1f || Integer.valueOf(versionStr) < 6) {
                String msg = "Cannot upgrade from " + versionStr + " to " + "7" + " you must install an earlier hbase, run " + "the upgrade tool, reinstall this version and run this utility again." + MIGRATION_LINK;
                System.out.println(msg);
                throw new IOException(msg);
            }
            this.migrationNeeded = true;
            this.migrate6to7();
            if (!this.check) {
                LOG.info((Object)"Setting file system version.");
                FSUtils.setVersion(this.fs, FSUtils.getRootDir((HBaseConfiguration)this.getConf()));
                LOG.info((Object)"Upgrade successful.");
            } else if (this.migrationNeeded) {
                LOG.info((Object)"Upgrade needed.");
            }
            return 0;
        }
        catch (Exception e) {
            LOG.fatal((Object)("Upgrade" + (this.check ? " check" : "") + " failed"), (Throwable)e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrate6to7() throws IOException {
        if (this.check && this.migrationNeeded) {
            return;
        }
        Path hbaseRootDir = new Path(this.getConf().get("hbase.rootdir"));
        boolean pre020 = FSUtils.isPre020FileLayout(this.fs, hbaseRootDir);
        if (pre020) {
            LOG.info((Object)"Checking pre020 filesystem is major compacted");
            if (!FSUtils.isMajorCompactedPre020(this.fs, hbaseRootDir)) {
                String msg = "All tables must be major compacted before migration. See http://wiki.apache.org/hadoop/Hbase/HowToMigrate for more information.";
                System.out.println(msg);
                throw new IOException(msg);
            }
            this.rewrite(hbaseRootDir);
        }
        LOG.info((Object)"Checking filesystem is major compacted");
        if (!FSUtils.isMajorCompacted(this.fs, hbaseRootDir)) {
            LOG.info((Object)"Checking filesystem is major compacted");
            if (!FSUtils.isMajorCompacted(this.fs, hbaseRootDir)) {
                String msg = "All tables must be major compacted before migration. See http://wiki.apache.org/hadoop/Hbase/HowToMigrate for more information.";
                System.out.println(msg);
                throw new IOException(msg);
            }
        }
        final MetaUtils utils = new MetaUtils((HBaseConfiguration)this.getConf());
        final ArrayList metas = new ArrayList();
        try {
            this.rewriteHRegionInfo(utils.getRootRegion().getRegionInfo());
            utils.scanRootRegion(new MetaUtils.ScannerListener(){

                @Override
                public boolean processRow(HRegionInfo info) throws IOException {
                    if (Migrate.this.check && !Migrate.this.migrationNeeded) {
                        Migrate.this.migrationNeeded = true;
                        return false;
                    }
                    metas.add(info);
                    Migrate.this.rewriteHRegionInfo(utils.getRootRegion(), info);
                    return true;
                }
            });
            for (HRegionInfo hri : metas) {
                final HRegion h = utils.getMetaRegion(hri);
                utils.scanMetaRegion(h, new MetaUtils.ScannerListener(){

                    @Override
                    public boolean processRow(HRegionInfo info) throws IOException {
                        if (Migrate.this.check && !Migrate.this.migrationNeeded) {
                            Migrate.this.migrationNeeded = true;
                            return false;
                        }
                        Migrate.this.rewriteHRegionInfo(h, info);
                        return true;
                    }
                });
            }
            this.cleanOldLogFiles(hbaseRootDir);
        }
        finally {
            utils.shutdown();
        }
    }

    private void cleanOldLogFiles(Path hbaseRootDir) throws IOException {
        FileStatus[] oldlogfiles = this.fs.listStatus(hbaseRootDir, new PathFilter(){

            public boolean accept(Path p) {
                return p.getName().startsWith("log_");
            }
        });
        if (oldlogfiles.length <= 0) {
            return;
        }
        LOG.info((Object)("Removing " + oldlogfiles.length + " old logs file clutter"));
        for (int i = 0; i < oldlogfiles.length; ++i) {
            this.fs.delete(oldlogfiles[i].getPath(), true);
            LOG.info((Object)("Deleted: " + oldlogfiles[i].getPath()));
        }
    }

    private void rewrite(Path hbaseRootDir) throws IOException {
        FileStatus[] tableDirs = this.fs.listStatus(hbaseRootDir, (PathFilter)new FSUtils.DirFilter(this.fs));
        for (int i = 0; i < tableDirs.length; ++i) {
            Path d = tableDirs[i].getPath();
            if (d.getName().equals(".logs")) continue;
            FileStatus[] regionDirs = this.fs.listStatus(d, (PathFilter)new FSUtils.DirFilter(this.fs));
            for (int j = 0; j < regionDirs.length; ++j) {
                Path dd = regionDirs[j].getPath();
                if (dd.getName().equals("compaction.dir")) continue;
                FileStatus[] familyDirs = this.fs.listStatus(dd, (PathFilter)new FSUtils.DirFilter(this.fs));
                for (int k = 0; k < familyDirs.length; ++k) {
                    Path family = familyDirs[k].getPath();
                    Path mfdir = new Path(family, "mapfiles");
                    FileStatus[] mfs = this.fs.listStatus(mfdir);
                    if (mfs.length > 1) {
                        throw new IOException("Should only be one directory in: " + mfdir);
                    }
                    if (mfs.length == 0) {
                        Path infodir = new Path(family, "info");
                        LOG.info((Object)("Removing " + mfdir + " and " + infodir + " because empty"));
                        this.fs.delete(mfdir, true);
                        this.fs.delete(infodir, true);
                        continue;
                    }
                    Migrate.rewrite((HBaseConfiguration)this.getConf(), this.fs, mfs[0].getPath());
                }
            }
        }
    }

    public static void rewrite(HBaseConfiguration conf, FileSystem fs, Path mf) throws IOException {
        Path familydir = mf.getParent().getParent();
        Path regiondir = familydir.getParent();
        Path basedir = regiondir.getParent();
        if (HStoreFile.isReference(mf)) {
            throw new IOException(mf.toString() + " is Reference");
        }
        HStoreFile hsf = new HStoreFile(conf, fs, basedir, Integer.parseInt(regiondir.getName()), Bytes.toBytes(familydir.getName()), Long.parseLong(mf.getName()), null);
        BloomFilterMapFile.Reader src = hsf.getReader(fs, false, false);
        String compression = conf.get("migrate.compression", "NONE").trim();
        Compression.Algorithm compressAlgorithm = Compression.Algorithm.valueOf(compression);
        HFile.Writer tgt = StoreFile.getWriter(fs, familydir, conf.getInt("hfile.min.blocksize.size", 65536), compressAlgorithm, Migrate.getComparator(basedir));
        ImmutableBytesWritable deleteBytes = new ImmutableBytesWritable("HBASE::DELETEVAL".getBytes("UTF-8"));
        try {
            ImmutableBytesWritable value;
            HStoreKey key;
            while (src.next(key = new HStoreKey(), (Writable)(value = new ImmutableBytesWritable()))) {
                byte[][] parts = KeyValue.parseColumn(key.getColumn());
                KeyValue kv = deleteBytes.equals(value) ? new KeyValue(key.getRow(), parts[0], parts[1], key.getTimestamp(), KeyValue.Type.Delete) : new KeyValue(key.getRow(), parts[0], parts[1], key.getTimestamp(), value.get());
                tgt.append(kv);
            }
            long seqid = hsf.loadInfo(fs);
            StoreFile.appendMetadata(tgt, seqid, hsf.isMajorCompaction());
            src.close();
            tgt.close();
            hsf.delete();
            fs.delete(mf.getParent(), true);
            fs.delete(new Path(familydir, "info"), true);
            LOG.info((Object)("Rewrote " + mf.toString() + " as " + tgt.toString()));
        }
        catch (IOException e) {
            src.close();
            tgt.close();
            fs.delete(tgt.getPath(), true);
        }
    }

    private static KeyValue.KeyComparator getComparator(Path tabledir) {
        String tablename = tabledir.getName();
        return tablename.equals("-ROOT-") ? KeyValue.META_KEY_COMPARATOR : (tablename.equals(".META.") ? KeyValue.META_KEY_COMPARATOR : KeyValue.KEY_COMPARATOR);
    }

    void rewriteHRegionInfo(HRegion mr, HRegionInfo oldHri) throws IOException {
        if (!this.rewriteHRegionInfo(oldHri)) {
            return;
        }
        Put put = new Put(oldHri.getRegionName());
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)oldHri));
        mr.put(put);
    }

    private boolean rewriteHRegionInfo(HRegionInfo hri) {
        boolean result = false;
        int catalogMemStoreFlushSize = 32768;
        if (hri.isMetaRegion() && hri.getTableDesc().getMemStoreFlushSize() != (long)catalogMemStoreFlushSize) {
            hri.getTableDesc().setMemStoreFlushSize(catalogMemStoreFlushSize);
            result = true;
        }
        String compression = this.getConf().get("migrate.compression", "NONE").trim();
        Compression.Algorithm compressAlgorithm = Compression.Algorithm.valueOf(compression);
        hri.getTableDesc().remove(Bytes.toBytes("MEMCACHE_FLUSHSIZE"));
        for (HColumnDescriptor hcd : hri.getTableDesc().getFamilies()) {
            hcd.setBlockCacheEnabled(true);
            hcd.setCompressionType(compressAlgorithm);
            result = true;
        }
        return result;
    }

    void updateVersions(HRegion mr, HRegionInfo oldHri) throws IOException {
        if (!this.updateVersions(oldHri)) {
            return;
        }
        Put put = new Put(oldHri.getRegionName());
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)oldHri));
        mr.put(put);
        LOG.info((Object)("Upped versions on " + oldHri.getRegionNameAsString()));
    }

    private boolean updateVersions(HRegionInfo hri) {
        boolean result = false;
        HColumnDescriptor hcd = hri.getTableDesc().getFamily(HConstants.CATALOG_HISTORIAN_FAMILY);
        if (hcd == null) {
            LOG.info((Object)("No region historian family in: " + hri.getRegionNameAsString()));
            return result;
        }
        if (hcd.getTimeToLive() == Integer.MAX_VALUE) {
            hcd.setTimeToLive(604800);
            result = true;
        }
        if ((hcd = hri.getTableDesc().getFamily(HConstants.CATALOG_FAMILY)).getMaxVersions() == 1) {
            hcd.setMaxVersions(10);
            result = true;
        }
        return result;
    }

    private int parseArgs(String[] args) {
        Options opts = new Options();
        GenericOptionsParser parser = new GenericOptionsParser(this.getConf(), opts, args);
        String[] remainingArgs = parser.getRemainingArgs();
        if (remainingArgs.length != 1) {
            this.usage();
            return -1;
        }
        if (remainingArgs[0].compareTo("check") == 0) {
            this.check = true;
        } else if (remainingArgs[0].compareTo("upgrade") != 0) {
            this.usage();
            return -1;
        }
        return 0;
    }

    private void usage() {
        System.err.println("Usage: bin/hbase migrate {check | upgrade} [options]");
        System.err.println();
        System.err.println("  check                            perform upgrade checks only.");
        System.err.println("  upgrade                          perform upgrade checks and modify hbase.");
        System.err.println();
        System.err.println("  Options are:");
        System.err.println("    -conf <configuration file>     specify an application configuration file");
        System.err.println("    -D <property=value>            use value for given property");
        System.err.println("    -fs <local|namenode:port>      specify a namenode");
    }

    public static void main(String[] args) {
        int status = 0;
        try {
            status = ToolRunner.run((Configuration)new HBaseConfiguration(), (Tool)new Migrate(), (String[])args);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            status = -1;
        }
        System.exit(status);
    }
}

