/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.HQuorumPeer;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperWrapper
implements HConstants {
    protected static final Log LOG = LogFactory.getLog(ZooKeeperWrapper.class);
    private static final char ZNODE_PATH_SEPARATOR = '/';
    private String quorumServers = null;
    private final ZooKeeper zooKeeper;
    private final String parentZNode;
    private final String rootRegionZNode;
    private final String outOfSafeModeZNode;
    private final String rsZNode;
    private final String masterElectionZNode;
    public final String clusterStateZNode;

    public ZooKeeperWrapper(HBaseConfiguration conf, Watcher watcher) throws IOException {
        Properties properties = HQuorumPeer.makeZKProps(conf);
        this.setQuorumServers(properties);
        if (this.quorumServers == null) {
            throw new IOException("Could not read quorum servers from zoo.cfg");
        }
        int sessionTimeout = conf.getInt("zookeeper.session.timeout", 60000);
        try {
            this.zooKeeper = new ZooKeeper(this.quorumServers, sessionTimeout, watcher);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to create ZooKeeper object: " + e));
            throw new IOException(e);
        }
        this.parentZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String rootServerZNodeName = conf.get("zookeeper.znode.rootserver", "root-region-server");
        String outOfSafeModeZNodeName = conf.get("zookeeper.znode.safemode", "safe-mode");
        String rsZNodeName = conf.get("zookeeper.znode.rs", "rs");
        String masterAddressZNodeName = conf.get("zookeeper.znode.master", "master");
        String stateZNodeName = conf.get("zookeeper.znode.state", "shutdown");
        this.rootRegionZNode = this.getZNode(this.parentZNode, rootServerZNodeName);
        this.outOfSafeModeZNode = this.getZNode(this.parentZNode, outOfSafeModeZNodeName);
        this.rsZNode = this.getZNode(this.parentZNode, rsZNodeName);
        this.masterElectionZNode = this.getZNode(this.parentZNode, masterAddressZNodeName);
        this.clusterStateZNode = this.getZNode(this.parentZNode, stateZNodeName);
    }

    private void setQuorumServers(Properties properties) {
        String clientPort = null;
        ArrayList<String> servers = new ArrayList<String>();
        boolean anyValid = false;
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = property.getKey().toString().trim();
            String value = property.getValue().toString().trim();
            if (key.equals("clientPort")) {
                clientPort = value;
                continue;
            }
            if (!key.startsWith("server.")) continue;
            String host = value.substring(0, value.indexOf(58));
            servers.add(host);
            try {
                InetAddress.getByName(host);
                anyValid = true;
            }
            catch (UnknownHostException e) {
                LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
            }
        }
        if (!anyValid) {
            LOG.error((Object)"no valid quorum servers found in zoo.cfg");
            return;
        }
        if (clientPort == null) {
            LOG.error((Object)"no clientPort found in zoo.cfg");
            return;
        }
        if (servers.isEmpty()) {
            LOG.fatal((Object)"No server.X lines found in conf/zoo.cfg. HBase must have a ZooKeeper cluster configured for its operation.");
            return;
        }
        StringBuilder hostPortBuilder = new StringBuilder();
        for (int i = 0; i < servers.size(); ++i) {
            String host = (String)servers.get(i);
            if (i > 0) {
                hostPortBuilder.append(',');
            }
            hostPortBuilder.append(host);
            hostPortBuilder.append(':');
            hostPortBuilder.append(clientPort);
        }
        this.quorumServers = hostPortBuilder.toString();
    }

    public String dump() {
        String[] servers;
        StringBuilder sb = new StringBuilder();
        sb.append("\nHBase tree in ZooKeeper is rooted at ").append(this.parentZNode);
        sb.append("\n  Cluster up? ").append(this.exists(this.clusterStateZNode));
        sb.append("\n  In safe mode? ").append(!this.checkOutOfSafeMode());
        sb.append("\n  Master address: ").append(this.readMasterAddress(null));
        sb.append("\n  Region server holding ROOT: ").append(this.readRootRegionLocation());
        sb.append("\n  Region servers:");
        for (HServerAddress address : this.scanRSDirectory()) {
            sb.append("\n    - ").append(address);
        }
        sb.append("\n  Quorum Server Statistics:");
        for (String server : servers = this.quorumServers.split(",")) {
            sb.append("\n    - ").append(server);
            try {
                String[] stat;
                for (String s : stat = this.getServerStats(server)) {
                    sb.append("\n        ").append(s);
                }
            }
            catch (Exception e) {
                sb.append("\n        ERROR: ").append(e.getMessage());
            }
        }
        return sb.toString();
    }

    public String[] getServerStats(String server) throws IOException {
        return this.getServerStats(server, 60000);
    }

    public String[] getServerStats(String server, int timeout) throws IOException {
        String line;
        String[] sp = server.split(":");
        Socket socket = new Socket(sp[0], sp.length > 1 ? Integer.parseInt(sp[1]) : 2181);
        socket.setSoTimeout(timeout);
        PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        out.println("stat");
        out.flush();
        ArrayList<String> res = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            res.add(line);
        }
        socket.close();
        return res.toArray(new String[res.size()]);
    }

    private boolean exists(String znode) {
        try {
            return this.zooKeeper.exists(znode, null) != null;
        }
        catch (KeeperException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public ZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public long getSessionID() {
        return this.zooKeeper.getSessionId();
    }

    public byte[] getSessionPassword() {
        return this.zooKeeper.getSessionPasswd();
    }

    public String getQuorumServers() {
        return this.quorumServers;
    }

    public boolean isConnected() {
        return this.zooKeeper.getState() == ZooKeeper.States.CONNECTED;
    }

    public HServerAddress readRootRegionLocation() {
        return this.readAddress(this.rootRegionZNode, null);
    }

    public HServerAddress readMasterAddressOrThrow() throws IOException {
        return this.readAddressOrThrow(this.masterElectionZNode, null);
    }

    public HServerAddress readMasterAddress(Watcher watcher) {
        return this.readAddress(this.masterElectionZNode, watcher);
    }

    public void setClusterStateWatch(Watcher watcher) {
        try {
            this.zooKeeper.exists(this.clusterStateZNode, watcher);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to check on ZNode " + this.clusterStateZNode), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to check on ZNode " + this.clusterStateZNode), (Throwable)e);
        }
    }

    public boolean setClusterState(boolean up) {
        if (!this.ensureParentExists(this.clusterStateZNode)) {
            return false;
        }
        try {
            if (up) {
                byte[] data = Bytes.toBytes("up");
                this.zooKeeper.create(this.clusterStateZNode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                LOG.debug((Object)"State node wrote in ZooKeeper");
            } else {
                this.zooKeeper.delete(this.clusterStateZNode, -1);
                LOG.debug((Object)"State node deleted in ZooKeeper");
            }
            return true;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Failed to set state node in ZooKeeper", (Throwable)e);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NODEEXISTS) {
                LOG.debug((Object)"State node exists.");
            }
            LOG.warn((Object)"Failed to set state node in ZooKeeper", (Throwable)e);
        }
        return false;
    }

    public boolean watchMasterAddress(Watcher watcher) {
        try {
            this.zooKeeper.exists(this.masterElectionZNode, watcher);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to set watcher on ZNode " + this.masterElectionZNode), (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to set watcher on ZNode " + this.masterElectionZNode), (Throwable)e);
            return false;
        }
        LOG.debug((Object)("Set watcher on master address ZNode " + this.masterElectionZNode));
        return true;
    }

    private HServerAddress readAddress(String znode, Watcher watcher) {
        try {
            return this.readAddressOrThrow(znode, watcher);
        }
        catch (IOException e) {
            LOG.debug((Object)("Failed to read: " + e.getMessage()));
            return null;
        }
    }

    private HServerAddress readAddressOrThrow(String znode, Watcher watcher) throws IOException {
        byte[] data;
        try {
            data = this.zooKeeper.getData(znode, watcher, null);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        String addressString = Bytes.toString(data);
        LOG.debug((Object)("Read ZNode " + znode + " got " + addressString));
        HServerAddress address = new HServerAddress(addressString);
        return address;
    }

    private boolean ensureExists(String znode) {
        try {
            this.zooKeeper.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.debug((Object)("Created ZNode " + znode));
            return true;
        }
        catch (KeeperException.NodeExistsException e) {
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return this.ensureParentExists(znode) && this.ensureExists(znode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to create " + znode + " -- check quorum servers, currently=" + this.quorumServers), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to create " + znode + " -- check quorum servers, currently=" + this.quorumServers), (Throwable)e);
        }
        return false;
    }

    private boolean ensureParentExists(String znode) {
        int index = znode.lastIndexOf(47);
        if (index <= 0) {
            return true;
        }
        return this.ensureExists(znode.substring(0, index));
    }

    public boolean deleteRootRegionLocation() {
        if (!this.ensureParentExists(this.rootRegionZNode)) {
            return false;
        }
        try {
            this.zooKeeper.delete(this.rootRegionZNode, -1);
            LOG.debug((Object)("Deleted ZNode " + this.rootRegionZNode));
            return true;
        }
        catch (KeeperException.NoNodeException e) {
            return true;
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to delete " + this.rootRegionZNode + ": " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to delete " + this.rootRegionZNode + ": " + e));
        }
        return false;
    }

    private boolean createRootRegionLocation(String address) {
        byte[] data = Bytes.toBytes(address);
        try {
            this.zooKeeper.create(this.rootRegionZNode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.debug((Object)("Created ZNode " + this.rootRegionZNode + " with data " + address));
            return true;
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to create root region in ZooKeeper: " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to create root region in ZooKeeper: " + e));
        }
        return false;
    }

    private boolean updateRootRegionLocation(String address) {
        byte[] data = Bytes.toBytes(address);
        try {
            this.zooKeeper.setData(this.rootRegionZNode, data, -1);
            LOG.debug((Object)("SetData of ZNode " + this.rootRegionZNode + " with " + address));
            return true;
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to set root region location in ZooKeeper: " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to set root region location in ZooKeeper: " + e));
        }
        return false;
    }

    public boolean writeRootRegionLocation(HServerAddress address) {
        if (address == null) {
            return this.deleteRootRegionLocation();
        }
        if (!this.ensureParentExists(this.rootRegionZNode)) {
            return false;
        }
        String addressString = address.toString();
        if (this.checkExistenceOf(this.rootRegionZNode)) {
            return this.updateRootRegionLocation(addressString);
        }
        return this.createRootRegionLocation(addressString);
    }

    public boolean writeMasterAddress(HServerAddress address) {
        if (!this.ensureParentExists(this.masterElectionZNode)) {
            return false;
        }
        String addressStr = address.toString();
        byte[] data = Bytes.toBytes(addressStr);
        try {
            this.zooKeeper.create(this.masterElectionZNode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            LOG.debug((Object)("Wrote master address " + address + " to ZooKeeper"));
            return true;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to write master address " + address + " to ZooKeeper"), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to write master address " + address + " to ZooKeeper"), (Throwable)e);
        }
        return false;
    }

    public boolean checkOutOfSafeMode() {
        if (!this.ensureParentExists(this.outOfSafeModeZNode)) {
            return false;
        }
        return this.checkExistenceOf(this.outOfSafeModeZNode);
    }

    public boolean writeOutOfSafeMode() {
        block4: {
            if (!this.ensureParentExists(this.outOfSafeModeZNode)) {
                return false;
            }
            try {
                this.zooKeeper.create(this.outOfSafeModeZNode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                LOG.debug((Object)"Wrote out of safe mode");
                return true;
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Failed to create out of safe mode in ZooKeeper: " + e));
            }
            catch (KeeperException e) {
                LOG.warn((Object)("Failed to create out of safe mode in ZooKeeper: " + (Object)((Object)e)));
                if (!e.getMessage().contains("KeeperErrorCode = NodeExists")) break block4;
                LOG.info((Object)"Node exists; just move on");
                return true;
            }
        }
        return false;
    }

    public boolean writeRSLocation(HServerInfo info) {
        this.ensureExists(this.rsZNode);
        byte[] data = Bytes.toBytes(info.getServerAddress().toString());
        String znode = this.joinPath(this.rsZNode, Long.toString(info.getStartCode()));
        try {
            this.zooKeeper.create(znode, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            LOG.debug((Object)("Created ZNode " + znode + " with data " + info.getServerAddress().toString()));
            return true;
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to create " + znode + " znode in ZooKeeper: " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to create " + znode + " znode in ZooKeeper: " + e));
        }
        return false;
    }

    public boolean updateRSLocationGetWatch(HServerInfo info, Watcher watcher) {
        byte[] data = Bytes.toBytes(info.getServerAddress().toString());
        String znode = this.rsZNode + '/' + info.getStartCode();
        try {
            this.zooKeeper.setData(znode, data, -1);
            LOG.debug((Object)("Updated ZNode " + znode + " with data " + info.getServerAddress().toString()));
            this.zooKeeper.getData(znode, watcher, null);
            return true;
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to update " + znode + " znode in ZooKeeper: " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to update " + znode + " znode in ZooKeeper: " + e));
        }
        return false;
    }

    public List<HServerAddress> scanRSDirectory() {
        ArrayList<HServerAddress> addresses = new ArrayList<HServerAddress>();
        try {
            List nodes = this.zooKeeper.getChildren(this.rsZNode, false);
            for (String node : nodes) {
                addresses.add(this.readAddress(this.rsZNode + '/' + node, null));
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to read " + this.rsZNode + " znode in ZooKeeper: " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to read " + this.rsZNode + " znode in ZooKeeper: " + e));
        }
        return addresses;
    }

    public void clearRSDirectory() {
        try {
            List nodes = this.zooKeeper.getChildren(this.rsZNode, false);
            for (String node : nodes) {
                LOG.debug((Object)("Deleting node: " + node));
                this.zooKeeper.delete(this.joinPath(this.rsZNode, node), -1);
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to delete " + this.rsZNode + " znodes in ZooKeeper: " + (Object)((Object)e)));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Failed to delete " + this.rsZNode + " znodes in ZooKeeper: " + e));
        }
    }

    private boolean checkExistenceOf(String path) {
        Stat stat = null;
        try {
            stat = this.zooKeeper.exists(path, false);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("checking existence of " + path), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("checking existence of " + path), (Throwable)e);
        }
        return stat != null;
    }

    public void close() {
        try {
            this.zooKeeper.close();
            LOG.debug((Object)"Closed connection with ZooKeeper");
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Failed to close connection with ZooKeeper");
        }
    }

    private String getZNode(String parentZNode, String znodeName) {
        return znodeName.charAt(0) == '/' ? znodeName : this.joinPath(parentZNode, znodeName);
    }

    private String joinPath(String parent, String child) {
        return parent + '/' + child;
    }

    public String getMasterElectionZNode() {
        return this.masterElectionZNode;
    }
}

