/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;

public class Context {
    private Path resFile;
    private Path resDir;
    private FileSystem resFs;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.Context");
    private Path[] resDirPaths;
    private int resDirFilesNum;
    boolean initialized;
    private Path queryScratchPath;
    private String localScratchPath;
    private Path localScratchDir;
    private Path MRScratchDir;
    private final Map<String, Path> externalScratchDirs = new HashMap<String, Path>();
    private HiveConf conf;
    protected int pathid = 10000;
    protected boolean explain = false;
    private TokenRewriteStream tokenRewriteStream;
    String executionId;

    public Context(HiveConf conf) throws IOException {
        this(conf, Context.generateExecutionId());
    }

    public Context(HiveConf conf, String executionId) throws IOException {
        this.conf = conf;
        this.executionId = executionId;
        this.localScratchPath = System.getProperty("java.io.tmpdir") + "/" + System.getProperty("user.name") + "/" + executionId;
        this.queryScratchPath = new Path(conf.getVar(HiveConf.ConfVars.SCRATCHDIR), executionId);
    }

    public void setExplain(boolean value) {
        this.explain = value;
    }

    public boolean getExplain() {
        return this.explain;
    }

    private Path makeMRScratchDir(HiveConf conf, boolean mkdir) throws IOException {
        FileSystem fs;
        Path dir = FileUtils.makeQualified(this.queryScratchPath, conf);
        if (mkdir && !(fs = dir.getFileSystem((Configuration)conf)).mkdirs(dir)) {
            throw new IOException("Cannot make directory: " + dir);
        }
        return dir;
    }

    private Path makeExternalScratchDir(HiveConf conf, boolean mkdir, URI extURI) throws IOException {
        FileSystem fs;
        Path dir = new Path(extURI.getScheme(), extURI.getAuthority(), this.queryScratchPath.toUri().getPath());
        if (mkdir && !(fs = dir.getFileSystem((Configuration)conf)).mkdirs(dir)) {
            throw new IOException("Cannot make directory: " + dir);
        }
        return dir;
    }

    private Path makeLocalScratchDir(boolean mkdir) throws IOException {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        Path dir = fs.makeQualified(new Path(this.localScratchPath));
        if (mkdir && !fs.mkdirs(dir)) {
            throw new IOException("Cannot make directory: " + dir);
        }
        return dir;
    }

    private String getExternalScratchDir(URI extURI) {
        try {
            String fileSystem = extURI.getScheme() + ":" + extURI.getAuthority();
            Path dir = this.externalScratchDirs.get(fileSystem);
            if (dir == null) {
                dir = this.makeExternalScratchDir(this.conf, !this.explain, extURI);
                this.externalScratchDirs.put(fileSystem, dir);
            }
            return dir.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMRScratchDir() {
        try {
            if (this.isLocalOnlyExecutionMode()) {
                return this.getLocalScratchDir();
            }
            if (this.MRScratchDir == null) {
                this.MRScratchDir = this.makeMRScratchDir(this.conf, !this.explain);
            }
            return this.MRScratchDir.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error while making MR scratch directory - check filesystem config (" + e.getCause() + ")", e);
        }
    }

    public String getLocalScratchDir() {
        try {
            if (this.localScratchDir == null) {
                this.localScratchDir = this.makeLocalScratchDir(true);
            }
            return this.localScratchDir.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error while making local scratch directory - check filesystem config (" + e.getCause() + ")", e);
        }
    }

    private void removeDir(Path p) {
        try {
            p.getFileSystem((Configuration)this.conf).delete(p, true);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error Removing Scratch: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
        }
    }

    private void removeScratchDir() {
        for (Map.Entry<String, Path> p : this.externalScratchDirs.entrySet()) {
            this.removeDir(p.getValue());
        }
        this.externalScratchDirs.clear();
        if (this.MRScratchDir != null) {
            this.removeDir(this.MRScratchDir);
            this.MRScratchDir = null;
        }
        if (this.localScratchDir != null) {
            this.removeDir(this.localScratchDir);
            this.localScratchDir = null;
        }
    }

    private String nextPath(String base) {
        return base + "/" + Integer.toString(this.pathid++);
    }

    public boolean isMRTmpFileURI(String uriStr) {
        return uriStr.indexOf(this.executionId) != -1;
    }

    public String getMRTmpFileURI() {
        return this.nextPath(this.getMRScratchDir());
    }

    public String getLocalTmpFileURI() {
        return this.nextPath(this.getLocalScratchDir());
    }

    public String getExternalTmpFileURI(URI extURI) {
        return this.nextPath(this.getExternalScratchDir(extURI));
    }

    public Path getResFile() {
        return this.resFile;
    }

    public void setResFile(Path resFile) {
        this.resFile = resFile;
        this.resDir = null;
        this.resDirPaths = null;
        this.resDirFilesNum = 0;
    }

    public Path getResDir() {
        return this.resDir;
    }

    public void setResDir(Path resDir) {
        this.resDir = resDir;
        this.resFile = null;
        this.resDirFilesNum = 0;
        this.resDirPaths = null;
    }

    public void clear() throws IOException {
        FileSystem fs;
        if (this.resDir != null) {
            try {
                fs = this.resDir.getFileSystem((Configuration)this.conf);
                fs.delete(this.resDir, true);
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        if (this.resFile != null) {
            try {
                fs = this.resFile.getFileSystem((Configuration)this.conf);
                fs.delete(this.resFile, false);
            }
            catch (IOException e) {
                LOG.info((Object)("Context clear error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            }
        }
        this.removeScratchDir();
    }

    public DataInput getStream() {
        try {
            if (!this.initialized) {
                this.initialized = true;
                if (this.resFile == null && this.resDir == null) {
                    return null;
                }
                if (this.resFile != null) {
                    return this.resFile.getFileSystem((Configuration)this.conf).open(this.resFile);
                }
                this.resFs = this.resDir.getFileSystem((Configuration)this.conf);
                FileStatus status = this.resFs.getFileStatus(this.resDir);
                assert (status.isDir());
                FileStatus[] resDirFS = this.resFs.globStatus(new Path(this.resDir + "/*"));
                this.resDirPaths = new Path[resDirFS.length];
                int pos = 0;
                for (FileStatus resFS : resDirFS) {
                    if (resFS.isDir()) continue;
                    this.resDirPaths[pos++] = resFS.getPath();
                }
                if (pos == 0) {
                    return null;
                }
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
            return this.getNextStream();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
    }

    private DataInput getNextStream() {
        try {
            if (this.resDir != null && this.resDirFilesNum < this.resDirPaths.length && this.resDirPaths[this.resDirFilesNum] != null) {
                return this.resFs.open(this.resDirPaths[this.resDirFilesNum++]);
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        catch (IOException e) {
            LOG.info((Object)("getNextStream error: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return null;
        }
        return null;
    }

    private static boolean strEquals(String str1, String str2) {
        return StringUtils.equals(str1, str2);
    }

    public void setTokenRewriteStream(TokenRewriteStream tokenRewriteStream) {
        assert (this.tokenRewriteStream == null);
        this.tokenRewriteStream = tokenRewriteStream;
    }

    public TokenRewriteStream getTokenRewriteStream() {
        return this.tokenRewriteStream;
    }

    public static String generateExecutionId() {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS");
        String executionId = "hive_" + format.format(new Date()) + "_" + Math.abs(rand.nextLong());
        return executionId;
    }

    public Path getQueryPath() {
        return this.queryScratchPath;
    }

    public boolean isLocalOnlyExecutionMode() {
        return this.conf.getVar(HiveConf.ConfVars.HADOOPJT).equals("local");
    }
}

