/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExecMapper;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class ExecReducer
extends MapReduceBase
implements Reducer {
    private JobConf jc;
    private OutputCollector<?, ?> oc;
    private Operator<?> reducer;
    private Reporter rp;
    private boolean abort = false;
    private boolean isTagged = false;
    private long cntr = 0L;
    private long nextCntr = 1L;
    private static String[] fieldNames;
    public static final Log l4j;
    private MemoryMXBean memoryMXBean;
    private Deserializer inputKeyDeserializer;
    private final SerDe[] inputValueDeserializer = new SerDe[127];
    TableDesc keyTableDesc;
    TableDesc[] valueTableDesc;
    ObjectInspector[] rowObjectInspector;
    private Object keyObject;
    private final Object[] valueObject = new Object[127];
    private BytesWritable groupKey;
    ArrayList<Object> row = new ArrayList(3);
    ByteWritable tag = new ByteWritable();

    public void configure(JobConf job) {
        this.rowObjectInspector = new ObjectInspector[127];
        ObjectInspector[] valueObjectInspector = new ObjectInspector[127];
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        l4j.info((Object)("maximum memory = " + this.memoryMXBean.getHeapMemoryUsage().getMax()));
        try {
            l4j.info((Object)("conf classpath = " + Arrays.asList(((URLClassLoader)job.getClassLoader()).getURLs())));
            l4j.info((Object)("thread classpath = " + Arrays.asList(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs())));
        }
        catch (Exception e) {
            l4j.info((Object)("cannot get classpath: " + e.getMessage()));
        }
        this.jc = job;
        MapredWork gWork = Utilities.getMapRedWork((Configuration)job);
        this.reducer = gWork.getReducer();
        this.reducer.setParentOperators(null);
        this.isTagged = gWork.getNeedsTagging();
        try {
            this.keyTableDesc = gWork.getKeyDesc();
            this.inputKeyDeserializer = (SerDe)ReflectionUtils.newInstance(this.keyTableDesc.getDeserializerClass(), null);
            this.inputKeyDeserializer.initialize(null, this.keyTableDesc.getProperties());
            ObjectInspector keyObjectInspector = this.inputKeyDeserializer.getObjectInspector();
            this.valueTableDesc = new TableDesc[gWork.getTagToValueDesc().size()];
            for (int tag = 0; tag < gWork.getTagToValueDesc().size(); ++tag) {
                this.valueTableDesc[tag] = gWork.getTagToValueDesc().get(tag);
                this.inputValueDeserializer[tag] = (SerDe)ReflectionUtils.newInstance(this.valueTableDesc[tag].getDeserializerClass(), null);
                this.inputValueDeserializer[tag].initialize(null, this.valueTableDesc[tag].getProperties());
                valueObjectInspector[tag] = this.inputValueDeserializer[tag].getObjectInspector();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                ois.add(keyObjectInspector);
                ois.add(valueObjectInspector[tag]);
                ois.add(PrimitiveObjectInspectorFactory.writableByteObjectInspector);
                this.rowObjectInspector[tag] = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(fieldNames), ois);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            l4j.info((Object)this.reducer.dump(0));
            this.reducer.initialize((Configuration)this.jc, this.rowObjectInspector);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reduce(Object key, Iterator values, OutputCollector output, Reporter reporter) throws IOException {
        if (this.oc == null) {
            this.oc = output;
            this.rp = reporter;
            this.reducer.setOutputCollector(this.oc);
            this.reducer.setReporter(this.rp);
        }
        try {
            BytesWritable keyWritable = (BytesWritable)key;
            this.tag.set((byte)0);
            if (this.isTagged) {
                int size = keyWritable.getSize() - 1;
                this.tag.set(keyWritable.get()[size]);
                keyWritable.setSize(size);
            }
            if (!keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    l4j.trace((Object)"End Group");
                    this.reducer.endGroup();
                }
                try {
                    this.keyObject = this.inputKeyDeserializer.deserialize((Writable)keyWritable);
                }
                catch (Exception e) {
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input key from " + Utilities.formatBinaryString(keyWritable.get(), 0, keyWritable.getSize()) + " with properties " + this.keyTableDesc.getProperties(), e);
                }
                this.groupKey.set(keyWritable.get(), 0, keyWritable.getSize());
                l4j.trace((Object)"Start Group");
                this.reducer.startGroup();
                this.reducer.setGroupKeyObject(this.keyObject);
            }
            while (values.hasNext()) {
                BytesWritable valueWritable = (BytesWritable)values.next();
                try {
                    this.valueObject[this.tag.get()] = this.inputValueDeserializer[this.tag.get()].deserialize((Writable)valueWritable);
                }
                catch (SerDeException e) {
                    throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input value (tag=" + this.tag.get() + ") from " + Utilities.formatBinaryString(valueWritable.get(), 0, valueWritable.getSize()) + " with properties " + this.valueTableDesc[this.tag.get()].getProperties(), e);
                }
                this.row.clear();
                this.row.add(this.keyObject);
                this.row.add(this.valueObject[this.tag.get()]);
                this.row.add(this.tag);
                if (l4j.isInfoEnabled()) {
                    ++this.cntr;
                    if (this.cntr == this.nextCntr) {
                        long used_memory = this.memoryMXBean.getHeapMemoryUsage().getUsed();
                        l4j.info((Object)("ExecReducer: processing " + this.cntr + " rows: used memory = " + used_memory));
                        this.nextCntr = this.getNextCntr(this.cntr);
                    }
                }
                try {
                    this.reducer.process(this.row, this.tag.get());
                }
                catch (Exception e) {
                    String rowString = null;
                    try {
                        rowString = SerDeUtils.getJSONString(this.row, this.rowObjectInspector[this.tag.get()]);
                        throw new HiveException("Hive Runtime Error while processing row (tag=" + this.tag.get() + ") " + rowString, e);
                    }
                    catch (Exception e2) {
                        rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
                    }
                    throw new HiveException("Hive Runtime Error while processing row (tag=" + this.tag.get() + ") " + rowString, e);
                    return;
                }
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.fatal((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private long getNextCntr(long cntr) {
        if (cntr >= 1000000L) {
            return cntr + 1000000L;
        }
        return 10L * cntr;
    }

    public void close() {
        block5: {
            if (this.oc == null) {
                l4j.trace((Object)"Close called no row");
            }
            try {
                if (this.groupKey != null) {
                    l4j.trace((Object)"End Group");
                    this.reducer.endGroup();
                }
                if (l4j.isInfoEnabled()) {
                    l4j.info((Object)("ExecReducer: processed " + this.cntr + " rows: used memory = " + this.memoryMXBean.getHeapMemoryUsage().getUsed()));
                }
                this.reducer.close(this.abort);
                ExecMapper.reportStats rps = new ExecMapper.reportStats(this.rp);
                this.reducer.preorderMap(rps);
            }
            catch (Exception e) {
                if (this.abort) break block5;
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
    }

    static {
        l4j = LogFactory.getLog((String)"ExecReducer");
        ArrayList<String> fieldNameArray = new ArrayList<String>();
        for (Utilities.ReduceField r : Utilities.ReduceField.values()) {
            fieldNameArray.add(r.toString());
        }
        fieldNames = fieldNameArray.toArray(new String[0]);
    }
}

