/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class ExprNodeColumnEvaluator
extends ExprNodeEvaluator {
    protected ExprNodeColumnDesc expr;
    transient StructObjectInspector[] inspectors;
    transient StructField[] fields;

    public ExprNodeColumnEvaluator(ExprNodeColumnDesc expr) {
        this.expr = expr;
    }

    @Override
    public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
        String[] names = this.expr.getColumn().split("\\.");
        this.inspectors = new StructObjectInspector[names.length];
        this.fields = new StructField[names.length];
        for (int i = 0; i < names.length; ++i) {
            if (i == 0) {
                this.inspectors[0] = (StructObjectInspector)rowInspector;
            } else {
                this.inspectors[i] = (StructObjectInspector)this.fields[i - 1].getFieldObjectInspector();
            }
            this.fields[i] = this.inspectors[i].getStructFieldRef(names[i]);
        }
        return this.fields[names.length - 1].getFieldObjectInspector();
    }

    @Override
    public Object evaluate(Object row) throws HiveException {
        Object o = row;
        for (int i = 0; i < this.fields.length; ++i) {
            o = this.inspectors[i].getStructFieldData(o, this.fields[i]);
        }
        return o;
    }
}

