/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.JobCloseFeedBack;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HivePartitioner;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SubStructObjectInspector;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class FileSinkOperator
extends TerminalOperator<FileSinkDesc>
implements Serializable {
    protected transient HashMap<String, FSPaths> valToPaths;
    protected transient int numDynParts;
    protected transient List<String> dpColNames;
    protected transient DynamicPartitionCtx dpCtx;
    protected transient boolean isCompressed;
    protected transient Path parent;
    protected transient HiveOutputFormat<?, ?> hiveOutputFormat;
    protected transient Path specPath;
    protected transient int dpStartCol;
    protected transient List<String> dpVals;
    protected transient List<Object> dpWritables;
    protected transient RecordWriter[] rowOutWriters;
    protected transient int maxPartitions;
    private static final transient String[] FATAL_ERR_MSG = new String[]{null, "Number of dynamic partitions exceeded hive.exec.max.dynamic.partitions.pernode."};
    private static final long serialVersionUID = 1L;
    protected transient FileSystem fs;
    protected transient Serializer serializer;
    protected transient BytesWritable commonKey = new BytesWritable();
    protected transient TableIdEnum tabIdEnum = null;
    private transient LongWritable row_count;
    private transient boolean isNativeTable = true;
    private transient ExprNodeEvaluator[] partitionEval;
    private transient int totalFiles;
    private transient int numFiles;
    private transient boolean multiFileSpray;
    private final transient Map<Integer, Integer> bucketMap = new HashMap<Integer, Integer>();
    private transient ObjectInspector[] partitionObjectInspectors;
    private transient HivePartitioner<HiveKey, Object> prtner;
    private final transient HiveKey key = new HiveKey();
    private transient Configuration hconf;
    private transient FSPaths fsp;
    private transient boolean bDynParts;
    private transient SubStructObjectInspector subSetOI;
    protected transient boolean autoDelete = false;
    protected transient JobConf jc;
    Class<? extends Writable> outputClass;
    String taskId;
    private boolean filesCreated = false;
    Writable recordValue;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            int id;
            this.hconf = hconf;
            this.filesCreated = false;
            this.isNativeTable = !((FileSinkDesc)this.conf).getTableInfo().isNonNative();
            this.multiFileSpray = ((FileSinkDesc)this.conf).isMultiFileSpray();
            this.totalFiles = ((FileSinkDesc)this.conf).getTotalFiles();
            this.numFiles = ((FileSinkDesc)this.conf).getNumFiles();
            this.dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
            this.valToPaths = new HashMap();
            this.taskId = Utilities.getTaskId(hconf);
            this.specPath = new Path(((FileSinkDesc)this.conf).getDirName());
            this.fs = this.specPath.getFileSystem(hconf);
            this.hiveOutputFormat = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
            this.isCompressed = ((FileSinkDesc)this.conf).getCompressed();
            this.parent = Utilities.toTempPath(((FileSinkDesc)this.conf).getDirName());
            this.serializer = (Serializer)((Object)((FileSinkDesc)this.conf).getTableInfo().getDeserializerClass().newInstance());
            this.serializer.initialize(null, ((FileSinkDesc)this.conf).getTableInfo().getProperties());
            this.outputClass = this.serializer.getSerializedClass();
            this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf, ExecDriver.class);
            if (this.multiFileSpray) {
                this.partitionEval = new ExprNodeEvaluator[((FileSinkDesc)this.conf).getPartitionCols().size()];
                int i = 0;
                for (ExprNodeDesc e : ((FileSinkDesc)this.conf).getPartitionCols()) {
                    this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
                }
                this.partitionObjectInspectors = FileSinkOperator.initEvaluators(this.partitionEval, this.outputObjInspector);
                this.prtner = (HivePartitioner)ReflectionUtils.newInstance((Class)this.jc.getPartitionerClass(), null);
            }
            if ((id = ((FileSinkDesc)this.conf).getDestTableId()) != 0 && id <= TableIdEnum.values().length) {
                String enumName = "TABLE_ID_" + String.valueOf(id) + "_ROWCOUNT";
                this.tabIdEnum = TableIdEnum.valueOf(enumName);
                this.row_count = new LongWritable();
                this.statsMap.put(this.tabIdEnum, this.row_count);
            }
            if (this.dpCtx != null) {
                this.dpSetup();
            }
            if (!this.bDynParts) {
                this.fsp = new FSPaths(this.specPath);
                this.valToPaths.put("", this.fsp);
            }
            this.initializeChildren(hconf);
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    private void dpSetup() {
        this.bDynParts = false;
        this.numDynParts = this.dpCtx.getNumDPCols();
        this.dpColNames = this.dpCtx.getDPColNames();
        this.maxPartitions = this.dpCtx.getMaxPartitionsPerNode();
        assert (this.numDynParts == this.dpColNames.size()) : "number of dynamic paritions should be the same as the size of DP mapping";
        if (this.dpColNames != null && this.dpColNames.size() > 0) {
            this.bDynParts = true;
            assert (this.inputObjInspectors.length == 1) : "FileSinkOperator should have 1 parent, but it has " + this.inputObjInspectors.length;
            StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
            List<? extends StructField> fieldOI = soi.getAllStructFieldRefs();
            ArrayList<ObjectInspector> newFieldsOI = new ArrayList<ObjectInspector>();
            ArrayList<String> newFieldsName = new ArrayList<String>();
            this.dpStartCol = 0;
            for (StructField structField : fieldOI) {
                String fn = structField.getFieldName();
                if (this.dpCtx.getInputToDPCols().containsKey(fn)) continue;
                newFieldsOI.add(structField.getFieldObjectInspector());
                newFieldsName.add(structField.getFieldName());
                ++this.dpStartCol;
            }
            assert (newFieldsOI.size() > 0) : "new Fields ObjectInspector is empty";
            this.subSetOI = new SubStructObjectInspector(soi, 0, this.dpStartCol);
            this.dpVals = new ArrayList<String>(this.numDynParts);
            this.dpWritables = new ArrayList<Object>(this.numDynParts);
        }
    }

    private void createBucketFiles(FSPaths fsp) throws HiveException {
        try {
            int filesIdx = 0;
            HashSet<Integer> seenBuckets = new HashSet<Integer>();
            for (int idx = 0; idx < this.totalFiles; ++idx) {
                if (this.getExecContext() != null && this.getExecContext().getFileId() != -1) {
                    this.LOG.info((Object)"replace taskId from execContext ");
                    this.taskId = Utilities.replaceTaskIdFromFilename(this.taskId, this.getExecContext().getFileId());
                    this.LOG.info((Object)("new taskId: FS " + this.taskId));
                    assert (!this.multiFileSpray);
                    assert (this.totalFiles == 1);
                }
                if (this.multiFileSpray) {
                    int bucketNum;
                    int reducerIdx;
                    int currReducer;
                    this.key.setHashCode(idx);
                    int numReducers = this.totalFiles / this.numFiles;
                    if (numReducers > 1 && (currReducer = Integer.valueOf(Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf))).intValue()) != (reducerIdx = this.prtner.getPartition((Object)this.key, null, numReducers)) || seenBuckets.contains(bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles))) continue;
                    seenBuckets.add(bucketNum);
                    this.bucketMap.put(bucketNum, filesIdx);
                    this.taskId = Utilities.replaceTaskIdFromFilename(Utilities.getTaskId(this.hconf), bucketNum);
                }
                if (this.isNativeTable) {
                    fsp.finalPaths[filesIdx] = fsp.getFinalPath(this.taskId);
                    this.LOG.info((Object)("Final Path: FS " + fsp.finalPaths[filesIdx]));
                    fsp.outPaths[filesIdx] = fsp.getOutPath(this.taskId);
                    this.LOG.info((Object)("Writing to temp file: FS " + fsp.outPaths[filesIdx]));
                } else {
                    fsp.finalPaths[filesIdx] = fsp.outPaths[filesIdx] = this.specPath;
                }
                try {
                    if (!this.bDynParts) {
                        fsp.finalPaths[filesIdx] = HiveFileFormatUtils.getOutputFormatFinalPath(this.parent, this.taskId, this.jc, this.hiveOutputFormat, this.isCompressed, fsp.finalPaths[filesIdx]);
                    } else {
                        String extension = null;
                        if (this.hiveOutputFormat instanceof HiveIgnoreKeyTextOutputFormat) {
                            extension = Utilities.getFileExtension(this.jc, this.isCompressed);
                        }
                        fsp.finalPaths[filesIdx] = fsp.getFinalPath(this.taskId, fsp.tmpPath, extension);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new HiveException(e);
                }
                this.LOG.info((Object)("New Final Path: FS " + fsp.finalPaths[filesIdx]));
                if (this.isNativeTable) {
                    try {
                        this.autoDelete = ShimLoader.getHadoopShims().fileSystemDeleteOnExit(this.fs, fsp.outPaths[filesIdx]);
                    }
                    catch (IOException e) {
                        throw new HiveException(e);
                    }
                }
                Utilities.copyTableJobPropertiesToConf(((FileSinkDesc)this.conf).getTableInfo(), this.jc);
                fsp.outWriters[filesIdx] = HiveFileFormatUtils.getHiveRecordWriter(this.jc, ((FileSinkDesc)this.conf).getTableInfo(), this.outputClass, (FileSinkDesc)this.conf, fsp.outPaths[filesIdx]);
                ++filesIdx;
            }
            assert (filesIdx == this.numFiles);
            if (this.isNativeTable) {
                this.autoDelete = ShimLoader.getHadoopShims().fileSystemDeleteOnExit(this.fs, fsp.outPaths[0]);
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
        this.filesCreated = true;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (!this.bDynParts && !this.filesCreated) {
            this.createBucketFiles(this.fsp);
        }
        if (this.counterNameToEnum != null) {
            ++this.outputRows;
            if (this.outputRows % 1000L == 0L) {
                this.incrCounter(numOutputRowsCntr, this.outputRows);
                this.outputRows = 0L;
            }
        }
        try {
            if (this.reporter != null) {
                this.reporter.progress();
            }
            assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
            if (this.bDynParts) {
                this.dpVals.clear();
                this.dpWritables.clear();
                ObjectInspectorUtils.partialCopyToStandardObject(this.dpWritables, row, this.dpStartCol, this.numDynParts, (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                for (Object o : this.dpWritables) {
                    if (o == null || o.toString().length() == 0) {
                        this.dpVals.add(this.dpCtx.getDefaultPartitionName());
                        continue;
                    }
                    this.dpVals.add(o.toString());
                }
                this.rowOutWriters = this.getDynOutWriters(this.dpVals);
                this.recordValue = this.serializer.serialize(row, this.subSetOI);
            } else {
                this.rowOutWriters = this.fsp.outWriters;
                this.recordValue = this.serializer.serialize(row, this.inputObjInspectors[0]);
            }
            if (this.row_count != null) {
                this.row_count.set(this.row_count.get() + 1L);
            }
            if (!this.multiFileSpray) {
                this.rowOutWriters[0].write(this.recordValue);
            } else {
                int keyHashCode = 0;
                for (int i = 0; i < this.partitionEval.length; ++i) {
                    Object o = this.partitionEval[i].evaluate(row);
                    keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode(o, this.partitionObjectInspectors[i]);
                }
                this.key.setHashCode(keyHashCode);
                int bucketNum = this.prtner.getBucket(this.key, null, this.totalFiles);
                int idx = this.bucketMap.get(bucketNum);
                this.rowOutWriters[idx].write(this.recordValue);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
    }

    private RecordWriter[] getDynOutWriters(List<String> row) throws HiveException {
        RecordWriter[] rw;
        String dpDir = this.getDynPartDirectory(row, this.dpColNames, this.numDynParts);
        if (dpDir != null) {
            FSPaths fsp2 = this.valToPaths.get(dpDir);
            if (fsp2 == null) {
                if (this.valToPaths.size() > this.maxPartitions) {
                    this.incrCounter(fatalErrorCntr, 1L);
                    fatalError = true;
                    this.LOG.error((Object)"Fatal error was thrown due to exceeding number of dynamic partitions");
                }
                fsp2 = new FSPaths(this.specPath);
                fsp2.tmpPath = new Path(fsp2.tmpPath, dpDir);
                this.createBucketFiles(fsp2);
                this.valToPaths.put(dpDir, fsp2);
            }
            rw = fsp2.outWriters;
        } else {
            rw = this.fsp.outWriters;
        }
        return rw;
    }

    private String getDynPartDirectory(List<String> row, List<String> dpColNames, int numDynParts) {
        assert (row.size() == numDynParts && numDynParts == dpColNames.size()) : "data length is different from num of DP columns";
        return FileUtils.makePartName(dpColNames, row);
    }

    @Override
    protected void fatalErrorMessage(StringBuilder errMsg, long counterCode) {
        errMsg.append("Operator ").append(this.getOperatorId()).append(" (id=").append(this.id).append("): ");
        errMsg.append(counterCode > (long)(FATAL_ERR_MSG.length - 1) ? "fatal error" : FATAL_ERR_MSG[(int)counterCode]);
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (!this.bDynParts && !this.filesCreated) {
            this.createBucketFiles(this.fsp);
        }
        if (!abort) {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.closeWriters(abort);
                if (!this.isNativeTable) continue;
                fsp.commit(this.fs);
            }
        } else {
            for (FSPaths fsp : this.valToPaths.values()) {
                fsp.abortWriters(this.fs, abort, !this.autoDelete && this.isNativeTable);
            }
        }
    }

    @Override
    public String getName() {
        return new String("FS");
    }

    @Override
    public void jobClose(Configuration hconf, boolean success, JobCloseFeedBack feedBack) throws HiveException {
        try {
            if (this.conf != null && this.isNativeTable) {
                String specPath = ((FileSinkDesc)this.conf).getDirName();
                DynamicPartitionCtx dpCtx = ((FileSinkDesc)this.conf).getDynPartCtx();
                this.mvFileToFinalPath(specPath, hconf, success, this.LOG, dpCtx);
                feedBack.add(JobCloseFeedBack.FeedBackType.DYNAMIC_PARTITIONS, specPath);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
        super.jobClose(hconf, success, feedBack);
    }

    public void mvFileToFinalPath(String specPath, Configuration hconf, boolean success, Log log, DynamicPartitionCtx dpCtx) throws IOException, HiveException {
        FileSystem fs = new Path(specPath).getFileSystem(hconf);
        Path tmpPath = Utilities.toTempPath(specPath);
        Path intermediatePath = new Path(tmpPath.getParent(), tmpPath.getName() + ".intermediate");
        Path finalPath = new Path(specPath);
        if (success) {
            if (fs.exists(tmpPath)) {
                log.info((Object)("Moving tmp dir: " + tmpPath + " to: " + intermediatePath));
                Utilities.rename(fs, tmpPath, intermediatePath);
                ArrayList<String> emptyBuckets = Utilities.removeTempOrDuplicateFiles(fs, intermediatePath, dpCtx);
                if (emptyBuckets.size() > 0) {
                    this.createEmptyBuckets(hconf, emptyBuckets);
                }
                log.info((Object)("Moving tmp dir: " + intermediatePath + " to: " + finalPath));
                Utilities.renameOrMoveFiles(fs, intermediatePath, finalPath);
            }
        } else {
            fs.delete(tmpPath, true);
        }
    }

    private void createEmptyBuckets(Configuration hconf, ArrayList<String> paths) throws HiveException, IOException {
        JobConf jc = hconf instanceof JobConf ? new JobConf(hconf) : new JobConf(hconf, ExecDriver.class);
        HiveOutputFormat hiveOutputFormat = null;
        Class<? extends Writable> outputClass = null;
        boolean isCompressed = ((FileSinkDesc)this.conf).getCompressed();
        TableDesc tableInfo = ((FileSinkDesc)this.conf).getTableInfo();
        try {
            Serializer serializer = (Serializer)((Object)tableInfo.getDeserializerClass().newInstance());
            serializer.initialize(null, tableInfo.getProperties());
            outputClass = serializer.getSerializedClass();
            hiveOutputFormat = ((FileSinkDesc)this.conf).getTableInfo().getOutputFileFormatClass().newInstance();
        }
        catch (SerDeException e) {
            throw new HiveException(e);
        }
        catch (InstantiationException e) {
            throw new HiveException(e);
        }
        catch (IllegalAccessException e) {
            throw new HiveException(e);
        }
        for (String p : paths) {
            Path path = new Path(p);
            RecordWriter writer = HiveFileFormatUtils.getRecordWriter(jc, hiveOutputFormat, outputClass, isCompressed, tableInfo.getProperties(), path);
            writer.close(false);
            this.LOG.info((Object)("created empty bucket for enforcing bucketing at " + path));
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.FILESINK;
    }

    @Override
    public void augmentPlan() {
        PlanUtils.configureTableJobPropertiesForStorageHandler(((FileSinkDesc)this.getConf()).getTableInfo());
    }

    public static enum TableIdEnum {
        TABLE_ID_1_ROWCOUNT,
        TABLE_ID_2_ROWCOUNT,
        TABLE_ID_3_ROWCOUNT,
        TABLE_ID_4_ROWCOUNT,
        TABLE_ID_5_ROWCOUNT,
        TABLE_ID_6_ROWCOUNT,
        TABLE_ID_7_ROWCOUNT,
        TABLE_ID_8_ROWCOUNT,
        TABLE_ID_9_ROWCOUNT,
        TABLE_ID_10_ROWCOUNT,
        TABLE_ID_11_ROWCOUNT,
        TABLE_ID_12_ROWCOUNT,
        TABLE_ID_13_ROWCOUNT,
        TABLE_ID_14_ROWCOUNT,
        TABLE_ID_15_ROWCOUNT;

    }

    public class FSPaths
    implements Cloneable {
        Path tmpPath;
        Path[] outPaths;
        Path[] finalPaths;
        RecordWriter[] outWriters;
        int timeOut;

        public FSPaths() {
        }

        public FSPaths(Path specPath) {
            this.tmpPath = Utilities.toTempPath(specPath);
            this.outPaths = new Path[FileSinkOperator.this.numFiles];
            this.finalPaths = new Path[FileSinkOperator.this.numFiles];
            this.outWriters = new RecordWriter[FileSinkOperator.this.numFiles];
            this.timeOut = FileSinkOperator.this.hconf.getInt("mapred.healthChecker.script.timeout", 600000) / 2;
        }

        public void appendTmpPath(String dp) {
            this.tmpPath = new Path(this.tmpPath, dp);
        }

        public Path getOutPath(String taskId) {
            return this.getOutPath(taskId, this.tmpPath);
        }

        public Path getOutPath(String taskId, Path tmp) {
            return new Path(tmp, Utilities.toTempPath(taskId));
        }

        public Path getFinalPath(String taskId) {
            return this.getFinalPath(taskId, this.tmpPath, null);
        }

        public Path getFinalPath(String taskId, Path tmpPath, String extension) {
            if (extension != null) {
                return new Path(tmpPath, taskId + extension);
            }
            return new Path(tmpPath, taskId);
        }

        public void setOutWriters(RecordWriter[] out) {
            this.outWriters = out;
        }

        public RecordWriter[] getOutWriters() {
            return this.outWriters;
        }

        private boolean updateProgress(long lastUpdateTime) {
            if (FileSinkOperator.this.reporter != null && System.currentTimeMillis() - lastUpdateTime > (long)this.timeOut) {
                FileSinkOperator.this.reporter.progress();
                return true;
            }
            return false;
        }

        public void closeWriters(boolean abort) throws HiveException {
            long lastProgressReport = System.currentTimeMillis();
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    if (!this.updateProgress(lastProgressReport)) continue;
                    lastProgressReport = System.currentTimeMillis();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }

        private void commit(FileSystem fs) throws HiveException {
            long lastProgressReport = System.currentTimeMillis();
            for (int idx = 0; idx < this.outPaths.length; ++idx) {
                try {
                    if (!fs.rename(this.outPaths[idx], this.finalPaths[idx])) {
                        throw new HiveException("Unable to rename output to: " + this.finalPaths[idx]);
                    }
                    if (!this.updateProgress(lastProgressReport)) continue;
                    lastProgressReport = System.currentTimeMillis();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e + "Unable to rename output to: " + this.finalPaths[idx]);
                }
            }
        }

        public void abortWriters(FileSystem fs, boolean abort, boolean delete) throws HiveException {
            long lastProgressReport = System.currentTimeMillis();
            for (int idx = 0; idx < this.outWriters.length; ++idx) {
                if (this.outWriters[idx] == null) continue;
                try {
                    this.outWriters[idx].close(abort);
                    if (delete) {
                        fs.delete(this.outPaths[idx], true);
                    }
                    if (!this.updateProgress(lastProgressReport)) continue;
                    lastProgressReport = System.currentTimeMillis();
                    continue;
                }
                catch (IOException e) {
                    throw new HiveException(e);
                }
            }
        }
    }

    public static interface RecordWriter {
        public void write(Writable var1) throws IOException;

        public void close(boolean var1) throws IOException;
    }
}

