/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;

class UnparseTranslator {
    private final NavigableMap<Integer, Translation> translations = new TreeMap<Integer, Translation>();
    private final List<CopyTranslation> copyTranslations = new ArrayList<CopyTranslation>();
    private boolean enabled;

    void enable() {
        this.enabled = true;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void addTranslation(ASTNode node, String replacementText) {
        if (!this.enabled) {
            return;
        }
        if (node.getOrigin() != null) {
            return;
        }
        int tokenStartIndex = node.getTokenStartIndex();
        int tokenStopIndex = node.getTokenStopIndex();
        Translation translation = new Translation();
        translation.tokenStopIndex = tokenStopIndex;
        translation.replacementText = replacementText;
        assert (tokenStopIndex >= tokenStartIndex);
        Map.Entry<Integer, Translation> existingEntry = this.translations.floorEntry(tokenStartIndex);
        if (existingEntry != null) {
            if (existingEntry.getKey().equals(tokenStartIndex) && existingEntry.getValue().tokenStopIndex == tokenStopIndex && existingEntry.getValue().replacementText.equals(replacementText)) {
                return;
            }
            assert (existingEntry.getValue().tokenStopIndex < tokenStartIndex);
        }
        if ((existingEntry = this.translations.ceilingEntry(tokenStartIndex)) != null) assert (existingEntry.getKey() > tokenStopIndex);
        this.translations.put(tokenStartIndex, translation);
    }

    void addIdentifierTranslation(ASTNode identifier) {
        if (!this.enabled) {
            return;
        }
        assert (identifier.getToken().getType() == 175);
        String replacementText = identifier.getText();
        replacementText = BaseSemanticAnalyzer.unescapeIdentifier(replacementText);
        replacementText = HiveUtils.unparseIdentifier(replacementText);
        this.addTranslation(identifier, replacementText);
    }

    void addCopyTranslation(ASTNode targetNode, ASTNode sourceNode) {
        if (!this.enabled) {
            return;
        }
        if (targetNode.getOrigin() != null) {
            return;
        }
        CopyTranslation copyTranslation = new CopyTranslation();
        copyTranslation.targetNode = targetNode;
        copyTranslation.sourceNode = sourceNode;
        this.copyTranslations.add(copyTranslation);
    }

    void applyTranslations(TokenRewriteStream tokenRewriteStream) {
        for (Map.Entry entry : this.translations.entrySet()) {
            tokenRewriteStream.replace(((Integer)entry.getKey()).intValue(), ((Translation)entry.getValue()).tokenStopIndex, (Object)((Translation)entry.getValue()).replacementText);
        }
        for (CopyTranslation copyTranslation : this.copyTranslations) {
            String replacementText = tokenRewriteStream.toString(copyTranslation.sourceNode.getTokenStartIndex(), copyTranslation.sourceNode.getTokenStopIndex());
            String currentText = tokenRewriteStream.toString(copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex());
            if (currentText.equals(replacementText)) continue;
            this.addTranslation(copyTranslation.targetNode, replacementText);
            tokenRewriteStream.replace(copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex(), (Object)replacementText);
        }
    }

    private static class CopyTranslation {
        ASTNode targetNode;
        ASTNode sourceNode;

        private CopyTranslation() {
        }
    }

    private static class Translation {
        int tokenStopIndex;
        String replacementText;

        private Translation() {
        }

        public String toString() {
            return "" + this.tokenStopIndex + " -> " + this.replacementText;
        }
    }
}

