/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class ConditionalResolverMergeFiles
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Task<? extends Serializable>> getTasks(HiveConf conf, Object objCtx) {
        long avgConditionSize;
        ConditionalResolverMergeFilesCtx ctx = (ConditionalResolverMergeFilesCtx)objCtx;
        String dirName = ctx.getDir();
        ArrayList<Task<? extends Serializable>> resTsks = new ArrayList<Task<? extends Serializable>>();
        long trgtSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESSIZE);
        trgtSize = trgtSize > (avgConditionSize = conf.getLongVar(HiveConf.ConfVars.HIVEMERGEMAPFILESAVGSIZE)) ? trgtSize : avgConditionSize;
        try {
            Path dirPath = new Path(dirName);
            FileSystem inpFs = dirPath.getFileSystem((Configuration)conf);
            if (inpFs.exists(dirPath)) {
                FileStatus[] fStats = inpFs.listStatus(dirPath);
                long totalSz = 0L;
                for (FileStatus fStat : fStats) {
                    totalSz += fStat.getLen();
                }
                long currAvgSz = totalSz / (long)fStats.length;
                if (currAvgSz < avgConditionSize && fStats.length > 1) {
                    Task<? extends Serializable> tsk = ctx.getListTasks().get(1);
                    MapredWork work = (MapredWork)tsk.getWork();
                    DynamicPartitionCtx dpCtx = ctx.getDPCtx();
                    if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                        FileStatus[] status = Utilities.getFileStatusRecurse(dirPath, dpCtx.getNumDPCols(), inpFs);
                        LinkedHashMap<String, PartitionDesc> ptpi = work.getPathToPartitionInfo();
                        assert (ptpi.size() == 1);
                        String path = (String)ptpi.keySet().iterator().next();
                        TableDesc tblDesc = ((PartitionDesc)ptpi.get(path)).getTableDesc();
                        ptpi.remove(path);
                        LinkedHashMap<String, ArrayList<String>> pta = work.getPathToAliases();
                        assert (pta.size() == 1);
                        path = (String)pta.keySet().iterator().next();
                        ArrayList aliases = (ArrayList)pta.get(path);
                        pta.remove(path);
                        for (int i = 0; i < status.length; ++i) {
                            work.getPathToAliases().put(status[i].getPath().toString(), aliases);
                            LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(dpCtx.getPartSpec());
                            Warehouse.makeSpecFromName(fullPartSpec, (Path)status[i].getPath());
                            PartitionDesc pDesc = new PartitionDesc(tblDesc, fullPartSpec);
                            work.getPathToPartitionInfo().put(status[i].getPath().toString(), pDesc);
                        }
                    } else {
                        int maxReducers = conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
                        int reducers = (int)((totalSz + trgtSize - 1L) / trgtSize);
                        reducers = Math.max(1, reducers);
                        reducers = Math.min(maxReducers, reducers);
                        work.setNumReduceTasks(reducers);
                    }
                    resTsks.add(tsk);
                    return resTsks;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        resTsks.add(ctx.getListTasks().get(0));
        return resTsks;
    }

    public static class ConditionalResolverMergeFilesCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<Task<? extends Serializable>> listTasks;
        private String dir;
        private DynamicPartitionCtx dpCtx;

        public ConditionalResolverMergeFilesCtx() {
        }

        public ConditionalResolverMergeFilesCtx(List<Task<? extends Serializable>> listTasks, String dir) {
            this.listTasks = listTasks;
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public List<Task<? extends Serializable>> getListTasks() {
            return this.listTasks;
        }

        public void setListTasks(List<Task<? extends Serializable>> listTasks) {
            this.listTasks = listTasks;
        }

        public DynamicPartitionCtx getDPCtx() {
            return this.dpCtx;
        }

        public void setDPCtx(DynamicPartitionCtx dp) {
            this.dpCtx = dp;
        }
    }
}

