/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util.jdbm.recman;

import org.apache.hadoop.hive.ql.util.jdbm.recman.BlockIo;
import org.apache.hadoop.hive.ql.util.jdbm.recman.BlockView;

class FileHeader
implements BlockView {
    private static final short O_MAGIC = 0;
    private static final short O_LISTS = 2;
    private static final int O_ROOTS = 82;
    private final BlockIo block;
    static final int NROOTS = 1013;

    FileHeader(BlockIo block, boolean isNew) {
        this.block = block;
        if (isNew) {
            block.writeShort(0, (short)4944);
        } else if (!this.magicOk()) {
            throw new Error("CRITICAL: file header magic not OK " + block.readShort(0));
        }
    }

    private boolean magicOk() {
        return this.block.readShort(0) == 4944;
    }

    private short offsetOfFirst(int list) {
        return (short)(2 + 16 * list);
    }

    private short offsetOfLast(int list) {
        return (short)(this.offsetOfFirst(list) + 8);
    }

    private short offsetOfRoot(int root) {
        return (short)(82 + root * 8);
    }

    long getFirstOf(int list) {
        return this.block.readLong(this.offsetOfFirst(list));
    }

    void setFirstOf(int list, long value) {
        this.block.writeLong(this.offsetOfFirst(list), value);
    }

    long getLastOf(int list) {
        return this.block.readLong(this.offsetOfLast(list));
    }

    void setLastOf(int list, long value) {
        this.block.writeLong(this.offsetOfLast(list), value);
    }

    long getRoot(int root) {
        return this.block.readLong(this.offsetOfRoot(root));
    }

    void setRoot(int root, long rowid) {
        this.block.writeLong(this.offsetOfRoot(root), rowid);
    }
}

