/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public final class TypeInfoFactory {
    static HashMap<String, TypeInfo> cachedPrimitiveTypeInfo = new HashMap();
    public static final TypeInfo voidTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("void");
    public static final TypeInfo booleanTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("boolean");
    public static final TypeInfo intTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("int");
    public static final TypeInfo longTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("bigint");
    public static final TypeInfo stringTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("string");
    public static final TypeInfo floatTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("float");
    public static final TypeInfo doubleTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("double");
    public static final TypeInfo byteTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("tinyint");
    public static final TypeInfo shortTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("smallint");
    public static final TypeInfo unknownTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo("unknown");
    static HashMap<ArrayList<List<?>>, TypeInfo> cachedStructTypeInfo = new HashMap();
    static HashMap<TypeInfo, TypeInfo> cachedListTypeInfo = new HashMap();
    static HashMap<ArrayList<TypeInfo>, TypeInfo> cachedMapTypeInfo = new HashMap();

    private TypeInfoFactory() {
    }

    public static TypeInfo getPrimitiveTypeInfo(String typeName) {
        if (null == PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(typeName)) {
            throw new RuntimeException("Cannot getPrimitiveTypeInfo for " + typeName);
        }
        TypeInfo result = cachedPrimitiveTypeInfo.get(typeName);
        if (result == null) {
            result = new PrimitiveTypeInfo(typeName);
            cachedPrimitiveTypeInfo.put(typeName, result);
        }
        return result;
    }

    public static TypeInfo getPrimitiveTypeInfoFromPrimitiveWritable(Class<?> clazz) {
        String typeName = PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveWritable(clazz);
        if (typeName == null) {
            throw new RuntimeException("Internal error: Cannot get typeName for " + clazz);
        }
        return TypeInfoFactory.getPrimitiveTypeInfo(typeName);
    }

    public static TypeInfo getPrimitiveTypeInfoFromJavaPrimitive(Class<?> clazz) {
        return TypeInfoFactory.getPrimitiveTypeInfo(PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveJava(clazz));
    }

    public static TypeInfo getStructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(2);
        signature.add(names);
        signature.add(typeInfos);
        TypeInfo result = cachedStructTypeInfo.get(signature);
        if (result == null) {
            result = new StructTypeInfo(names, typeInfos);
            cachedStructTypeInfo.put(signature, result);
        }
        return result;
    }

    public static TypeInfo getListTypeInfo(TypeInfo elementTypeInfo) {
        TypeInfo result = cachedListTypeInfo.get(elementTypeInfo);
        if (result == null) {
            result = new ListTypeInfo(elementTypeInfo);
            cachedListTypeInfo.put(elementTypeInfo, result);
        }
        return result;
    }

    public static TypeInfo getMapTypeInfo(TypeInfo keyTypeInfo, TypeInfo valueTypeInfo) {
        ArrayList<TypeInfo> signature = new ArrayList<TypeInfo>(2);
        signature.add(keyTypeInfo);
        signature.add(valueTypeInfo);
        TypeInfo result = cachedMapTypeInfo.get(signature);
        if (result == null) {
            result = new MapTypeInfo(keyTypeInfo, valueTypeInfo);
            cachedMapTypeInfo.put(signature, result);
        }
        return result;
    }
}

