/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.MultiFileInputFormat;
import org.apache.hadoop.mapred.MultiFileSplit;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.security.UnixUserGroupInformation;
import org.apache.hadoop.security.UserGroupInformation;

public class Hadoop19Shims
implements HadoopShims {
    String[] ret = new String[2];

    @Override
    public boolean usesJobShell() {
        return true;
    }

    @Override
    public boolean fileSystemDeleteOnExit(FileSystem fs, Path path) throws IOException {
        return fs.deleteOnExit(path);
    }

    @Override
    public void inputFormatValidateInput(InputFormat fmt, JobConf conf) throws IOException {
    }

    @Override
    public boolean isJobPreparing(RunningJob job) throws IOException {
        return job.getJobState() == 4;
    }

    @Override
    public void setTmpFiles(String prop, String files) {
        Configuration conf = JobClient.getCommandLineConfig();
        if (conf != null) {
            conf.set(prop, files);
        }
    }

    @Override
    public HadoopShims.MiniDFSShim getMiniDfs(Configuration conf, int numDataNodes, boolean format, String[] racks) throws IOException {
        return new MiniDFSShim(new MiniDFSCluster(conf, numDataNodes, format, racks));
    }

    @Override
    public int compareText(Text a, Text b) {
        return a.compareTo((BinaryComparable)b);
    }

    @Override
    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new CombineFileInputFormatShim(){

            public RecordReader getRecordReader(InputSplit split, JobConf arg1, Reporter arg2) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }
        };
    }

    @Override
    public String getInputFormatClassName() {
        return "org.apache.hadoop.hive.ql.io.HiveInputFormat";
    }

    @Override
    public long getAccessTime(FileStatus file) {
        return file.getAccessTime();
    }

    @Override
    public String[] getTaskJobIDs(TaskCompletionEvent t) {
        TaskID tid = t.getTaskAttemptId().getTaskID();
        this.ret[0] = tid.toString();
        this.ret[1] = tid.getJobID().toString();
        return this.ret;
    }

    @Override
    public void setFloatConf(Configuration conf, String varName, float val) {
        conf.set(varName, Float.toString(val));
    }

    @Override
    public int createHadoopArchive(Configuration conf, Path parentDir, Path destDir, String archiveName) throws Exception {
        throw new RuntimeException("Not implemented in this Hadoop version");
    }

    @Override
    public void setNullOutputFormat(JobConf conf) {
        conf.setOutputFormat(NullOutputFormat.class);
        conf.setOutputCommitter(NullOutputCommitter.class);
        conf.setBoolean("mapred.committer.job.setup.cleanup.needed", false);
    }

    @Override
    public UserGroupInformation getUGIForConf(Configuration conf) throws LoginException {
        UnixUserGroupInformation ugi = UnixUserGroupInformation.readFromConf((Configuration)conf, (String)"hadoop.job.ugi");
        if (ugi == null) {
            ugi = UserGroupInformation.login((Configuration)conf);
        }
        return ugi;
    }

    public static class NullOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void setupTask(TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) {
            return false;
        }

        public void commitTask(TaskAttemptContext taskContext) {
        }

        public void abortTask(TaskAttemptContext taskContext) {
        }
    }

    public static class InputSplitShim
    implements HadoopShims.InputSplitShim {
        MultiFileSplit delegate;
        long[] offsets;
        JobConf job;
        String constructor = "none";

        public InputSplitShim() {
            this.delegate = new MultiFileSplit(null, new Path[0], new long[0]);
            this.onDelegateChange(this.delegate);
            this.constructor = "default";
        }

        public InputSplitShim(JobConf job, MultiFileSplit old) throws IOException {
            this.delegate = new MultiFileSplit(job, old.getPaths(), old.getLengths());
            this.offsets = new long[old.getPaths().length];
            this.job = job;
            this.constructor = "copy";
        }

        @Override
        public long[] getStartOffsets() {
            return this.offsets;
        }

        @Override
        public long getOffset(int i) {
            return 0L;
        }

        @Override
        public JobConf getJob() {
            return this.job;
        }

        @Override
        public long getLength() {
            return this.delegate.getLength();
        }

        @Override
        public long[] getLengths() {
            return this.delegate.getLengths();
        }

        @Override
        public long getLength(int i) {
            return this.delegate.getLength(i);
        }

        @Override
        public int getNumPaths() {
            return this.delegate.getNumPaths();
        }

        @Override
        public Path getPath(int i) {
            return this.delegate.getPath(i);
        }

        @Override
        public Path[] getPaths() {
            return this.delegate.getPaths();
        }

        @Override
        public String[] getLocations() throws IOException {
            return this.delegate.getLocations();
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.delegate.readFields(in);
            this.onDelegateChange(this.delegate);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this.delegate.write(out);
        }

        private void onDelegateChange(MultiFileSplit delegate) {
            if (delegate != null) {
                this.offsets = new long[delegate.getNumPaths()];
            }
        }

        private void setJob(JobConf jc) {
            this.job = jc;
        }
    }

    public static class MultiFileRecordReader<K, V>
    implements RecordReader<K, V> {
        protected InputSplitShim split;
        protected JobConf jc;
        protected Reporter reporter;
        protected Class<RecordReader<K, V>> rrClass;
        protected Constructor<RecordReader<K, V>> rrConstructor;
        protected FileSystem fs;
        protected int idx;
        protected long progress;
        protected RecordReader<K, V> curReader;
        static final Class[] constructorSignature = new Class[]{InputSplit.class, Configuration.class, Reporter.class, Integer.class};

        public boolean next(K key, V value) throws IOException {
            while (this.curReader == null || !this.curReader.next(key, value)) {
                if (this.initNextRecordReader()) continue;
                return false;
            }
            return true;
        }

        public K createKey() {
            return (K)this.curReader.createKey();
        }

        public V createValue() {
            return (V)this.curReader.createValue();
        }

        public long getPos() throws IOException {
            return this.progress;
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        public float getProgress() throws IOException {
            return Math.min(1.0f, (float)this.progress / (float)this.split.getLength());
        }

        public MultiFileRecordReader(JobConf job, InputSplitShim split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            this.split = split;
            this.jc = job;
            this.rrClass = rrClass;
            this.reporter = reporter;
            this.idx = 0;
            this.curReader = null;
            this.progress = 0L;
            try {
                this.rrConstructor = rrClass.getDeclaredConstructor(constructorSignature);
                this.rrConstructor.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(rrClass.getName() + " does not have valid constructor", e);
            }
            this.initNextRecordReader();
        }

        protected boolean initNextRecordReader() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.split.getLength(this.idx - 1);
                }
            }
            if (this.idx == this.split.getNumPaths()) {
                return false;
            }
            try {
                InputSplitShim newSplit = new InputSplitShim(this.jc, this.split.delegate);
                this.curReader = this.rrConstructor.newInstance(newSplit, this.jc, this.reporter, this.idx);
                this.jc.set("map.input.file", this.split.getPath(this.idx).toString());
                this.jc.setLong("map.input.start", 0L);
                this.jc.setLong("map.input.length", this.split.getLength(this.idx));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.idx;
            return true;
        }
    }

    public static abstract class CombineFileInputFormatShim<K, V>
    extends MultiFileInputFormat<K, V>
    implements HadoopShims.CombineFileInputFormatShim<K, V> {
        @Override
        public Path[] getInputPathsShim(JobConf conf) {
            Path[] paths;
            try {
                paths = MultiFileInputFormat.getInputPaths((JobConf)conf);
                LOG.debug((Object)("MultiFileInputFormat returned " + paths.length + " paths."));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Path[] newPaths = new Path[paths.length];
            for (int pos = 0; pos < paths.length; ++pos) {
                newPaths[pos] = new Path(paths[pos].toString().substring(5));
            }
            return newPaths;
        }

        @Override
        public void createPool(JobConf conf, PathFilter ... filters) {
            LOG.debug((Object)"createPool called.");
        }

        public InputSplitShim[] getSplits(JobConf job, int numSplits) throws IOException {
            long minSize = job.getLong("mapred.min.split.size", 0L);
            if (job.getLong("mapred.min.split.size.per.node", 0L) == 0L) {
                super.setMinSplitSize(minSize);
            }
            if (job.getLong("mapred.min.split.size.per.rack", 0L) == 0L) {
                super.setMinSplitSize(minSize);
            }
            numSplits = (int)job.getLong("mapred.multifileinputformat.splits", this.estimateNumSplits(job, numSplits));
            LOG.debug((Object)("Estimated splits (numSplits) = " + numSplits));
            MultiFileSplit[] splits = (MultiFileSplit[])super.getSplits(job, numSplits);
            LOG.debug((Object)("MultiFileSplit returned " + splits.length + " splits."));
            InputSplitShim[] isplits = new InputSplitShim[splits.length];
            for (int pos = 0; pos < splits.length; ++pos) {
                isplits[pos] = new InputSplitShim(job, splits[pos]);
            }
            return isplits;
        }

        @Override
        public InputSplitShim getInputSplitShim() throws IOException {
            return new InputSplitShim();
        }

        @Override
        public RecordReader<K, V> getRecordReader(JobConf job, HadoopShims.InputSplitShim split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            return new MultiFileRecordReader<K, V>(job, (InputSplitShim)split, reporter, rrClass);
        }

        private long estimateNumSplits(JobConf job, int numSplits) throws IOException {
            Path[] paths = FileUtil.stat2Paths((FileStatus[])this.listStatus(job));
            long blockSize = job.getLong("dfs.block.size", 0x4000000L);
            if (paths.length != 0) {
                long[] lengths = new long[paths.length];
                long totLength = 0L;
                for (int i = 0; i < paths.length; ++i) {
                    FileSystem fs = paths[i].getFileSystem((Configuration)job);
                    lengths[i] = fs.getContentSummary(paths[i]).getLength();
                    totLength += lengths[i];
                }
                numSplits = (int)Math.max((long)numSplits, (long)((int)totLength) / blockSize);
                LOG.debug((Object)("Total Length " + totLength + ", block size " + blockSize + ", number of splits: " + numSplits));
            }
            if (numSplits < 1) {
                numSplits = 1;
            }
            return numSplits;
        }
    }

    public class MiniDFSShim
    implements HadoopShims.MiniDFSShim {
        private MiniDFSCluster cluster;

        public MiniDFSShim(MiniDFSCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public FileSystem getFileSystem() throws IOException {
            return this.cluster.getFileSystem();
        }

        @Override
        public void shutdown() {
            this.cluster.shutdown();
        }
    }
}

