/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hwi;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.hwi.HWIAuth;
import org.apache.hadoop.hive.hwi.HWIException;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.history.HiveHistoryViewer;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.session.SessionState;

public class HWISessionItem
implements Runnable,
Comparable<HWISessionItem> {
    protected static final Log l4j = LogFactory.getLog((String)HWISessionItem.class.getName());
    private final String sessionName;
    private WebSessionItemStatus status;
    private CliSessionState ss;
    private String resultFile;
    private String errorFile;
    private ArrayList<ArrayList<String>> resultBucket;
    private int resultBucketMaxSize;
    private List<String> queries;
    private List<Integer> queryRet;
    private HiveConf conf;
    private HWIAuth auth;
    public Thread runnable;
    private String historyFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HWISessionItem(HWIAuth auth, String sessionName) {
        this.auth = auth;
        this.sessionName = sessionName;
        l4j.debug((Object)"HWISessionItem created");
        this.status = WebSessionItemStatus.NEW;
        this.queries = new ArrayList<String>();
        this.queryRet = new ArrayList<Integer>();
        this.resultBucket = new ArrayList();
        this.resultBucketMaxSize = 1000;
        this.runnable = new Thread(this);
        this.runnable.start();
        l4j.debug((Object)"Wait for NEW->READY transition");
        Thread thread = this.runnable;
        synchronized (thread) {
            if (this.status != WebSessionItemStatus.READY) {
                try {
                    this.runnable.wait();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        l4j.debug((Object)"NEW->READY transition complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemInit() {
        String[] parts;
        l4j.debug((Object)("HWISessionItem itemInit start " + this.getSessionName()));
        OptionsProcessor oproc = new OptionsProcessor();
        if (System.getProperty("hwi-args") == null || !oproc.process_stage1(parts = System.getProperty("hwi-args").split("\\s+"))) {
            // empty if block
        }
        SessionState.initHiveLog4j();
        this.conf = new HiveConf(SessionState.class);
        this.ss = new CliSessionState(this.conf);
        SessionState.start((SessionState)this.ss);
        this.queries.add("set hadoop.job.ugi=" + this.auth.getUser() + "," + this.auth.getGroups()[0]);
        this.queries.add("set user.name=" + this.auth.getUser());
        this.historyFile = SessionState.get().getHiveHistory().getHistFileName();
        l4j.debug((Object)("HWISessionItem itemInit Complete " + this.getSessionName()));
        this.status = WebSessionItemStatus.READY;
        Thread thread = this.runnable;
        synchronized (thread) {
            this.runnable.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientStart() throws HWIException {
        if (this.status == WebSessionItemStatus.QUERY_RUNNING) {
            throw new HWIException("Query already running");
        }
        this.status = WebSessionItemStatus.QUERY_SET;
        Thread thread = this.runnable;
        synchronized (thread) {
            this.runnable.notifyAll();
        }
        l4j.debug((Object)(this.getSessionName() + " Query is set to start"));
    }

    public void clientKill() throws HWIException {
        if (this.status != WebSessionItemStatus.QUERY_RUNNING) {
            throw new HWIException("Can not kill that which is not running.");
        }
        this.status = WebSessionItemStatus.KILL_QUERY;
        l4j.debug((Object)(this.getSessionName() + " Query is set to KILL_QUERY"));
    }

    public void clientRenew() throws HWIException {
        this.throwIfRunning();
        this.queries = new ArrayList<String>();
        this.queryRet = new ArrayList<Integer>();
        this.resultBucket = new ArrayList();
        this.resultFile = null;
        this.errorFile = null;
        this.status = WebSessionItemStatus.NEW;
        l4j.debug((Object)(this.getSessionName() + " Query is renewed to start"));
    }

    protected void killIt() {
        l4j.debug((Object)(this.getSessionName() + " Attempting kill."));
        if (this.runnable != null) {
            try {
                this.runnable.join(1000L);
                l4j.debug((Object)(this.getSessionName() + " Thread join complete"));
            }
            catch (InterruptedException e) {
                l4j.error((Object)(this.getSessionName() + " killing session caused exception "), (Throwable)e);
            }
        }
    }

    public String getHiveConfVar(HiveConf.ConfVars wanted) throws HWIException {
        String result = null;
        try {
            result = this.ss.getConf().getVar(wanted);
        }
        catch (Exception ex) {
            throw new HWIException(ex);
        }
        return result;
    }

    public String getHiveConfVar(String s) throws HWIException {
        String result = null;
        try {
            result = this.conf.get(s);
        }
        catch (Exception ex) {
            throw new HWIException(ex);
        }
        return result;
    }

    public String getJobTrackerURL(String jobid) throws HWIException {
        String jt = this.getHiveConfVar("mapred.job.tracker");
        String jth = this.getHiveConfVar("mapred.job.tracker.http.address");
        String[] jtparts = null;
        String[] jthttpParts = null;
        jtparts = jt.equalsIgnoreCase("local") ? new String[]{"local", ""} : jt.split(":");
        jthttpParts = jth.contains(":") ? jth.split(":") : new String[]{jth, ""};
        return jtparts[0] + ":" + jthttpParts[1] + "/jobdetails.jsp?jobid=" + jobid + "&refresh=30";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread thread = this.runnable;
        synchronized (thread) {
            while (this.status != WebSessionItemStatus.DESTROY) {
                if (this.status == WebSessionItemStatus.NEW) {
                    this.itemInit();
                }
                if (this.status == WebSessionItemStatus.QUERY_SET) {
                    this.runQuery();
                }
                try {
                    this.runnable.wait();
                }
                catch (InterruptedException e) {
                    l4j.error((Object)"in wait() state ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runQuery() {
        FileOutputStream fos = null;
        if (this.getResultFile() != null) {
            try {
                fos = new FileOutputStream(new File(this.resultFile));
                this.ss.out = new PrintStream((OutputStream)fos, true, "UTF-8");
            }
            catch (FileNotFoundException fex) {
                l4j.error((Object)(this.getSessionName() + " opening resultfile " + this.resultFile), (Throwable)fex);
            }
            catch (UnsupportedEncodingException uex) {
                l4j.error((Object)(this.getSessionName() + " opening resultfile " + this.resultFile), (Throwable)uex);
            }
        } else {
            l4j.debug((Object)(this.getSessionName() + " Output file was not specified"));
        }
        l4j.debug((Object)(this.getSessionName() + " state is now QUERY_RUNNING."));
        this.status = WebSessionItemStatus.QUERY_RUNNING;
        this.queryRet = new ArrayList<Integer>(this.queries.size());
        for (int i = 0; i < this.queries.size(); ++i) {
            String cmd = this.queries.get(i);
            String cmd_trimmed = cmd.trim();
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            CommandProcessor proc = CommandProcessorFactory.get((String)tokens[0]);
            if (proc != null) {
                if (proc instanceof Driver) {
                    Driver qp = (Driver)proc;
                    this.queryRet.add(new Integer(qp.run(cmd).getResponseCode()));
                    ArrayList res = new ArrayList();
                    try {
                        while (qp.getResults(res)) {
                            ArrayList resCopy = new ArrayList();
                            resCopy.addAll(res);
                            this.resultBucket.add(resCopy);
                            if (this.resultBucket.size() > this.resultBucketMaxSize) {
                                this.resultBucket.remove(0);
                            }
                            for (String row : res) {
                                if (this.ss != null) {
                                    if (this.ss.out == null) continue;
                                    this.ss.out.println(row);
                                    continue;
                                }
                                throw new RuntimeException("ss was null");
                            }
                            res.clear();
                        }
                    }
                    catch (IOException ex) {
                        l4j.error((Object)(this.getSessionName() + " getting results " + this.getResultFile() + " caused exception."), (Throwable)ex);
                    }
                    qp.close();
                    continue;
                }
                this.queryRet.add(new Integer(proc.run(cmd_1).getResponseCode()));
                continue;
            }
            l4j.error((Object)(this.getSessionName() + " query processor was not found for query " + cmd));
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException ex) {
            l4j.error((Object)(this.getSessionName() + " closing result file " + this.getResultFile() + " caused exception."), (Throwable)ex);
        }
        this.status = WebSessionItemStatus.READY;
        l4j.debug((Object)(this.getSessionName() + " state is now READY"));
        Thread thread = this.runnable;
        synchronized (thread) {
            this.runnable.notifyAll();
        }
    }

    public void setSSIsSilent(boolean silent) throws HWIException {
        if (this.ss == null) {
            throw new HWIException("Session State is null");
        }
        this.ss.setIsSilent(silent);
    }

    public boolean getSSIsSilent() throws HWIException {
        if (this.ss == null) {
            throw new HWIException("Session State is null");
        }
        return this.ss.getIsSilent();
    }

    @Override
    public int compareTo(HWISessionItem other) {
        if (other == null) {
            return -1;
        }
        return this.getSessionName().compareTo(other.getSessionName());
    }

    public HiveHistoryViewer getHistoryViewer() throws HWIException {
        if (this.ss == null) {
            throw new HWIException("Session state was null");
        }
        HiveHistoryViewer hv = new HiveHistoryViewer(this.historyFile);
        return hv;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof HWISessionItem)) {
            return false;
        }
        HWISessionItem o = (HWISessionItem)other;
        return this.getSessionName().equals(o.getSessionName());
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public void setResultFile(String resultFile) {
        this.resultFile = resultFile;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public WebSessionItemStatus getStatus() {
        return this.status;
    }

    public String getErrorFile() {
        return this.errorFile;
    }

    public void setErrorFile(String errorFile) {
        this.errorFile = errorFile;
    }

    public HWIAuth getAuth() {
        return this.auth;
    }

    protected void setAuth(HWIAuth auth) {
        this.auth = auth;
    }

    public List<String> getQueries() {
        return Collections.unmodifiableList(this.queries);
    }

    public void addQuery(String query) throws HWIException {
        this.throwIfRunning();
        this.queries.add(query);
    }

    public void removeQuery(int item) throws HWIException {
        this.throwIfRunning();
        this.queries.remove(item);
    }

    public void clearQueries() throws HWIException {
        this.throwIfRunning();
        this.queries.clear();
    }

    public int getResultBucketMaxSize() {
        return this.resultBucketMaxSize;
    }

    public void setResultBucketMaxSize(int size) {
        this.resultBucketMaxSize = size;
    }

    public ArrayList<ArrayList<String>> getResultBucket() {
        return this.resultBucket;
    }

    public List<Integer> getQueryRet() {
        return Collections.unmodifiableList(this.queryRet);
    }

    private void throwIfRunning() throws HWIException {
        if (this.status == WebSessionItemStatus.QUERY_RUNNING) {
            throw new HWIException("Query already running");
        }
    }

    public static enum WebSessionItemStatus {
        NEW,
        READY,
        QUERY_SET,
        QUERY_RUNNING,
        DESTROY,
        KILL_QUERY;

    }
}

