/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.BatchOperation;
import org.apache.hadoop.hbase.io.BatchUpdate;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Progressable;

public class HiveHBaseTableOutputFormat
extends TableOutputFormat
implements HiveOutputFormat<ImmutableBytesWritable, BatchUpdate> {
    private final ImmutableBytesWritable key = new ImmutableBytesWritable();

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
        String hbaseTableName = jc.get("hbase.table.name");
        jc.set("hbase.mapred.outputtable", hbaseTableName);
        boolean walEnabled = HiveConf.getBoolVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_WAL_ENABLED);
        HTable table = new HTable(new HBaseConfiguration((Configuration)jc), hbaseTableName);
        table.setAutoFlush(false);
        return new HiveHBaseRecordWriter(table, walEnabled);
    }

    private static class HiveHBaseRecordWriter
    implements FileSinkOperator.RecordWriter {
        private HTable table;
        private boolean walEnabled;

        HiveHBaseRecordWriter(HTable table, boolean walEnabled) {
            this.table = table;
            this.walEnabled = walEnabled;
        }

        public void close(boolean abort) throws IOException {
            if (!abort) {
                this.table.flushCommits();
            }
        }

        public void write(Writable w) throws IOException {
            BatchUpdate batchUpdate = (BatchUpdate)w;
            for (BatchOperation bo : batchUpdate) {
                assert (bo.isPut());
                Put p = new Put(batchUpdate.getRow(), null);
                if (!this.walEnabled) {
                    p.setWriteToWAL(false);
                }
                p.add(bo.getColumn(), batchUpdate.getTimestamp(), bo.getValue());
                this.table.put(p);
            }
        }
    }
}

