/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.createTableDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.ql.plan.reduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class PlanUtils {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.plan.PlanUtils");

    public static mapredWork getMapRedWork() {
        return new mapredWork("", new LinkedHashMap<String, ArrayList<String>>(), new LinkedHashMap<String, partitionDesc>(), new LinkedHashMap<String, Operator<? extends Serializable>>(), new tableDesc(), new ArrayList<tableDesc>(), null, 1, null);
    }

    public static tableDesc getDefaultTableDesc(String separatorCode, String columns) {
        return PlanUtils.getDefaultTableDesc(separatorCode, columns, false);
    }

    public static tableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, false);
    }

    public static tableDesc getDefaultTableDesc(String separatorCode, String columns, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getDefaultTableDesc(separatorCode, columns, null, lastColumnTakesRestOfTheLine);
    }

    public static tableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, null, lastColumnTakesRestOfTheLine);
    }

    public static tableDesc getDefaultTableDesc(String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(LazySimpleSerDe.class, separatorCode, columns, columnTypes, lastColumnTakesRestOfTheLine);
    }

    public static tableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine) {
        return PlanUtils.getTableDesc(serdeClass, separatorCode, columns, columnTypes, lastColumnTakesRestOfTheLine, false);
    }

    public static tableDesc getTableDesc(Class<? extends Deserializer> serdeClass, String separatorCode, String columns, String columnTypes, boolean lastColumnTakesRestOfTheLine, boolean useJSONForLazy) {
        Properties properties = Utilities.makeProperties("serialization.format", separatorCode, "columns", columns);
        if (!separatorCode.equals(Integer.toString(1))) {
            properties.setProperty("field.delim", separatorCode);
        }
        if (columnTypes != null) {
            properties.setProperty("columns.types", columnTypes);
        }
        if (lastColumnTakesRestOfTheLine) {
            properties.setProperty("serialization.last.column.takes.rest", "true");
        }
        if (useJSONForLazy) {
            properties.setProperty("serialization.use.json.object", "true");
        }
        return new tableDesc(serdeClass, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, properties);
    }

    public static tableDesc getTableDesc(createTableDesc crtTblDesc, String cols, String colTypes) {
        tableDesc ret;
        Class serdeClass = LazySimpleSerDe.class;
        String separatorCode = Integer.toString(1);
        String columns = cols;
        String columnTypes = colTypes;
        boolean lastColumnTakesRestOfTheLine = false;
        try {
            if (crtTblDesc.getSerName() != null) {
                Class<?> c = Class.forName(crtTblDesc.getSerName());
                serdeClass = c;
            }
            if (crtTblDesc.getFieldDelim() != null) {
                separatorCode = crtTblDesc.getFieldDelim();
            }
            ret = PlanUtils.getTableDesc(serdeClass, separatorCode, columns, columnTypes, lastColumnTakesRestOfTheLine, false);
            Properties properties = ret.getProperties();
            if (crtTblDesc.getCollItemDelim() != null) {
                properties.setProperty("colelction.delim", crtTblDesc.getCollItemDelim());
            }
            if (crtTblDesc.getMapKeyDelim() != null) {
                properties.setProperty("mapkey.delim", crtTblDesc.getMapKeyDelim());
            }
            if (crtTblDesc.getFieldEscape() != null) {
                properties.setProperty("escape.delim", crtTblDesc.getFieldEscape());
            }
            if (crtTblDesc.getLineDelim() != null) {
                properties.setProperty("line.delim", crtTblDesc.getLineDelim());
            }
            Class<?> c1 = Class.forName(crtTblDesc.getInputFormat());
            Class<?> c2 = Class.forName(crtTblDesc.getOutputFormat());
            Class<?> in_class = c1;
            Class<?> out_class = c2;
            ret.setInputFileFormatClass(in_class);
            ret.setOutputFileFormatClass(out_class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return ret;
    }

    public static tableDesc getDefaultTableDesc(String separatorCode) {
        return new tableDesc(MetadataTypedColumnsetSerDe.class, TextInputFormat.class, IgnoreKeyTextOutputFormat.class, Utilities.makeProperties("serialization.format", separatorCode));
    }

    public static tableDesc getReduceKeyTableDesc(List<FieldSchema> fieldSchemas, String order) {
        return new tableDesc(BinarySortableSerDe.class, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "serialization.sort.order", order));
    }

    public static tableDesc getMapJoinKeyTableDesc(List<FieldSchema> fieldSchemas) {
        return new tableDesc(LazyBinarySerDe.class, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\"));
    }

    public static tableDesc getMapJoinValueTableDesc(List<FieldSchema> fieldSchemas) {
        return new tableDesc(LazyBinarySerDe.class, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\"));
    }

    public static tableDesc getIntermediateFileTableDesc(List<FieldSchema> fieldSchemas) {
        return new tableDesc(LazyBinarySerDe.class, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\"));
    }

    public static tableDesc getReduceValueTableDesc(List<FieldSchema> fieldSchemas) {
        return new tableDesc(LazyBinarySerDe.class, SequenceFileInputFormat.class, SequenceFileOutputFormat.class, Utilities.makeProperties("columns", MetaStoreUtils.getColumnNamesFromFieldSchema(fieldSchemas), "columns.types", MetaStoreUtils.getColumnTypesFromFieldSchema(fieldSchemas), "escape.delim", "\\"));
    }

    public static List<FieldSchema> getFieldSchemasFromColumnList(List<exprNodeDesc> cols, List<String> outputColumnNames, int start, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + outputColumnNames.get(i + start)), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromColumnList(List<exprNodeDesc> cols, String fieldPrefix) {
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)(fieldPrefix + i), (TypeInfo)cols.get(i).getTypeInfo()));
        }
        return schemas;
    }

    public static List<FieldSchema> getFieldSchemasFromRowSchema(RowSchema row, String fieldPrefix) {
        Vector<ColumnInfo> c = row.getSignature();
        return PlanUtils.getFieldSchemasFromColumnInfo(c, fieldPrefix);
    }

    public static List<FieldSchema> getFieldSchemasFromColumnInfo(Vector<ColumnInfo> cols, String fieldPrefix) {
        if (cols == null || cols.size() == 0) {
            return new ArrayList<FieldSchema>();
        }
        ArrayList<FieldSchema> schemas = new ArrayList<FieldSchema>(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            String name = cols.get(i).getInternalName();
            if (name.equals(Integer.valueOf(i).toString())) {
                name = fieldPrefix + name;
            }
            schemas.add(MetaStoreUtils.getFieldSchemaFromTypeInfo((String)name, (TypeInfo)cols.get(i).getType()));
        }
        return schemas;
    }

    public static List<FieldSchema> sortFieldSchemas(List<FieldSchema> schema) {
        Collections.sort(schema, new Comparator<FieldSchema>(){

            @Override
            public int compare(FieldSchema o1, FieldSchema o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return schema;
    }

    public static reduceSinkDesc getReduceSinkDesc(ArrayList<exprNodeDesc> keyCols, ArrayList<exprNodeDesc> valueCols, List<String> outputColumnNames, boolean includeKeyCols, int tag, ArrayList<exprNodeDesc> partitionCols, String order, int numReducers) {
        tableDesc keyTable = null;
        tableDesc valueTable = null;
        ArrayList<String> outputKeyCols = new ArrayList<String>();
        ArrayList<String> outputValCols = new ArrayList<String>();
        if (includeKeyCols) {
            keyTable = PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, outputColumnNames, 0, ""), order);
            outputKeyCols.addAll(outputColumnNames.subList(0, keyCols.size()));
            valueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, outputColumnNames, keyCols.size(), ""));
            outputValCols.addAll(outputColumnNames.subList(keyCols.size(), outputColumnNames.size()));
        } else {
            keyTable = PlanUtils.getReduceKeyTableDesc(PlanUtils.getFieldSchemasFromColumnList(keyCols, "reducesinkkey"), order);
            for (int i = 0; i < keyCols.size(); ++i) {
                outputKeyCols.add("reducesinkkey" + i);
            }
            valueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, outputColumnNames, 0, ""));
            outputValCols.addAll(outputColumnNames);
        }
        return new reduceSinkDesc(keyCols, valueCols, outputKeyCols, outputValCols, tag, partitionCols, numReducers, keyTable, valueTable);
    }

    public static reduceSinkDesc getReduceSinkDesc(ArrayList<exprNodeDesc> keyCols, ArrayList<exprNodeDesc> valueCols, List<String> outputColumnNames, boolean includeKey, int tag, int numPartitionFields, int numReducers) {
        ArrayList<exprNodeDesc> partitionCols = null;
        if (numPartitionFields >= keyCols.size()) {
            partitionCols = keyCols;
        } else if (numPartitionFields >= 0) {
            partitionCols = new ArrayList(numPartitionFields);
            for (int i = 0; i < numPartitionFields; ++i) {
                partitionCols.add(keyCols.get(i));
            }
        } else {
            partitionCols = new ArrayList(1);
            partitionCols.add(TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("rand", new exprNodeDesc[0]));
        }
        StringBuilder order = new StringBuilder();
        for (int i = 0; i < keyCols.size(); ++i) {
            order.append("+");
        }
        return PlanUtils.getReduceSinkDesc(keyCols, valueCols, outputColumnNames, includeKey, tag, partitionCols, order.toString(), numReducers);
    }

    public static enum ExpressionTypes {
        FIELD,
        JEXL;

    }
}

