/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ppd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.ppd.OpProcFactory;
import org.apache.hadoop.hive.ql.ppd.OpWalkerInfo;

public class PredicatePushDown
implements Transform {
    private ParseContext pGraphContext;
    private HashMap<Operator<? extends Serializable>, OpParseContext> opToParseCtxMap;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pGraphContext = pctx;
        this.opToParseCtxMap = this.pGraphContext.getOpParseCtx();
        OpWalkerInfo opWalkerInfo = new OpWalkerInfo(this.opToParseCtxMap);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "FIL%"), OpProcFactory.getFilterProc());
        opRules.put(new RuleRegExp("R3", "JOIN%"), OpProcFactory.getJoinProc());
        opRules.put(new RuleRegExp("R4", "RS%"), OpProcFactory.getRSProc());
        opRules.put(new RuleRegExp("R5", "TS%"), OpProcFactory.getTSProc());
        opRules.put(new RuleRegExp("R6", "SCR%"), OpProcFactory.getSCRProc());
        opRules.put(new RuleRegExp("R6", "LIM%"), OpProcFactory.getLIMProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(OpProcFactory.getDefaultProc(), opRules, opWalkerInfo);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return this.pGraphContext;
    }
}

