/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@description(name="log2", value="_FUNC_(x) - Returns the logarithm of x with base 2", extended="Example:\n  > SELECT _FUNC_(2) FROM src LIMIT 1;\n  1")
public class UDFLog2
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFLog2.class.getName());
    private static double log2 = Math.log(2.0);
    DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null || a.get() <= 0.0) {
            return null;
        }
        this.result.set(Math.log(a.get()) / log2);
        return this.result;
    }
}

