/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PropertyMetaData;

public class AbstractConstraintMetaData
extends MetaData {
    protected String name;
    protected String table;
    protected AbstractMemberMetaData[] memberMetaData;
    protected ColumnMetaData[] columnMetaData;
    protected List<AbstractMemberMetaData> members = new ArrayList<AbstractMemberMetaData>();
    protected List<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();

    public void initialise(ClassLoaderResolver clr, MetaDataManager mmgr) {
        int i;
        if (this.isInitialised()) {
            return;
        }
        if (this.members.size() == 0) {
            this.memberMetaData = null;
        } else {
            this.memberMetaData = new AbstractMemberMetaData[this.members.size()];
            for (i = 0; i < this.memberMetaData.length; ++i) {
                this.memberMetaData[i] = this.members.get(i);
                this.memberMetaData[i].initialise(clr, mmgr);
            }
        }
        if (this.columns.size() == 0) {
            this.columnMetaData = null;
        } else {
            this.columnMetaData = new ColumnMetaData[this.columns.size()];
            for (i = 0; i < this.columnMetaData.length; ++i) {
                this.columnMetaData[i] = this.columns.get(i);
                this.columnMetaData[i].initialise(clr, mmgr);
            }
        }
        this.members.clear();
        this.members = null;
        this.columns.clear();
        this.columns = null;
        this.setInitialised();
    }

    public void addMember(AbstractMemberMetaData mmd) {
        this.members.add(mmd);
        mmd.parent = this;
    }

    public FieldMetaData newFieldMetaData(String name) {
        FieldMetaData fmd = new FieldMetaData((MetaData)this, name);
        this.addMember(fmd);
        return fmd;
    }

    public PropertyMetaData newPropertyMetaData(String name) {
        PropertyMetaData pmd = new PropertyMetaData((MetaData)this, name);
        this.addMember(pmd);
        return pmd;
    }

    public void addColumn(ColumnMetaData colmd) {
        this.columns.add(colmd);
        colmd.parent = this;
    }

    public ColumnMetaData newColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addColumn(colmd);
        return colmd;
    }

    public final AbstractMemberMetaData[] getMemberMetaData() {
        return this.memberMetaData;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columnMetaData;
    }

    public int getNumberOfMembers() {
        if (this.members != null) {
            return this.members.size();
        }
        if (this.memberMetaData != null) {
            return this.memberMetaData.length;
        }
        return 0;
    }

    public int getNumberOfColumns() {
        if (this.columns != null) {
            return this.columns.size();
        }
        if (this.columnMetaData != null) {
            return this.columnMetaData.length;
        }
        return 0;
    }
}

