/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.SQLException;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.AbstractSchemaTransaction;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ValidateTableSchemaTransaction
extends AbstractSchemaTransaction {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected TableImpl table;

    public ValidateTableSchemaTransaction(RDBMSStoreManager rdbmsMgr, int isolationLevel, TableImpl table) {
        super(rdbmsMgr, isolationLevel);
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ClassLoaderResolver clr) throws SQLException {
        RDBMSStoreManager rDBMSStoreManager = this.rdbmsMgr;
        synchronized (rDBMSStoreManager) {
            ArrayList autoCreateErrors = new ArrayList();
            try {
                this.table.validate(this.getCurrentConnection(), false, true, autoCreateErrors);
            }
            catch (Exception e) {
                NucleusLogger.DATASTORE_SCHEMA.error((Object)("Exception thrown during update of schema for table " + this.table), (Throwable)e);
                throw new NucleusException("Exception thrown during update of schema for table " + this.table, (Throwable)e);
            }
        }
    }

    public String toString() {
        return LOCALISER.msg("050048", (Object)this.table, (Object)this.rdbmsMgr.getCatalogName(), (Object)this.rdbmsMgr.getSchemaName());
    }
}

