/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import jline.SimpleCompletor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;

public class CliDriver {
    public static final String prompt = "hive";
    public static final String prompt2 = "    ";
    public static final String HIVERCFILE = ".hiverc";
    private final SessionState.LogHelper console;
    private final Configuration conf;

    public CliDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new Configuration();
        Log LOG = LogFactory.getLog((String)"CliDriver");
        this.console = new SessionState.LogHelper(LOG);
    }

    public int processCmd(String cmd) {
        SessionState ss = SessionState.get();
        String cmd_trimmed = cmd.trim();
        String[] tokens = cmd_trimmed.split("\\s+");
        String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
        int ret = 0;
        if (cmd_trimmed.toLowerCase().equals("quit") || cmd_trimmed.toLowerCase().equals("exit")) {
            System.exit(0);
        } else if (tokens[0].equalsIgnoreCase("source")) {
            File sourceFile = new File(cmd_1);
            if (!sourceFile.isFile()) {
                this.console.printError("File: " + cmd_1 + " is not a file.");
                ret = 1;
            } else {
                try {
                    this.processFile(cmd_1);
                }
                catch (IOException e) {
                    this.console.printError("Failed processing file " + cmd_1 + " " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                    ret = 1;
                }
            }
        } else if (cmd_trimmed.startsWith("!")) {
            String shell_cmd = cmd_trimmed.substring(1);
            try {
                Process executor = Runtime.getRuntime().exec(shell_cmd);
                Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(executor.getInputStream(), null, ss.out);
                Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(executor.getErrorStream(), null, ss.err);
                outPrinter.start();
                errPrinter.start();
                ret = executor.waitFor();
                if (ret != 0) {
                    this.console.printError("Command failed with exit code = " + ret);
                }
            }
            catch (Exception e) {
                this.console.printError("Exception raised from Shell command " + e.getLocalizedMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                ret = 1;
            }
        } else if (tokens[0].toLowerCase().equals("list")) {
            SessionState.ResourceType t;
            if (tokens.length < 2 || (t = SessionState.find_resource_type((String)tokens[1])) == null) {
                this.console.printError("Usage: list [" + StringUtils.join((Object[])SessionState.ResourceType.values(), (String)"|") + "] [<value> [<value>]*]");
                ret = 1;
            } else {
                Set s;
                List<String> filter = null;
                if (tokens.length >= 3) {
                    System.arraycopy(tokens, 2, tokens, 0, tokens.length - 2);
                    filter = Arrays.asList(tokens);
                }
                if ((s = ss.list_resource(t, filter)) != null && !s.isEmpty()) {
                    ss.out.println(StringUtils.join((Collection)s, (String)"\n"));
                }
            }
        } else {
            CommandProcessor proc = CommandProcessorFactory.get((String)tokens[0], (HiveConf)((HiveConf)this.conf));
            if (proc != null) {
                if (proc instanceof Driver) {
                    long end;
                    Driver qp = (Driver)proc;
                    PrintStream out = ss.out;
                    long start = System.currentTimeMillis();
                    if (ss.getIsVerbose()) {
                        out.println(cmd);
                    }
                    if ((ret = qp.run(cmd).getResponseCode()) != 0) {
                        qp.close();
                        return ret;
                    }
                    ArrayList res = new ArrayList();
                    if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER)) {
                        boolean first_col = true;
                        Schema sc = qp.getSchema();
                        for (FieldSchema fs : sc.getFieldSchemas()) {
                            if (!first_col) {
                                out.print('\t');
                            }
                            out.print(fs.getName());
                            first_col = false;
                        }
                        out.println();
                    }
                    try {
                        while (qp.getResults(res)) {
                            for (String r : res) {
                                out.println(r);
                            }
                            res.clear();
                            if (!out.checkError()) continue;
                            break;
                        }
                    }
                    catch (IOException e) {
                        this.console.printError("Failed with exception " + e.getClass().getName() + ":" + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                        ret = 1;
                    }
                    int cret = qp.close();
                    if (ret == 0) {
                        ret = cret;
                    }
                    if ((end = System.currentTimeMillis()) > start) {
                        double timeTaken = (double)(end - start) / 1000.0;
                        this.console.printInfo("Time taken: " + timeTaken + " seconds", null);
                    }
                } else {
                    if (ss.getIsVerbose()) {
                        ss.out.println(tokens[0] + " " + cmd_1);
                    }
                    ret = proc.run(cmd_1).getResponseCode();
                }
            }
        }
        return ret;
    }

    public int processLine(String line) {
        int lastRet = 0;
        int ret = 0;
        String command = "";
        for (String oneCmd : line.split(";")) {
            if (StringUtils.endsWith((String)oneCmd, (String)"\\")) {
                command = command + StringUtils.chop((String)oneCmd) + ";";
                continue;
            }
            if (StringUtils.isBlank((String)(command = command + oneCmd))) continue;
            ret = this.processCmd(command);
            command = "";
            lastRet = ret;
            boolean ignoreErrors = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
            if (ret == 0 || ignoreErrors) continue;
            CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf));
            return ret;
        }
        CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf));
        return lastRet;
    }

    public int processReader(BufferedReader r) throws IOException {
        String line;
        StringBuilder qsb = new StringBuilder();
        while ((line = r.readLine()) != null) {
            qsb.append(line + "\n");
        }
        return this.processLine(qsb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processFile(String fileName) throws IOException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(fileName);
            int n = this.processReader(new BufferedReader(fileReader));
            return n;
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }

    public void processInitFiles(CliSessionState ss) throws IOException {
        boolean saveSilent = ss.getIsSilent();
        ss.setIsSilent(true);
        for (String initFile : ss.initFiles) {
            int rc = this.processFile(initFile);
            if (rc == 0) continue;
            System.exit(rc);
        }
        if (ss.initFiles.size() == 0) {
            String hivercUser;
            int rc;
            String hivercDefault;
            if (System.getenv("HIVE_HOME") != null && new File(hivercDefault = System.getenv("HIVE_HOME") + File.separator + "bin" + File.separator + HIVERCFILE).exists() && (rc = this.processFile(hivercDefault)) != 0) {
                System.exit(rc);
            }
            if (System.getProperty("user.home") != null && new File(hivercUser = System.getProperty("user.home") + File.separator + HIVERCFILE).exists() && (rc = this.processFile(hivercUser)) != 0) {
                System.exit(rc);
            }
        }
        ss.setIsSilent(saveSilent);
    }

    public static Completor getCommandCompletor() {
        SimpleCompletor sc = new SimpleCompletor(new String[0]);
        for (String s : FunctionRegistry.getFunctionNames()) {
            if (s.matches("[a-z_]+")) {
                sc.addCandidateString(s + "(");
                continue;
            }
            sc.addCandidateString(s);
        }
        for (String s : ParseDriver.getKeywords()) {
            sc.addCandidateString(s);
            sc.addCandidateString(s.toLowerCase());
        }
        ArgumentCompletor.AbstractArgumentDelimiter delim = new ArgumentCompletor.AbstractArgumentDelimiter(){

            public boolean isDelimiterChar(String buffer, int pos) {
                char c = buffer.charAt(pos);
                return Character.isWhitespace(c) || c == '(' || c == ')' || c == '[' || c == ']';
            }
        };
        final ArgumentCompletor ac = new ArgumentCompletor((Completor)sc, (ArgumentCompletor.ArgumentDelimiter)delim);
        ac.setStrict(false);
        Completor completor = new Completor(){

            public int complete(String buffer, int offset, List completions) {
                List comp = completions;
                int ret = ac.complete(buffer, offset, completions);
                if (completions.size() == 1 && ((String)comp.get(0)).endsWith("( ")) {
                    comp.set(0, ((String)comp.get(0)).trim());
                }
                return ret;
            }
        };
        return completor;
    }

    public static void main(String[] args) throws Exception {
        String line;
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            System.exit(1);
        }
        SessionState.initHiveLog4j();
        CliSessionState ss = new CliSessionState(new HiveConf(SessionState.class));
        ss.in = System.in;
        try {
            ss.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            ss.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.exit(3);
        }
        if (!oproc.process_stage2(ss)) {
            System.exit(2);
        }
        HiveConf conf = ss.getConf();
        for (Map.Entry<Object, Object> item : ss.cmdProperties.entrySet()) {
            conf.set((String)item.getKey(), (String)item.getValue());
        }
        if (!ShimLoader.getHadoopShims().usesJobShell()) {
            ClassLoader loader = conf.getClassLoader();
            String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
            if (StringUtils.isNotBlank((String)auxJars)) {
                loader = Utilities.addToClassPath((ClassLoader)loader, (String[])StringUtils.split((String)auxJars, (String)","));
            }
            conf.setClassLoader(loader);
            Thread.currentThread().setContextClassLoader(loader);
        }
        SessionState.start((SessionState)ss);
        CliDriver cli = new CliDriver();
        cli.processInitFiles(ss);
        if (ss.execString != null) {
            System.exit(cli.processLine(ss.execString));
        }
        try {
            if (ss.fileName != null) {
                System.exit(cli.processFile(ss.fileName));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open input file for reading. (" + e.getMessage() + ")");
            System.exit(3);
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        reader.addCompletor(CliDriver.getCommandCompletor());
        String HISTORYFILE = ".hivehistory";
        String historyFile = System.getProperty("user.home") + File.separator + ".hivehistory";
        reader.setHistory(new History(new File(historyFile)));
        int ret = 0;
        String prefix = "";
        String curPrompt = prompt;
        while ((line = reader.readLine(curPrompt + "> ")) != null) {
            if (!prefix.equals("")) {
                prefix = prefix + '\n';
            }
            if (line.trim().endsWith(";") && !line.trim().endsWith("\\;")) {
                line = prefix + line;
                ret = cli.processLine(line);
                prefix = "";
                curPrompt = prompt;
                continue;
            }
            prefix = prefix + line;
            curPrompt = prompt2;
        }
        System.exit(ret);
    }
}

