/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Stat;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.JobConf;

public class TableScanOperator
extends Operator<TableScanDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient JobConf jc;
    private transient Configuration hconf;
    private transient Stat stat;
    private transient String partitionSpecs;
    private transient boolean inputFileChanged = false;
    private TableDesc tableDesc;
    ArrayList<Integer> neededColumnIDs;

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public void setTableDesc(TableDesc tableDesc) {
        this.tableDesc = tableDesc;
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats()) {
            this.gatherStats(row);
        }
        this.forward(row, this.inputObjInspectors[tag]);
    }

    @Override
    public void cleanUpInputFileChangedOp() throws HiveException {
        this.inputFileChanged = true;
    }

    private void gatherStats(Object row) {
        if (this.stat == null || this.inputFileChanged) {
            this.inputFileChanged = false;
            this.stat = new Stat();
            if (((TableScanDesc)this.conf).getPartColumns() == null || ((TableScanDesc)this.conf).getPartColumns().size() == 0) {
                this.partitionSpecs = "";
            } else {
                assert (this.inputObjInspectors[0].getCategory() == ObjectInspector.Category.STRUCT) : "input object inspector is not struct";
                ArrayList<Object> writable = new ArrayList<Object>(((TableScanDesc)this.conf).getPartColumns().size());
                ArrayList<String> values = new ArrayList<String>(((TableScanDesc)this.conf).getPartColumns().size());
                int dpStartCol = 0;
                StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[0];
                for (StructField structField : soi.getAllStructFieldRefs()) {
                    String fn = structField.getFieldName();
                    if (((TableScanDesc)this.conf).getPartColumns().contains(fn)) break;
                    ++dpStartCol;
                }
                ObjectInspectorUtils.partialCopyToStandardObject(writable, row, dpStartCol, ((TableScanDesc)this.conf).getPartColumns().size(), (StructObjectInspector)this.inputObjInspectors[0], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                for (StructField structField : writable) {
                    assert (structField != null && structField.toString().length() > 0);
                    values.add(structField.toString());
                }
                this.partitionSpecs = FileUtils.makePartName(((TableScanDesc)this.conf).getPartColumns(), values);
                this.LOG.info((Object)("Stats Gathering found a new partition spec = " + this.partitionSpecs));
            }
        }
        this.stat.increaseNumRows(1L);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.initializeChildren(hconf);
        this.inputFileChanged = false;
        if (this.conf == null) {
            return;
        }
        if (!((TableScanDesc)this.conf).isGatherStats()) {
            return;
        }
        this.hconf = hconf;
        this.jc = hconf instanceof JobConf ? (JobConf)hconf : new JobConf(hconf, ExecDriver.class);
        this.stat = null;
        this.partitionSpecs = null;
        if (((TableScanDesc)this.conf).getPartColumns() == null || ((TableScanDesc)this.conf).getPartColumns().size() == 0) {
            return;
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        if (this.conf != null && ((TableScanDesc)this.conf).isGatherStats() && this.stat != null) {
            this.publishStats();
        }
    }

    @Override
    public String getName() {
        return new String("TS");
    }

    public void setNeededColumnIDs(ArrayList<Integer> orign_columns) {
        this.neededColumnIDs = orign_columns;
    }

    public ArrayList<Integer> getNeededColumnIDs() {
        return this.neededColumnIDs;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.TABLESCAN;
    }

    private void publishStats() {
        StatsPublisher statsPublisher = Utilities.getStatsPublisher(this.jc);
        if (!statsPublisher.connect((Configuration)this.jc)) {
            this.LOG.info((Object)"StatsPublishing error: cannot connect to database.");
            return;
        }
        String taskID = Utilities.getTaskIdFromFilename(Utilities.getTaskId(this.hconf));
        String key = this.partitionSpecs.isEmpty() ? ((TableScanDesc)this.conf).getStatsAggPrefix() + taskID : ((TableScanDesc)this.conf).getStatsAggPrefix() + this.partitionSpecs + "/" + taskID;
        statsPublisher.publishStat(key, "numRows", Long.toString(this.stat.getNumRows()));
        statsPublisher.closeConnection();
    }
}

