/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.thrift.TException;

public class Hive {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.metadata.Hive");
    private HiveConf conf = null;
    private IMetaStoreClient metaStoreClient;
    private String currentDatabase;
    private static ThreadLocal<Hive> hiveDB = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return null;
        }

        @Override
        public synchronized void remove() {
            if (this.get() != null) {
                ((Hive)this.get()).close();
            }
            super.remove();
        }
    };

    public static Hive get(HiveConf c) throws HiveException {
        boolean needsRefresh = false;
        Hive db = hiveDB.get();
        if (db != null) {
            for (HiveConf.ConfVars oneVar : HiveConf.metaVars) {
                String newVar;
                String oldVar = db.getConf().get(oneVar.varname, "");
                if (oldVar.compareToIgnoreCase(newVar = c.get(oneVar.varname, "")) == 0) continue;
                needsRefresh = true;
                break;
            }
        }
        return Hive.get(c, needsRefresh);
    }

    public static Hive get(HiveConf c, boolean needsRefresh) throws HiveException {
        Hive db = hiveDB.get();
        if (db == null || needsRefresh) {
            Hive.closeCurrent();
            c.set("fs.scheme.class", "dfs");
            db = new Hive(c);
            hiveDB.set(db);
        }
        return db;
    }

    public static Hive get() throws HiveException {
        Hive db = hiveDB.get();
        if (db == null) {
            db = new Hive(new HiveConf(Hive.class));
            hiveDB.set(db);
        }
        return db;
    }

    public static void closeCurrent() {
        hiveDB.remove();
    }

    private Hive(HiveConf c) throws HiveException {
        this.conf = c;
    }

    private void close() {
        LOG.info((Object)"Closing current thread's connection to Hive Metastore.");
        if (this.metaStoreClient != null) {
            this.metaStoreClient.close();
        }
    }

    public void createDatabase(Database db, boolean ifNotExist) throws AlreadyExistsException, HiveException {
        try {
            this.getMSC().createDatabase(db);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExist) {
                throw e;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createDatabase(Database db) throws AlreadyExistsException, HiveException {
        this.createDatabase(db, false);
    }

    public void dropDatabase(String name) throws HiveException, NoSuchObjectException {
        this.dropDatabase(name, true, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws HiveException, NoSuchObjectException {
        try {
            this.getMSC().dropDatabase(name, deleteData, ignoreUnknownDb);
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat) throws HiveException {
        this.createTable(tableName, columns, partCols, fileInputFormat, fileOutputFormat, -1, null);
    }

    public void createTable(String tableName, List<String> columns, List<String> partCols, Class<? extends InputFormat> fileInputFormat, Class<?> fileOutputFormat, int bucketCount, List<String> bucketCols) throws HiveException {
        if (columns == null) {
            throw new HiveException("columns not specified for table " + tableName);
        }
        Table tbl = new Table(this.getCurrentDatabase(), tableName);
        tbl.setInputFormatClass(fileInputFormat.getName());
        tbl.setOutputFormatClass(fileOutputFormat.getName());
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "default");
            tbl.getCols().add(field);
        }
        if (partCols != null) {
            for (String partCol : partCols) {
                FieldSchema part = new FieldSchema();
                part.setName(partCol);
                part.setType("string");
                tbl.getPartCols().add(part);
            }
        }
        tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        tbl.setNumBuckets(bucketCount);
        tbl.setBucketCols(bucketCols);
        this.createTable(tbl);
    }

    public void alterTable(String tblName, Table newTbl) throws InvalidOperationException, HiveException {
        try {
            if (newTbl.getParameters() != null) {
                newTbl.getParameters().remove("transient_lastDdlTime");
            }
            this.getMSC().alter_table(this.getCurrentDatabase(), tblName, newTbl.getTTable());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter table.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter table.", e);
        }
    }

    public void alterIndex(String dbName, String baseTblName, String idxName, Index newIdx) throws InvalidOperationException, HiveException {
        try {
            this.getMSC().alter_index(dbName, baseTblName, idxName, newIdx);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter index.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter index.", e);
        }
    }

    public void alterPartition(String tblName, Partition newPart) throws InvalidOperationException, HiveException {
        try {
            if (newPart.getParameters() != null) {
                newPart.getParameters().remove("transient_lastDdlTime");
            }
            this.getMSC().alter_partition(this.getCurrentDatabase(), tblName, newPart.getTPartition());
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter partition.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter partition.", e);
        }
    }

    public void alterDatabase(String dbName, Database db) throws HiveException {
        try {
            this.getMSC().alterDatabase(dbName, db);
        }
        catch (MetaException e) {
            throw new HiveException("Unable to alter database " + dbName, e);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Database " + dbName + " does not exists.", e);
        }
        catch (TException e) {
            throw new HiveException("Unable to alter database " + dbName, e);
        }
    }

    public void createTable(Table tbl) throws HiveException {
        this.createTable(tbl, false);
    }

    public void createTable(Table tbl, boolean ifNotExists) throws HiveException {
        try {
            CreateTableAutomaticGrant grants;
            if (tbl.getDbName() == null || "".equals(tbl.getDbName().trim())) {
                tbl.setDbName(this.getCurrentDatabase());
            }
            if (tbl.getCols().size() == 0) {
                tbl.setFields(MetaStoreUtils.getFieldsFromDeserializer((String)tbl.getTableName(), (Deserializer)tbl.getDeserializer()));
            }
            tbl.checkValidity();
            if (tbl.getParameters() != null) {
                tbl.getParameters().remove("transient_lastDdlTime");
            }
            org.apache.hadoop.hive.metastore.api.Table tTbl = tbl.getTTable();
            PrincipalPrivilegeSet principalPrivs = new PrincipalPrivilegeSet();
            SessionState ss = SessionState.get();
            if (ss != null && (grants = ss.getCreateTableGrants()) != null) {
                principalPrivs.setUserPrivileges(grants.getUserGrants());
                principalPrivs.setGroupPrivileges(grants.getGroupGrants());
                principalPrivs.setRolePrivileges(grants.getRoleGrants());
                tTbl.setPrivileges(principalPrivs);
            }
            this.getMSC().createTable(tTbl);
        }
        catch (AlreadyExistsException e) {
            if (!ifNotExists) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void createIndex(String tableName, String indexName, String indexHandlerClass, List<String> indexedCols, String indexTblName, boolean deferredRebuild, String inputFormat, String outputFormat, String serde, String storageHandler, String location, Map<String, String> idxProps, Map<String, String> tblProps, Map<String, String> serdeProps, String collItemDelim, String fieldDelim, String fieldEscape, String lineDelim, String mapKeyDelim, String indexComment) throws HiveException {
        try {
            String dbName = this.getCurrentDatabase();
            Index old_index = null;
            try {
                old_index = this.getIndex(dbName, tableName, indexName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (old_index != null) {
                throw new HiveException("Index " + indexName + " already exists on table " + tableName + ", db=" + dbName);
            }
            org.apache.hadoop.hive.metastore.api.Table baseTbl = this.getMSC().getTable(dbName, tableName);
            if (baseTbl.getTableType() == TableType.VIRTUAL_VIEW.toString()) {
                throw new HiveException("tableName=" + tableName + " is a VIRTUAL VIEW. Index on VIRTUAL VIEW is not supported.");
            }
            if (indexTblName == null) {
                indexTblName = MetaStoreUtils.getIndexTableName((String)dbName, (String)tableName, (String)indexName);
            } else {
                org.apache.hadoop.hive.metastore.api.Table temp = null;
                try {
                    temp = this.getMSC().getTable(dbName, indexTblName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (temp != null) {
                    throw new HiveException("Table name " + indexTblName + " already exists. Choose another name.");
                }
            }
            StorageDescriptor storageDescriptor = baseTbl.getSd().deepCopy();
            SerDeInfo serdeInfo = storageDescriptor.getSerdeInfo();
            if (serde != null) {
                serdeInfo.setSerializationLib(serde);
            } else if (storageHandler == null) {
                serdeInfo.setSerializationLib(LazySimpleSerDe.class.getName());
            } else {
                HiveStorageHandler sh = HiveUtils.getStorageHandler(this.getConf(), storageHandler);
                String serDeClassName = sh.getSerDeClass().getName();
                serdeInfo.setSerializationLib(serDeClassName);
            }
            if (fieldDelim != null) {
                serdeInfo.getParameters().put("field.delim", fieldDelim);
                serdeInfo.getParameters().put("serialization.format", fieldDelim);
            }
            if (fieldEscape != null) {
                serdeInfo.getParameters().put("escape.delim", fieldEscape);
            }
            if (collItemDelim != null) {
                serdeInfo.getParameters().put("colelction.delim", collItemDelim);
            }
            if (mapKeyDelim != null) {
                serdeInfo.getParameters().put("mapkey.delim", mapKeyDelim);
            }
            if (lineDelim != null) {
                serdeInfo.getParameters().put("line.delim", lineDelim);
            }
            if (serdeProps != null) {
                for (Map.Entry<String, String> m : serdeProps.entrySet()) {
                    serdeInfo.getParameters().put(m.getKey(), m.getValue());
                }
            }
            storageDescriptor.setLocation(null);
            if (location != null) {
                storageDescriptor.setLocation(location);
            }
            storageDescriptor.setInputFormat(inputFormat);
            storageDescriptor.setOutputFormat(outputFormat);
            HashMap params = new HashMap();
            ArrayList<FieldSchema> indexTblCols = new ArrayList<FieldSchema>();
            ArrayList<Order> sortCols = new ArrayList<Order>();
            storageDescriptor.setBucketCols(null);
            int k = 0;
            for (int i = 0; i < storageDescriptor.getCols().size(); ++i) {
                FieldSchema col = (FieldSchema)storageDescriptor.getCols().get(i);
                if (!indexedCols.contains(col.getName())) continue;
                indexTblCols.add(col);
                sortCols.add(new Order(col.getName(), 1));
                ++k;
            }
            if (k != indexedCols.size()) {
                throw new RuntimeException("Check the index columns, they should appear in the table being indexed.");
            }
            storageDescriptor.setCols(indexTblCols);
            storageDescriptor.setSortCols(sortCols);
            int time = (int)(System.currentTimeMillis() / 1000L);
            org.apache.hadoop.hive.metastore.api.Table tt = null;
            HiveIndexHandler indexHandler = HiveUtils.getIndexHandler(this.getConf(), indexHandlerClass);
            if (indexHandler.usesIndexTable()) {
                tt = new Table(dbName, indexTblName).getTTable();
                List partKeys = baseTbl.getPartitionKeys();
                tt.setPartitionKeys(partKeys);
                tt.setTableType(TableType.INDEX_TABLE.toString());
                if (tblProps != null) {
                    for (Map.Entry<String, String> prop : tblProps.entrySet()) {
                        tt.putToParameters(prop.getKey(), prop.getValue());
                    }
                }
            }
            if (!deferredRebuild) {
                throw new RuntimeException("Please specify deferred rebuild using \" WITH DEFERRED REBUILD \".");
            }
            Index indexDesc = new Index(indexName, indexHandlerClass, dbName, tableName, time, time, indexTblName, storageDescriptor, params, deferredRebuild);
            indexDesc.getParameters().put("comment", indexComment);
            indexHandler.analyzeIndexDefinition(baseTbl, indexDesc, tt);
            if (idxProps != null) {
                indexDesc.getParameters().putAll(idxProps);
            }
            this.getMSC().createIndex(indexDesc, tt);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public Index getIndex(String baseTableName, String indexName) throws HiveException {
        return this.getIndex(this.getCurrentDatabase(), baseTableName, indexName);
    }

    public Index getIndex(String dbName, String baseTableName, String indexName) throws HiveException {
        try {
            return this.getMSC().getIndex(dbName, baseTableName, indexName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean dropIndex(String db_name, String tbl_name, String index_name, boolean deleteData) throws HiveException {
        try {
            return this.getMSC().dropIndex(db_name, tbl_name, index_name, deleteData);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException("Unknow error. Please check logs.", e);
        }
    }

    public void dropTable(String tableName) throws HiveException {
        this.dropTable(this.getCurrentDatabase(), tableName, true, true);
    }

    public void dropTable(String dbName, String tableName) throws HiveException {
        this.dropTable(dbName, tableName, true, true);
    }

    public void dropTable(String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws HiveException {
        try {
            this.getMSC().dropTable(dbName, tableName, deleteData, ignoreUnknownTab);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw new HiveException(e);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public Table getTable(String tableName) throws HiveException {
        return this.getTable(this.getCurrentDatabase(), tableName, true);
    }

    public Table getTable(String dbName, String tableName) throws HiveException {
        return this.getTable(dbName, tableName, true);
    }

    public Table getTable(String dbName, String tableName, boolean throwException) throws HiveException {
        if (tableName == null || tableName.equals("")) {
            throw new HiveException("empty table creation??");
        }
        org.apache.hadoop.hive.metastore.api.Table tTable = null;
        try {
            tTable = this.getMSC().getTable(dbName, tableName);
        }
        catch (NoSuchObjectException e) {
            if (throwException) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new InvalidTableException("Table " + tableName + " not found ", tableName);
            }
            return null;
        }
        catch (Exception e) {
            throw new HiveException("Unable to fetch table " + tableName, e);
        }
        if (!TableType.VIRTUAL_VIEW.toString().equals(tTable.getTableType())) {
            char[] b;
            Map parameters = tTable.getSd().getParameters();
            String sf = (String)parameters.get("serialization.format");
            if (sf != null && (b = sf.toCharArray()).length == 1 && b[0] < '\n') {
                parameters.put("serialization.format", Integer.toString(b[0]));
            }
            if (MetadataTypedColumnsetSerDe.class.getName().equals(tTable.getSd().getSerdeInfo().getSerializationLib()) && tTable.getSd().getColsSize() > 0 && ((FieldSchema)tTable.getSd().getCols().get(0)).getType().indexOf(60) == -1) {
                tTable.getSd().getSerdeInfo().setSerializationLib(LazySimpleSerDe.class.getName());
            }
        }
        Table table = new Table(tTable);
        table.checkValidity();
        return table;
    }

    public List<String> getAllTables() throws HiveException {
        return this.getAllTables(this.getCurrentDatabase());
    }

    public List<String> getAllTables(String dbName) throws HiveException {
        return this.getTablesByPattern(dbName, ".*");
    }

    public List<String> getTablesByPattern(String tablePattern) throws HiveException {
        return this.getTablesByPattern(this.getCurrentDatabase(), tablePattern);
    }

    public List<String> getTablesByPattern(String dbName, String tablePattern) throws HiveException {
        try {
            return this.getMSC().getTables(dbName, tablePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getTablesForDb(String database, String tablePattern) throws HiveException {
        try {
            return this.getMSC().getTables(database, tablePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllDatabases() throws HiveException {
        try {
            return this.getMSC().getAllDatabases();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getDatabasesByPattern(String databasePattern) throws HiveException {
        try {
            return this.getMSC().getDatabases(databasePattern);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantPrivileges(PrivilegeBag privileges) throws HiveException {
        try {
            return this.getMSC().grant_privileges(privileges);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokePrivileges(PrivilegeBag privileges) throws HiveException {
        try {
            return this.getMSC().revoke_privileges(privileges);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean databaseExists(String dbName) throws HiveException {
        return this.getDatabase(dbName) != null;
    }

    public Database getDatabase(String dbName) throws HiveException {
        try {
            return this.getMSC().getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void loadPartition(Path loadPath, String tableName, Map<String, String> partSpec, boolean replace, boolean holdDDLTime) throws HiveException {
        Table tbl = this.getTable(tableName);
        try {
            Partition oldPart = this.getPartition(tbl, partSpec, false, null);
            Path oldPartPath = null;
            if (oldPart != null) {
                oldPartPath = oldPart.getPartitionPath();
            }
            Path partPath = new Path(tbl.getDataLocation().getPath(), Warehouse.makePartPath(partSpec));
            Path newPartPath = new Path(loadPath.toUri().getScheme(), loadPath.toUri().getAuthority(), partPath.toUri().getPath());
            if (replace) {
                Hive.replaceFiles(loadPath, newPartPath, oldPartPath, this.getConf());
            } else {
                FileSystem fs = FileSystem.get((URI)tbl.getDataLocation(), (Configuration)this.getConf());
                Hive.copyFiles(loadPath, newPartPath, fs);
            }
            if (!holdDDLTime) {
                this.getPartition(tbl, partSpec, true, newPartPath.toString());
            }
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        catch (MetaException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
    }

    public ArrayList<LinkedHashMap<String, String>> loadDynamicPartitions(Path loadPath, String tableName, Map<String, String> partSpec, boolean replace, int numDP, boolean holdDDLTime) throws HiveException {
        try {
            ArrayList<LinkedHashMap<String, String>> fullPartSpecs = new ArrayList<LinkedHashMap<String, String>>();
            FileSystem fs = loadPath.getFileSystem((Configuration)this.conf);
            FileStatus[] status = Utilities.getFileStatusRecurse(loadPath, numDP, fs);
            if (status.length == 0) {
                LOG.warn((Object)"No partition is genereated by dynamic partitioning");
            }
            if (status.length > this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS)) {
                throw new HiveException("Number of dynamic partitions created is " + status.length + ", which is more than " + this.conf.getIntVar(HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS) + ". To solve this try to set " + HiveConf.ConfVars.DYNAMICPARTITIONMAXPARTS.varname + " to at least " + status.length + '.');
            }
            for (int i = 0; i < status.length; ++i) {
                Path partPath = status[i].getPath();
                assert (fs.getFileStatus(partPath).isDir()) : "partitions " + partPath + " is not a directory !";
                LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>(partSpec);
                Warehouse.makeSpecFromName(fullPartSpec, (Path)partPath);
                fullPartSpecs.add(fullPartSpec);
                this.loadPartition(partPath, tableName, fullPartSpec, replace, holdDDLTime);
                LOG.info((Object)("New loading path = " + partPath + " with partSpec " + fullPartSpec));
            }
            return fullPartSpecs;
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    public void loadTable(Path loadPath, String tableName, boolean replace, boolean holdDDLTime) throws HiveException {
        Table tbl = this.getTable(tableName);
        if (replace) {
            tbl.replaceFiles(loadPath);
        } else {
            tbl.copyFiles(loadPath);
        }
        if (!holdDDLTime) {
            try {
                this.alterTable(tableName, tbl);
            }
            catch (InvalidOperationException e) {
                throw new HiveException(e);
            }
        }
    }

    public Partition createPartition(Table tbl, Map<String, String> partSpec) throws HiveException {
        return this.createPartition(tbl, partSpec, null);
    }

    public Partition createPartition(Table tbl, Map<String, String> partSpec, Path location) throws HiveException {
        org.apache.hadoop.hive.metastore.api.Partition partition = null;
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val != null && val.length() != 0) continue;
            throw new HiveException("add partition: Value for key " + field.getName() + " is null or empty");
        }
        try {
            Partition tmpPart = new Partition(tbl, partSpec, location);
            partition = this.getMSC().add_partition(tmpPart.getTPartition());
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, partition);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate) throws HiveException {
        return this.getPartition(tbl, partSpec, forceCreate, null);
    }

    public Partition getPartition(Table tbl, Map<String, String> partSpec, boolean forceCreate, String partPath) throws HiveException {
        if (!tbl.isValidSpec(partSpec)) {
            throw new HiveException("Invalid partition: " + partSpec);
        }
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : tbl.getPartCols()) {
            String val = partSpec.get(field.getName());
            if (val == null && !HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONING) || val.length() == 0) {
                throw new HiveException("get partition: Value for key " + field.getName() + " is null or empty");
            }
            if (val == null) continue;
            pvals.add(val);
        }
        org.apache.hadoop.hive.metastore.api.Partition tpart = null;
        try {
            tpart = this.getMSC().getPartitionWithAuthInfo(tbl.getDbName(), tbl.getTableName(), pvals, this.getUserName(), this.getGroupNames());
        }
        catch (NoSuchObjectException nsoe) {
            tpart = null;
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        try {
            if (forceCreate) {
                if (tpart == null) {
                    LOG.debug((Object)("creating partition for table " + tbl.getTableName() + " with partition spec : " + partSpec));
                    tpart = this.getMSC().appendPartition(tbl.getDbName(), tbl.getTableName(), pvals);
                } else {
                    LOG.debug((Object)("altering partition for table " + tbl.getTableName() + " with partition spec : " + partSpec));
                    tpart.getSd().setOutputFormat(tbl.getTTable().getSd().getOutputFormat());
                    tpart.getSd().setInputFormat(tbl.getTTable().getSd().getInputFormat());
                    tpart.getSd().getSerdeInfo().setSerializationLib(tbl.getSerializationLib());
                    if (partPath == null || partPath.trim().equals("")) {
                        throw new HiveException("new partition path should not be null or empty.");
                    }
                    tpart.getSd().setLocation(partPath);
                    this.alterPartition(tbl.getTableName(), new Partition(tbl, tpart));
                }
            }
            if (tpart == null) {
                return null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return new Partition(tbl, tpart);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws HiveException {
        try {
            return this.getMSC().dropPartition(db_name, tbl_name, part_vals, deleteData);
        }
        catch (NoSuchObjectException e) {
            throw new HiveException("Partition or table doesn't exist.", e);
        }
        catch (Exception e) {
            throw new HiveException("Unknow error. Please check logs.", e);
        }
    }

    public List<String> getPartitionNames(String dbName, String tblName, short max) throws HiveException {
        List names = null;
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<String> getPartitionNames(String dbName, String tblName, Map<String, String> partSpec, short max) throws HiveException {
        List names = null;
        Table t = this.getTable(dbName, tblName);
        List<String> pvals = Hive.getPvals(t.getPartCols(), partSpec);
        try {
            names = this.getMSC().listPartitionNames(dbName, tblName, pvals, max);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return names;
    }

    public List<Partition> getPartitions(Table tbl) throws HiveException {
        if (tbl.isPartitioned()) {
            List tParts;
            try {
                tParts = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), (short)-1, this.getUserName(), this.getGroupNames());
            }
            catch (Exception e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                throw new HiveException(e);
            }
            ArrayList<Partition> parts = new ArrayList<Partition>(tParts.size());
            for (org.apache.hadoop.hive.metastore.api.Partition tpart : tParts) {
                parts.add(new Partition(tbl, tpart));
            }
            return parts;
        }
        Partition part = new Partition(tbl);
        ArrayList<Partition> parts = new ArrayList<Partition>(1);
        parts.add(part);
        return parts;
    }

    private static List<String> getPvals(List<FieldSchema> partCols, Map<String, String> partSpec) {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : partCols) {
            String val = partSpec.get(field.getName());
            if (val == null) {
                val = "";
            }
            pvals.add(val);
        }
        return pvals;
    }

    public List<Partition> getPartitions(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException("Partition spec should only be supplied for a partitioned table");
        }
        List<String> partialPvals = Hive.getPvals(tbl.getPartCols(), partialPartSpec);
        List partitions = null;
        try {
            partitions = this.getMSC().listPartitionsWithAuthInfo(tbl.getDbName(), tbl.getTableName(), partialPvals, (short)-1, this.getUserName(), this.getGroupNames());
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ArrayList<Partition> qlPartitions = new ArrayList<Partition>();
        for (org.apache.hadoop.hive.metastore.api.Partition p : partitions) {
            qlPartitions.add(new Partition(tbl, p));
        }
        return qlPartitions;
    }

    public List<Partition> getPartitionsByNames(Table tbl, Map<String, String> partialPartSpec) throws HiveException {
        if (!tbl.isPartitioned()) {
            throw new HiveException("Partition spec should only be supplied for a partitioned table");
        }
        List<String> names = this.getPartitionNames(tbl.getDbName(), tbl.getTableName(), partialPartSpec, (short)-1);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String pval : names) {
            try {
                org.apache.hadoop.hive.metastore.api.Partition tpart = this.getMSC().getPartition(tbl.getDbName(), tbl.getTableName(), pval);
                if (tpart == null) continue;
                Partition p = new Partition(tbl, tpart);
                partitions.add(p);
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        return partitions;
    }

    public String getCurrentDatabase() {
        if (null == this.currentDatabase) {
            this.currentDatabase = "default";
        }
        return this.currentDatabase;
    }

    public void setCurrentDatabase(String currentDatabase) {
        this.currentDatabase = currentDatabase;
    }

    public void createRole(String roleName, String ownerName) throws HiveException {
        try {
            this.getMSC().create_role(new Role(roleName, -1, ownerName));
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void dropRole(String roleName) throws HiveException {
        try {
            this.getMSC().drop_role(roleName);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<String> getAllRoleNames() throws HiveException {
        try {
            return this.getMSC().listRoleNames();
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<Role> showRoleGrant(String principalName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().list_roles(principalName, principalType);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws HiveException {
        try {
            return this.getMSC().grant_role(roleName, userName, principalType, grantor, grantorType, grantOption);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().revoke_role(roleName, userName, principalType);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<Role> listRoles(String userName, PrincipalType principalType) throws HiveException {
        try {
            return this.getMSC().list_roles(userName, principalType);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectType objectType, String db_name, String table_name, List<String> part_values, String column_name, String user_name, List<String> group_names) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, db_name, table_name, part_values, column_name);
            return this.getMSC().get_privilege_set(hiveObj, user_name, group_names);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public List<HiveObjectPrivilege> showPrivilegeGrant(HiveObjectType objectType, String principalName, PrincipalType principalType, String dbName, String tableName, List<String> partValues, String columnName) throws HiveException {
        try {
            HiveObjectRef hiveObj = new HiveObjectRef(objectType, dbName, tableName, partValues, columnName);
            return this.getMSC().list_privileges(principalName, principalType, hiveObj);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private static void checkPaths(FileSystem fs, FileStatus[] srcs, Path destf, boolean replace) throws HiveException {
        try {
            for (FileStatus src : srcs) {
                FileStatus[] items;
                for (FileStatus item : items = fs.listStatus(src.getPath())) {
                    Path itemStaging = item.getPath();
                    if (Utilities.isTempPath(item)) {
                        fs.delete(itemStaging, true);
                        continue;
                    }
                    if (item.isDir()) {
                        throw new HiveException("checkPaths: " + src.getPath() + " has nested directory" + itemStaging);
                    }
                    if (replace) continue;
                    int counter = 1;
                    Path itemDest = new Path(destf, itemStaging.getName());
                    while (fs.exists(itemDest)) {
                        Path proposedStaging = itemStaging.suffix("_copy_" + counter++);
                        Path proposedDest = new Path(destf, proposedStaging.getName());
                        if (fs.exists(proposedDest)) {
                            LOG.trace((Object)(proposedDest + " already exists"));
                            continue;
                        }
                        if (!fs.rename(itemStaging, proposedStaging)) {
                            LOG.debug((Object)("Unsuccessfully in attempt to rename " + itemStaging + " to " + proposedStaging + "..."));
                            continue;
                        }
                        LOG.debug((Object)("Successfully renamed " + itemStaging + " to " + proposedStaging));
                        itemDest = proposedDest;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new HiveException("checkPaths: filesystem error in check phase", e);
        }
    }

    protected static void copyFiles(Path srcf, Path destf, FileSystem fs) throws HiveException {
        FileStatus[] srcs;
        try {
            if (!fs.exists(destf)) {
                fs.mkdirs(destf);
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while checking/creating destination directory!!!", e);
        }
        try {
            srcs = fs.globStatus(srcf);
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException("addFiles: filesystem error in check phase", e);
        }
        if (srcs == null) {
            LOG.info((Object)("No sources specified to move: " + srcf));
            return;
        }
        Hive.checkPaths(fs, srcs, destf, false);
        try {
            for (FileStatus src : srcs) {
                FileStatus[] items;
                for (FileStatus item : items = fs.listStatus(src.getPath())) {
                    Path target;
                    Path source = item.getPath();
                    if (fs.rename(source, target = new Path(destf, item.getPath().getName()))) continue;
                    throw new IOException("Cannot move " + source + " to " + target);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException("copyFiles: error while moving files!!!", e);
        }
    }

    protected static void replaceFiles(Path srcf, Path destf, Path oldPath, Configuration conf) throws HiveException {
        try {
            FileStatus[] srcs;
            FileSystem fs = srcf.getFileSystem(conf);
            try {
                srcs = fs.globStatus(srcf);
            }
            catch (IOException e) {
                throw new HiveException("Getting globStatus " + srcf.toString(), e);
            }
            if (srcs == null) {
                LOG.info((Object)("No sources specified to move: " + srcf));
                return;
            }
            Hive.checkPaths(fs, srcs, destf, true);
            if (oldPath != null) {
                try {
                    FileSystem fs2 = oldPath.getFileSystem(conf);
                    if (fs2.exists(oldPath)) {
                        FsShell fshell = new FsShell();
                        fshell.setConf(conf);
                        fshell.run(new String[]{"-rmr", oldPath.toString()});
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Directory " + oldPath.toString() + " canot be removed."));
                }
            }
            if (srcs.length == 1 && srcs[0].isDir()) {
                boolean b;
                if (!fs.exists(destf.getParent())) {
                    fs.mkdirs(destf.getParent());
                }
                if (fs.exists(destf)) {
                    fs.delete(destf, true);
                }
                if (!(b = fs.rename(srcs[0].getPath(), destf))) {
                    throw new HiveException("Unable to move results from " + srcs[0].getPath() + " to destination directory: " + destf);
                }
                LOG.debug((Object)("Renaming:" + srcf.toString() + ",Status:" + b));
            } else {
                if (!fs.exists(destf)) {
                    fs.mkdirs(destf);
                }
                for (FileStatus src : srcs) {
                    Path destPath = new Path(destf, src.getPath().getName());
                    if (fs.rename(src.getPath(), destPath)) continue;
                    throw new HiveException("Error moving: " + src.getPath() + " into: " + destf);
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e.getMessage(), e);
        }
    }

    private IMetaStoreClient createMetaStoreClient() throws MetaException {
        HiveMetaHookLoader hookLoader = new HiveMetaHookLoader(){

            public HiveMetaHook getHook(org.apache.hadoop.hive.metastore.api.Table tbl) throws MetaException {
                try {
                    if (tbl == null) {
                        return null;
                    }
                    HiveStorageHandler storageHandler = HiveUtils.getStorageHandler(Hive.this.conf, (String)tbl.getParameters().get("storage_handler"));
                    if (storageHandler == null) {
                        return null;
                    }
                    return storageHandler.getMetaHook();
                }
                catch (HiveException ex) {
                    LOG.error((Object)StringUtils.stringifyException((Throwable)ex));
                    throw new MetaException("Failed to load storage handler:  " + ex.getMessage());
                }
            }
        };
        return new HiveMetaStoreClient(this.conf, hookLoader);
    }

    private IMetaStoreClient getMSC() throws MetaException {
        if (this.metaStoreClient == null) {
            this.metaStoreClient = this.createMetaStoreClient();
        }
        return this.metaStoreClient;
    }

    private String getUserName() {
        SessionState ss = SessionState.get();
        if (ss != null && ss.getAuthenticator() != null) {
            return ss.getAuthenticator().getUserName();
        }
        return null;
    }

    private List<String> getGroupNames() {
        SessionState ss = SessionState.get();
        if (ss != null && ss.getAuthenticator() != null) {
            return ss.getAuthenticator().getGroupNames();
        }
        return null;
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String name, Deserializer serde) throws HiveException {
        try {
            return MetaStoreUtils.getFieldsFromDeserializer((String)name, (Deserializer)serde);
        }
        catch (SerDeException e) {
            throw new HiveException("Error in getting fields from serde. " + e.getMessage(), e);
        }
        catch (MetaException e) {
            throw new HiveException("Error in getting fields from serde." + e.getMessage(), e);
        }
    }

    public List<Index> getIndexes(String dbName, String tblName, short max) throws HiveException {
        List indexes = null;
        try {
            indexes = this.getMSC().listIndexes(dbName, tblName, max);
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new HiveException(e);
        }
        return indexes;
    }
}

