/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public final class StructTypeInfo
extends TypeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> allStructFieldNames;
    private ArrayList<TypeInfo> allStructFieldTypeInfos;

    public StructTypeInfo() {
    }

    @Override
    public String getTypeName() {
        StringBuilder sb = new StringBuilder();
        sb.append("struct<");
        for (int i = 0; i < this.allStructFieldNames.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.allStructFieldNames.get(i));
            sb.append(":");
            sb.append(this.allStructFieldTypeInfos.get(i).getTypeName());
        }
        sb.append(">");
        return sb.toString();
    }

    public void setAllStructFieldNames(ArrayList<String> allStructFieldNames) {
        this.allStructFieldNames = allStructFieldNames;
    }

    public void setAllStructFieldTypeInfos(ArrayList<TypeInfo> allStructFieldTypeInfos) {
        this.allStructFieldTypeInfos = allStructFieldTypeInfos;
    }

    StructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        this.allStructFieldNames = new ArrayList();
        this.allStructFieldNames.addAll(names);
        this.allStructFieldTypeInfos = new ArrayList();
        this.allStructFieldTypeInfos.addAll(typeInfos);
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public ArrayList<String> getAllStructFieldNames() {
        return this.allStructFieldNames;
    }

    public ArrayList<TypeInfo> getAllStructFieldTypeInfos() {
        return this.allStructFieldTypeInfos;
    }

    public TypeInfo getStructFieldTypeInfo(String field) {
        String fieldLowerCase = field.toLowerCase();
        for (int i = 0; i < this.allStructFieldNames.size(); ++i) {
            if (!fieldLowerCase.equals(this.allStructFieldNames.get(i))) continue;
            return this.allStructFieldTypeInfos.get(i);
        }
        throw new RuntimeException("cannot find field " + field + "(lowercase form: " + fieldLowerCase + ") in " + this.allStructFieldNames);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructTypeInfo)) {
            return false;
        }
        StructTypeInfo o = (StructTypeInfo)other;
        Iterator<String> namesIterator = this.getAllStructFieldNames().iterator();
        Iterator<String> otherNamesIterator = o.getAllStructFieldNames().iterator();
        while (namesIterator.hasNext() && otherNamesIterator.hasNext()) {
            if (namesIterator.next().equalsIgnoreCase(otherNamesIterator.next())) continue;
            return false;
        }
        if (namesIterator.hasNext() || otherNamesIterator.hasNext()) {
            return false;
        }
        return o.getAllStructFieldTypeInfos().equals(this.getAllStructFieldTypeInfos());
    }

    @Override
    public int hashCode() {
        return this.allStructFieldNames.hashCode() ^ this.allStructFieldTypeInfos.hashCode();
    }
}

