/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.LazyHBaseRow;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class HBaseSerDe
implements SerDe {
    public static final String HBASE_COLUMNS_MAPPING = "hbase.columns.mapping";
    public static final String HBASE_TABLE_NAME = "hbase.table.name";
    public static final String HBASE_KEY_COL = ":key";
    public static final Log LOG = LogFactory.getLog(HBaseSerDe.class);
    private ObjectInspector cachedObjectInspector;
    private String hbaseColumnsMapping;
    private List<String> hbaseColumnFamilies;
    private List<byte[]> hbaseColumnFamiliesBytes;
    private List<String> hbaseColumnQualifiers;
    private List<byte[]> hbaseColumnQualifiersBytes;
    private LazySimpleSerDe.SerDeParameters serdeParams;
    private boolean useJSONSerialize;
    private LazyHBaseRow cachedHBaseRow;
    private final ByteStream.Output serializeStream = new ByteStream.Output();
    private int iKey;
    private byte[] separators;
    private boolean escaped;
    private byte escapeChar;
    private boolean[] needsEscape;

    public String toString() {
        return this.getClass().toString() + "[" + this.hbaseColumnsMapping + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames() + ":" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldTypeInfos() + "]";
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.initHBaseSerDeParameters(conf, tbl, this.getClass().getName());
        this.cachedObjectInspector = LazyFactory.createLazyStructInspector((List)this.serdeParams.getColumnNames(), (List)this.serdeParams.getColumnTypes(), (byte[])this.serdeParams.getSeparators(), (Text)this.serdeParams.getNullSequence(), (boolean)this.serdeParams.isLastColumnTakesRest(), (boolean)this.serdeParams.isEscaped(), (byte)this.serdeParams.getEscapeChar());
        this.cachedHBaseRow = new LazyHBaseRow((LazySimpleStructObjectInspector)this.cachedObjectInspector);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HBaseSerDe initialized with : columnNames = " + this.serdeParams.getColumnNames() + " columnTypes = " + this.serdeParams.getColumnTypes() + " hbaseColumnMapping = " + this.hbaseColumnsMapping));
        }
    }

    public static int parseColumnMapping(String columnMapping, List<String> colFamilies, List<byte[]> colFamiliesBytes, List<String> colQualifiers, List<byte[]> colQualifiersBytes) throws SerDeException {
        int rowKeyIndex = -1;
        if (colFamilies == null || colQualifiers == null) {
            throw new SerDeException("Error: caller must pass in lists for the column families and qualifiers.");
        }
        colFamilies.clear();
        colQualifiers.clear();
        if (columnMapping == null) {
            throw new SerDeException("Error: hbase.columns.mapping missing for this HBase table.");
        }
        if (columnMapping.equals("") || columnMapping.equals(HBASE_KEY_COL)) {
            throw new SerDeException("Error: hbase.columns.mapping specifies only the HBase table row key. A valid Hive-HBase table must specify at least one additional column.");
        }
        String[] mapping = columnMapping.split(",");
        for (int i = 0; i < mapping.length; ++i) {
            String elem = mapping[i];
            int idxFirst = elem.indexOf(":");
            int idxLast = elem.lastIndexOf(":");
            if (idxFirst < 0 || idxFirst != idxLast) {
                throw new SerDeException("Error: the HBase columns mapping contains a badly formed column family, column qualifier specification.");
            }
            if (elem.equals(HBASE_KEY_COL)) {
                rowKeyIndex = i;
                colFamilies.add(elem);
                colQualifiers.add(null);
                continue;
            }
            String[] parts = elem.split(":");
            assert (parts.length > 0 && parts.length <= 2);
            colFamilies.add(parts[0]);
            if (parts.length == 2) {
                colQualifiers.add(parts[1]);
                continue;
            }
            colQualifiers.add(null);
        }
        if (rowKeyIndex == -1) {
            colFamilies.add(0, HBASE_KEY_COL);
            colQualifiers.add(0, null);
            rowKeyIndex = 0;
        }
        if (colFamilies.size() != colQualifiers.size()) {
            throw new SerDeException("Error in parsing the hbase columns mapping.");
        }
        if (colFamiliesBytes != null) {
            colFamiliesBytes.clear();
            for (String fam : colFamilies) {
                colFamiliesBytes.add(Bytes.toBytes((String)fam));
            }
        }
        if (colQualifiersBytes != null) {
            colQualifiersBytes.clear();
            for (String qual : colQualifiers) {
                if (qual == null) {
                    colQualifiersBytes.add(null);
                    continue;
                }
                colQualifiersBytes.add(Bytes.toBytes((String)qual));
            }
        }
        if (colFamiliesBytes != null && colQualifiersBytes != null && colFamiliesBytes.size() != colQualifiersBytes.size()) {
            throw new SerDeException("Error in caching the bytes for the hbase column families and qualifiers.");
        }
        return rowKeyIndex;
    }

    public static boolean isSpecialColumn(String hbaseColumnName) {
        return hbaseColumnName.equals(HBASE_KEY_COL);
    }

    private void initHBaseSerDeParameters(Configuration job, Properties tbl, String serdeName) throws SerDeException {
        this.hbaseColumnsMapping = tbl.getProperty(HBASE_COLUMNS_MAPPING);
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.hbaseColumnFamilies = new ArrayList<String>();
        this.hbaseColumnFamiliesBytes = new ArrayList<byte[]>();
        this.hbaseColumnQualifiers = new ArrayList<String>();
        this.hbaseColumnQualifiersBytes = new ArrayList<byte[]>();
        this.iKey = HBaseSerDe.parseColumnMapping(this.hbaseColumnsMapping, this.hbaseColumnFamilies, this.hbaseColumnFamiliesBytes, this.hbaseColumnQualifiers, this.hbaseColumnQualifiersBytes);
        if (columnTypeProperty == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.hbaseColumnFamilies.size(); ++i) {
                if (sb.length() > 0) {
                    sb.append(":");
                }
                String colFamily = this.hbaseColumnFamilies.get(i);
                String colQualifier = this.hbaseColumnQualifiers.get(i);
                if (HBaseSerDe.isSpecialColumn(colFamily)) {
                    sb.append("string");
                    continue;
                }
                if (colQualifier == null) {
                    sb.append("map<string,string>");
                    continue;
                }
                sb.append("string");
            }
            tbl.setProperty("columns.types", sb.toString());
        }
        this.serdeParams = LazySimpleSerDe.initSerdeParams((Configuration)job, (Properties)tbl, (String)serdeName);
        if (this.hbaseColumnFamilies.size() != this.serdeParams.getColumnNames().size()) {
            throw new SerDeException(serdeName + ": columns has " + this.serdeParams.getColumnNames().size() + " elements while hbase.columns.mapping has " + this.hbaseColumnFamilies.size() + " elements" + " (counting the key if implicit)");
        }
        this.separators = this.serdeParams.getSeparators();
        this.escaped = this.serdeParams.isEscaped();
        this.escapeChar = this.serdeParams.getEscapeChar();
        this.needsEscape = this.serdeParams.getNeedsEscape();
        for (int i = 0; i < this.hbaseColumnFamilies.size(); ++i) {
            TypeInfo typeInfo;
            String colFamily = this.hbaseColumnFamilies.get(i);
            String colQualifier = this.hbaseColumnQualifiers.get(i);
            if (colQualifier != null || HBaseSerDe.isSpecialColumn(colFamily) || (typeInfo = (TypeInfo)this.serdeParams.getColumnTypes().get(i)).getCategory() == ObjectInspector.Category.MAP && ((MapTypeInfo)typeInfo).getMapKeyTypeInfo().getTypeName() == "string") continue;
            throw new SerDeException(serdeName + ": hbase column family '" + colFamily + "' should be mapped to Map<String,?> but is mapped to " + typeInfo.getTypeName());
        }
    }

    public Object deserialize(Writable result) throws SerDeException {
        if (!(result instanceof Result)) {
            throw new SerDeException(this.getClass().getName() + ": expects Result!");
        }
        this.cachedHBaseRow.init((Result)result, this.hbaseColumnFamilies, this.hbaseColumnFamiliesBytes, this.hbaseColumnQualifiers, this.hbaseColumnQualifiersBytes);
        return this.cachedHBaseRow;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.cachedObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Put.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List list = soi.getStructFieldsDataAsList(obj);
        List declaredFields = this.serdeParams.getRowTypeInfo() != null && ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames().size() > 0 ? ((StructObjectInspector)this.getObjectInspector()).getAllStructFieldRefs() : null;
        Put put = null;
        try {
            byte[] key = this.serializeField(this.iKey, null, fields, list, declaredFields);
            if (key == null) {
                throw new SerDeException("HBase row key cannot be NULL");
            }
            put = new Put(key);
            for (int i = 0; i < fields.size(); ++i) {
                if (i == this.iKey) continue;
                this.serializeField(i, put, fields, list, declaredFields);
            }
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        return put;
    }

    private byte[] serializeField(int i, Put put, List<? extends StructField> fields, List<Object> list, List<? extends StructField> declaredFields) throws IOException {
        Object f;
        String hbaseColumnFamily = this.hbaseColumnFamilies.get(i);
        String hbaseColumnQualifier = this.hbaseColumnQualifiers.get(i);
        ObjectInspector foi = fields.get(i).getFieldObjectInspector();
        Object object = f = list == null ? null : list.get(i);
        if (f == null) {
            return null;
        }
        if (hbaseColumnQualifier == null && !HBaseSerDe.isSpecialColumn(hbaseColumnFamily)) {
            MapObjectInspector moi = (MapObjectInspector)foi;
            ObjectInspector koi = moi.getMapKeyObjectInspector();
            ObjectInspector voi = moi.getMapValueObjectInspector();
            Map map = moi.getMap(f);
            if (map == null) {
                return null;
            }
            for (Map.Entry entry : map.entrySet()) {
                this.serializeStream.reset();
                this.serialize(entry.getKey(), koi, 3);
                byte[] columnQualifierBytes = new byte[this.serializeStream.getCount()];
                System.arraycopy(this.serializeStream.getData(), 0, columnQualifierBytes, 0, this.serializeStream.getCount());
                this.serializeStream.reset();
                boolean isNotNull = this.serialize(entry.getValue(), voi, 3);
                if (!isNotNull) continue;
                byte[] value = new byte[this.serializeStream.getCount()];
                System.arraycopy(this.serializeStream.getData(), 0, value, 0, this.serializeStream.getCount());
                put.add(this.hbaseColumnFamiliesBytes.get(i), columnQualifierBytes, value);
            }
        } else {
            this.serializeStream.reset();
            boolean isNotNull = !foi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && (declaredFields == null || declaredFields.get(i).getFieldObjectInspector().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || this.useJSONSerialize) ? this.serialize(SerDeUtils.getJSONString((Object)f, (ObjectInspector)foi), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, 1) : this.serialize(f, foi, 1);
            if (!isNotNull) {
                return null;
            }
            byte[] key = new byte[this.serializeStream.getCount()];
            System.arraycopy(this.serializeStream.getData(), 0, key, 0, this.serializeStream.getCount());
            if (i == this.iKey) {
                return key;
            }
            put.add(this.hbaseColumnFamiliesBytes.get(i), this.hbaseColumnQualifiersBytes.get(i), key);
        }
        return null;
    }

    private boolean serialize(Object obj, ObjectInspector objInspector, int level) throws IOException {
        switch (objInspector.getCategory()) {
            case PRIMITIVE: {
                LazyUtils.writePrimitiveUTF8((OutputStream)this.serializeStream, (Object)obj, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector), (boolean)this.escaped, (byte)this.escapeChar, (boolean[])this.needsEscape);
                return true;
            }
            case LIST: {
                char separator = (char)this.separators[level];
                ListObjectInspector loi = (ListObjectInspector)objInspector;
                List list = loi.getList(obj);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), eoi, level + 1);
                }
                return true;
            }
            case MAP: {
                char separator = (char)this.separators[level];
                char keyValueSeparator = (char)this.separators[level + 1];
                MapObjectInspector moi = (MapObjectInspector)objInspector;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(obj);
                if (map == null) {
                    return false;
                }
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(entry.getKey(), koi, level + 2);
                    this.serializeStream.write((int)keyValueSeparator);
                    this.serialize(entry.getValue(), voi, level + 2);
                }
                return true;
            }
            case STRUCT: {
                char separator = (char)this.separators[level];
                StructObjectInspector soi = (StructObjectInspector)objInspector;
                List fields = soi.getAllStructFieldRefs();
                List list = soi.getStructFieldsDataAsList(obj);
                if (list == null) {
                    return false;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        this.serializeStream.write((int)separator);
                    }
                    this.serialize(list.get(i), ((StructField)fields.get(i)).getFieldObjectInspector(), level + 1);
                }
                return true;
            }
        }
        throw new RuntimeException("Unknown category type: " + objInspector.getCategory());
    }

    public boolean isUseJSONSerialize() {
        return this.useJSONSerialize;
    }

    public void setUseJSONSerialize(boolean useJSONSerialize) {
        this.useJSONSerialize = useJSONSerialize;
    }

    int getKeyColumnOffset() {
        return this.iKey;
    }
}

